/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.query.AbstractAmberExpr;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.JoinExpr;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.QueryParser;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndExpr
extends AbstractAmberExpr {
    private ArrayList<AmberExpr> _components = new ArrayList();

    public static AmberExpr create(AmberExpr left, AmberExpr right) throws QueryParseException {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right.createBoolean();
        }
        if (right == null) {
            return left.createBoolean();
        }
        if (left instanceof AndExpr) {
            AndExpr and = (AndExpr)left;
            and.add(right.createBoolean());
            return and;
        }
        if (right instanceof AndExpr) {
            AndExpr and = (AndExpr)right;
            and.add(left.createBoolean());
            return and;
        }
        AndExpr and = new AndExpr();
        and.add(left.createBoolean());
        and.add(right.createBoolean());
        return and;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    void add(AmberExpr expr) {
        this._components.add(expr);
    }

    ArrayList<AmberExpr> getComponents() {
        return this._components;
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.bindSelect(parser);
            this._components.set(i, expr);
        }
        return this;
    }

    public AmberExpr getSingle() {
        if (this._components.size() == 0) {
            return null;
        }
        if (this._components.size() == 1) {
            return this._components.get(0);
        }
        return this;
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        if (type == 1) {
            for (int i = 0; i < this._components.size(); ++i) {
                AmberExpr expr = this._components.get(i);
                if (!isNot && expr.usesFrom(from, type, isNot)) {
                    return true;
                }
                if (!isNot || expr.usesFrom(from, type, isNot)) continue;
                return false;
            }
            return false;
        }
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            if (!expr.usesFrom(from, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AmberExpr replaceJoin(JoinExpr join) {
        for (int i = 0; i < this._components.size(); ++i) {
            AmberExpr expr = this._components.get(i);
            expr = expr.replaceJoin(join);
            this._components.set(i, expr);
        }
        return this;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            AmberExpr expr = this._components.get(i);
            expr.generateWhere(cb);
        }
        cb.append(')');
    }

    @Override
    public void generateJoin(CharBuffer cb) {
        cb.append('(');
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            AmberExpr expr = this._components.get(i);
            expr.generateJoin(cb);
        }
        cb.append(')');
    }
}

