/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.hibernate;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.hibernate.HibernateColumn;
import com.caucho.amber.hibernate.HibernateField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class HibernateProperty
extends HibernateField {
    private static final L10N L = new L10N(HibernateProperty._resin_compat_class_0());
    private PropertyField _field;
    private HibernateColumn _column = new HibernateColumn();
    private static Class _resin_compat_class_0;

    HibernateProperty(EntityType type) {
        super(type);
        this._field = new PropertyField(type);
        this.setField(this._field);
    }

    public void setName(String name) throws ConfigException {
        super.setName(name);
        this._column.setName(name);
        JMethod getter = this._field.getGetterMethod();
        if (getter != null && getter.getReturnType().isPrimitive()) {
            this._column.setNotNull(true);
        }
    }

    protected void setField(AbstractField field) {
        super.setField(field);
        this._field = (PropertyField)field;
    }

    public HibernateColumn createColumn() {
        return this._column;
    }

    public void setNotNull(boolean isNotNull) {
        this._column.setNotNull(isNotNull);
    }

    public void setLength(int length) {
        this._column.setLength(length);
    }

    public void setSQLType(String sqlType) {
        this._column.setSQLType(sqlType);
    }

    public void setUnique(boolean isUnique) {
        this._column.setUnique(isUnique);
    }

    public void setUniqueKey(String uniqueKey) {
        this._column.setUniqueKey(uniqueKey);
    }

    public void setIndex(String index) {
        this._column.setIndex(index);
    }

    public void setInsert(boolean isInsert) {
        this._field.setInsert(isInsert);
    }

    public void setUpdate(boolean isUpdate) {
        this._field.setUpdate(isUpdate);
    }

    public void init() throws ConfigException {
        super.init();
        this._field.setType(this.getType());
        Column column = this.getOwnerType().getTable().createColumn(this._column.getName(), this.getType());
        column.setNotNull(this._column.getNotNull());
        column.setUnique(this._column.getUnique());
        column.setLength(this._column.getLength());
        column.setSQLType(this._column.getSQLType());
        this._field.setColumn(column);
        this.getOwnerType().addField(this._field);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.hibernate.HibernateProperty");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

