/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.hibernate;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

public class HibernateField {
    private static final L10N L = new L10N(HibernateField._resin_compat_class_0());
    private EntityType _type;
    private AbstractField _field;
    private Type _resultType;
    private static Class _resin_compat_class_0;

    HibernateField(EntityType type) {
        this._type = type;
    }

    protected void setField(AbstractField field) {
        this._field = field;
    }

    public void setName(String name) throws ConfigException {
        this._field.setName(name);
    }

    public void setType(String type) throws ConfigException {
        this._resultType = this._type.getAmberManager().createType(type);
    }

    public Type getType() {
        return this._resultType;
    }

    EntityType getOwnerType() {
        return this._type;
    }

    public void init() throws ConfigException {
        if (this._resultType == null) {
            JMethod method = this._field.getGetterMethod();
            if (method != null) {
                JClass resultClass = method.getReturnType();
                this._resultType = this._type.getAmberManager().createType(resultClass);
            } else {
                this._resultType = this._type.getAmberManager().createType("string");
            }
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.hibernate.HibernateField");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

