/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.gen;

import com.caucho.amber.AmberManager;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.EntityComponent;
import com.caucho.amber.gen.EntityGenerator;
import com.caucho.amber.type.EntityType;
import com.caucho.java.JavaCompiler;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.GenClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;

public class AmberGeneratorImpl
implements AmberGenerator {
    private static final L10N L = new L10N(AmberGeneratorImpl._resin_compat_class_1());
    private static final Logger log = Log.open(AmberGeneratorImpl._resin_compat_class_1());
    private AmberManager _amberManager;
    private ArrayList<String> _pendingClassNames = new ArrayList();
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public AmberGeneratorImpl(AmberManager manager) {
        this._amberManager = manager;
    }

    public void configure(EntityType type) throws Exception {
    }

    public void generate(EntityType type) throws Exception {
        this.generateJava(null, type);
    }

    public void generateJava(JavaClassGenerator javaGen, EntityType type) throws Exception {
        if (this.isPreload(javaGen, type) || type.isGenerated()) {
            return;
        }
        type.setGenerated(true);
        GenClass genClass = new GenClass(type.getInstanceClassName());
        genClass.setSuperClassName(type.getBeanClass().getName());
        genClass.addInterfaceName("com.caucho.amber.entity.Entity");
        EntityComponent entity = new EntityComponent();
        entity.setEntityType(type);
        entity.setBaseClassName(type.getBeanClass().getName());
        entity.setExtClassName(type.getInstanceClassName());
        genClass.addComponent(entity);
        DependencyComponent depend = genClass.addDependencyComponent();
        depend.addDependencyList(entity.getDependencies());
        javaGen.generate(genClass);
    }

    public boolean isPreload(JavaClassGenerator javaGen, EntityType type) throws Exception {
        Class cl = type.isEnhanced() ? javaGen.loadClass(type.getBeanClass().getName()) : javaGen.preload(type.getInstanceClassName());
        return cl != null && AmberGeneratorImpl._resin_compat_class_0().isAssignableFrom(cl);
    }

    public void compile() throws Exception {
        if (this._pendingClassNames.size() == 0) {
            return;
        }
        String[] javaFiles = new String[this._pendingClassNames.size()];
        for (int i = 0; i < this._pendingClassNames.size(); ++i) {
            String name = this._pendingClassNames.get(i);
            javaFiles[i] = name = new CharBuffer().append(name.replace('.', '/')).append(".java").toString();
        }
        this._pendingClassNames.clear();
        EntityGenerator gen = new EntityGenerator();
        JavaCompiler compiler = gen.getCompiler();
        compiler.compileBatch(javaFiles);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.entity.Entity");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("com.caucho.amber.gen.AmberGeneratorImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

