/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ColumnExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyField
extends AbstractField {
    private static final L10N L = new L10N(PropertyField._resin_compat_class_0());
    protected static final Logger log = Log.open(PropertyField._resin_compat_class_0());
    private Column _column;
    private Type _type;
    private KeyManyToOneField _aliasKey;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;
    private static Class _resin_compat_class_0;

    public PropertyField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public PropertyField(EntityType entityType) {
        super(entityType);
    }

    public void setType(Type type) {
        this._type = type;
    }

    public Type getType() {
        return this._type;
    }

    @Override
    public Table getTable() {
        return this.getColumn().getTable();
    }

    public void setColumn(Column column) {
        this._column = column;
    }

    public Column getColumn() {
        return this._column;
    }

    public void setInsert(boolean isInsert) {
        this._isInsert = isInsert;
    }

    public void setUpdate(boolean isUpdate) {
        this._isUpdate = isUpdate;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        if (this.getColumn() == null) {
            throw new IllegalStateException(L.l("column must be set before init"));
        }
        if (this.getSourceType().getId() != null) {
            for (IdField field : this.getSourceType().getId().getKeys()) {
                if (!(field instanceof KeyManyToOneField)) continue;
                KeyManyToOneField key = (KeyManyToOneField)field;
                for (ForeignColumn column : key.getLinkColumns().getColumns()) {
                    if (!this.getColumn().getName().equals(column.getName())) continue;
                    this._aliasKey = key;
                }
            }
        }
    }

    @Override
    public String generateNull() {
        return this.getType().generateNull();
    }

    @Override
    protected String getFieldName() {
        return this.getColumn().getFieldName();
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null) {
            return;
        }
        out.println();
        out.println(new CharBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null)");
        out.println(new CharBuffer().append("  __caucho_load_").append(this.getLoadGroupIndex()).append("(__caucho_session);").toString());
        out.println();
        out.println(new CharBuffer().append("return ").append(this.generateSuperGetter()).append(";").toString());
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        if (!this.isFieldAccess() && (this.getGetterMethod() == null || this.getSetterMethod() == null && !this.isAbstract())) {
            return;
        }
        out.println();
        out.println(new CharBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        if (!this._isUpdate) {
            out.println("if (__caucho_session == null)");
            out.println(new CharBuffer().append("  ").append(this.generateSuperSetter("v")).append(";").toString());
        } else {
            out.println(new CharBuffer().append(this.getJavaTypeName()).append(" oldValue = ").append(this.generateSuperGetter()).append(";").toString());
            int maskGroup = this.getLoadGroupIndex() / 64;
            String loadVar = new CharBuffer().append("__caucho_loadMask_").append(maskGroup).toString();
            long mask = 1L << this.getLoadGroupIndex() % 64;
            if (this.getJavaTypeName().equals("java.lang.String")) {
                out.println(new CharBuffer().append("if ((oldValue == v || v != null && v.equals(oldValue)) && (").append(loadVar).append(" & ").append(mask).append("L) != 0L)").toString());
                out.println("  return;");
            } else {
                out.println(new CharBuffer().append("if (oldValue == v && (").append(loadVar).append(" & ").append(mask).append("L) != 0)").toString());
                out.println("  return;");
            }
            out.println(new CharBuffer().append(this.generateSuperSetter("v")).append(";").toString());
            int dirtyGroup = this.getIndex() / 64;
            String dirtyVar = new CharBuffer().append("__caucho_dirtyMask_").append(dirtyGroup).toString();
            long dirtyMask = 1L << this.getIndex() % 64;
            out.println();
            out.println(new CharBuffer().append("long oldMask = ").append(dirtyVar).append(";").toString());
            out.println(new CharBuffer().append(dirtyVar).append(" |= ").append(dirtyMask).append("L;").toString());
            out.println();
            out.println("if (__caucho_session != null && oldMask == 0)");
            out.println("  __caucho_session.update(this);");
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        if (this.getColumn().getTable() != table) {
            return null;
        }
        return this.generateSelect(id);
    }

    @Override
    public String generateSelect(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public String generateWhere(String id) {
        return this.getColumn().generateSelect(id);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert && this._aliasKey == null) {
            columns.add(this.getColumn().getName());
        }
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._isUpdate && this._aliasKey == null) {
            sql.append(this.getColumn().generateUpdateSet());
        }
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._aliasKey == null) {
            if (this._isInsert) {
                this.generateSet(out, pstmt, index, obj);
            } else if (this.getLoadGroupIndex() != 0) {
                int groupIndex = this.getLoadGroupIndex();
                int group = groupIndex / 64;
                long groupMask = 1L << groupIndex % 64;
                out.println(new CharBuffer().append("__caucho_loadMask_").append(group).append(" &= ~").append(groupMask).append("L;").toString());
            }
        }
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (this._isUpdate && this._aliasKey == null) {
            this.generateSet(out, pstmt, index, obj);
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        if (!this.isFieldAccess() && this.getGetterMethod() == null || this._aliasKey != null) {
            return;
        }
        this.getColumn().generateSet(out, pstmt, index, this.generateGet(obj));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._aliasKey != null) {
            return index;
        }
        String var = new CharBuffer().append("amber_ld").append(index).toString();
        out.print(this.getJavaTypeName());
        out.print(new CharBuffer().append(" ").append(var).append(" = ").toString());
        index = this.getColumn().generateLoad(out, rs, indexVar, index);
        out.println(";");
        out.println(new CharBuffer().append(this.generateSuperSetter(var)).append(";").toString());
        return index;
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ColumnExpr(parent, this.getColumn());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.field.PropertyField");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

