/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AssociationField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.OneToManyExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManyToManyField
extends AssociationField {
    private static final L10N L = new L10N(EntityManyToManyField._resin_compat_class_0());
    protected static final Logger log = Log.open(EntityManyToManyField._resin_compat_class_0());
    private EntityType _targetType;
    private Table _associationTable;
    private LinkColumns _sourceLink;
    private LinkColumns _targetLink;
    private ArrayList<String> _orderByFields;
    private ArrayList<Boolean> _orderByAscending;
    private static Class _resin_compat_class_0;

    public EntityManyToManyField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public EntityManyToManyField(EntityType entityType) {
        super(entityType);
    }

    @Override
    public void setType(Type targetType) {
        this._targetType = (EntityType)targetType;
        super.setType(targetType);
    }

    @Override
    public EntityType getTargetType() {
        return this._targetType;
    }

    public Table getAssociationTable() {
        return this._associationTable;
    }

    public void setAssociationTable(Table table) {
        this._associationTable = table;
    }

    public void setSourceLink(LinkColumns link) {
        this._sourceLink = link;
    }

    public LinkColumns getSourceLink() {
        return this._sourceLink;
    }

    public void setTargetLink(LinkColumns link) {
        this._targetLink = link;
    }

    public LinkColumns getTargetLink() {
        return this._targetLink;
    }

    public void setOrderBy(ArrayList<String> orderByFields, ArrayList<Boolean> orderByAscending) {
        this._orderByFields = orderByFields;
        this._orderByAscending = orderByAscending;
    }

    @Override
    public void init() throws ConfigException {
        this._targetLink.setSourceCascadeDelete(true);
        this._sourceLink.setSourceCascadeDelete(true);
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ManyToOneExpr(new OneToManyExpr(parser, parent, this._sourceLink), this._targetLink);
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    @Override
    public String generateTargetSelect(String id) {
        return this.getTargetType().getId().generateSelect(id);
    }

    public String generateTargetLoadSelect(String id) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(this.getTargetType().getId().generateLoadSelect(id));
        String value = this.getTargetType().generateLoadSelect(id);
        if (cb.length() > 0 && value.length() > 0) {
            cb.append(", ");
        }
        cb.append(value);
        return cb.close();
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        String var = new CharBuffer().append("_caucho_").append(this.getGetterName()).toString();
        JType type = this.getJavaType();
        JType[] paramArgs = type.getActualTypeArguments();
        JType param = paramArgs.length > 0 ? paramArgs[0] : null;
        out.print("private com.caucho.amber.collection.CollectionImpl");
        if (param != null) {
            out.print(new CharBuffer().append("<").append(param.getPrintName()).append(">").toString());
        }
        out.println(new CharBuffer().append(" ").append(var).append(";").toString());
        out.println();
        out.println(new CharBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("if (").append(var).append(" != null) {").toString());
        out.pushDepth();
        out.println(new CharBuffer().append(var).append(".setSession(__caucho_session);").toString());
        out.println(new CharBuffer().append("return ").append(var).append(";").toString());
        out.popDepth();
        out.println("}");
        out.println("if (__caucho_session == null) {");
        if (!this.isAbstract()) {
            out.println(new CharBuffer().append("  return super.").append(this.getGetterName()).append("();").toString());
        }
        out.println("}");
        out.println("try {");
        out.pushDepth();
        out.print("String sql=\"");
        out.print("SELECT c");
        out.print(new CharBuffer().append(" FROM ").append(this.getSourceType().getName()).append(" o,").toString());
        out.print(new CharBuffer().append("  IN(o.").append(this.getName()).append(") c").toString());
        out.print(" WHERE ");
        out.print(this.getSourceType().getId().generateRawWhere("o"));
        if (this._orderByFields != null) {
            out.print(" ORDER BY ");
            for (int i = 0; i < this._orderByFields.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(new CharBuffer().append("c.").append(this._orderByFields.get(i)).toString());
                if (!Boolean.FALSE.equals(this._orderByAscending.get(i))) continue;
                out.print(" DESC");
            }
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", "this");
        out.print(new CharBuffer().append(var).append(" = new com.caucho.amber.collection.CollectionImpl").toString());
        if (param != null) {
            out.print(new CharBuffer().append("<").append(param.getPrintName()).append(">").toString());
        }
        out.println("(query);");
        out.println();
        out.println(new CharBuffer().append("return ").append(var).append(";").toString());
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        this.generateAmberAdd(out);
        this.generateAmberRemove(out);
        this.generateAmberRemoveTargetAll(out);
    }

    private void generateAdd(JavaWriter out) throws IOException {
        JType type = this.getJavaType();
        JType[] paramArgs = type.getActualTypeArguments();
        String gType = paramArgs.length > 0 ? paramArgs[0].getPrintName() : "Object";
        out.println(new CharBuffer().append("public boolean add(").append(gType).append(" o)").toString());
        out.println("{");
        out.pushDepth();
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println(new CharBuffer().append("if (! (o instanceof ").append(ownerType).append("))").toString());
        out.println(new CharBuffer().append("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a ").append(ownerType).append("\");").toString());
        out.println(new CharBuffer().append(ownerType).append(" bean = (").append(ownerType).append(") o;").toString());
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateRemove(JavaWriter out) throws IOException {
        JType type = this.getJavaType();
        JType[] paramArgs = type.getActualTypeArguments();
        String gType = paramArgs.length > 0 ? paramArgs[0].getPrintName() : "Object";
        out.println(new CharBuffer().append("public boolean remove(").append(gType).append(" o)").toString());
        out.println("{");
        out.pushDepth();
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println(new CharBuffer().append("if (! (o instanceof ").append(ownerType).append("))").toString());
        out.println(new CharBuffer().append("  throw new java.lang.IllegalArgumentException((o == null ? \"null\" : o.getClass().getName()) + \" must be a ").append(ownerType).append("\");").toString());
        out.println(new CharBuffer().append(ownerType).append(" bean = (").append(ownerType).append(") o;").toString());
        out.println("return true;");
        out.popDepth();
        out.println("}");
    }

    private void generateClear(JavaWriter out) throws IOException {
        out.println("public void clear()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flush();");
        out.print("String sql=\"");
        out.print("UPDATE ");
        out.print(this.getSourceType().getName());
        out.print(" SET ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        String ownerType = this.getSourceType().getInstanceClassName();
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", new CharBuffer().append(ownerType).append(".this").toString());
        out.println("query.executeUpdate();");
        out.println("super.clear();");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("} else {");
        out.println("  super.clear();");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    private void generateSize(JavaWriter out) throws IOException {
        out.println("public int size()");
        out.println("{");
        out.pushDepth();
        out.println("if (__caucho_session == null || isValid())");
        out.println("  return super.size();");
        out.println("try {");
        out.pushDepth();
        out.println("__caucho_session.flush();");
        out.print("String sql=\"");
        out.print("SELECT count(*) FROM ");
        out.print(this.getSourceType().getName());
        out.print(" AS o ");
        out.print(" WHERE ");
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query;");
        out.println("query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", new CharBuffer().append(this.getSourceType().getName()).append("__ResinExt.this").toString(), "index");
        out.println("java.sql.ResultSet rs = query.executeQuery();");
        out.println("if (rs.next())");
        out.println("  return rs.getInt(1);");
        out.println("else");
        out.println("  return 0;");
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberAdd(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println(new CharBuffer().append("public boolean __amber_").append(this.getGetterName()).append("_add(Object o)").toString());
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("if (! (o instanceof ").append(targetType).append("))").toString());
        out.println("  return false;");
        out.println();
        out.println(new CharBuffer().append(targetType).append(" v = (").append(targetType).append(") o;").toString());
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"INSERT INTO ");
        out.print(new CharBuffer().append(this._associationTable.getName()).append(" (").toString());
        out.print(this._sourceLink.generateSelectSQL(null));
        out.print(", ");
        out.print(this._targetLink.generateSelectSQL(null));
        out.print(") VALUES (");
        int count = this.getSourceType().getId().getKeyCount() + this.getTargetType().getId().getKeyCount();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print("?");
        }
        out.println(")\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareInsertStatement(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "pstmt", "index", "this");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1) {");
        out.pushDepth();
        out.println(new CharBuffer().append("__caucho_session.addCompletion(new com.caucho.amber.entity.TableInvalidateCompletion(\"").append(this._targetLink.getSourceTable().getName()).append("\"));").toString());
        out.println("return true;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemove(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println(new CharBuffer().append("public boolean __amber_").append(this.getGetterName()).append("_remove(Object o)").toString());
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("if (! (o instanceof ").append(targetType).append("))").toString());
        out.println("  return false;");
        out.println();
        out.println(new CharBuffer().append(targetType).append(" v = (").append(targetType).append(") o;").toString());
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(new CharBuffer().append(this._associationTable.getName()).append(" WHERE ").toString());
        out.print(this._sourceLink.generateMatchArgSQL(null));
        out.print(" AND ");
        out.print(this._targetLink.generateMatchArgSQL(null));
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "pstmt", "index", "this");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1) {");
        out.pushDepth();
        out.println(new CharBuffer().append("__caucho_session.addCompletion(new com.caucho.amber.entity.TableInvalidateCompletion(\"").append(this._targetLink.getSourceTable().getName()).append("\"));").toString());
        out.println("return true;");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    public void generateAmberRemoveTargetAll(JavaWriter out) throws IOException {
        String targetType = this.getTargetType().getProxyClass().getName();
        out.println();
        out.println(new CharBuffer().append("public boolean __amber_").append(this.getGetterName()).append("_remove_target(Object o)").toString());
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append("if (! (o instanceof ").append(targetType).append("))").toString());
        out.println("  return false;");
        out.println();
        out.println(new CharBuffer().append(targetType).append(" v = (").append(targetType).append(") o;").toString());
        out.println();
        out.println("if (__caucho_session == null)");
        out.println("  return false;");
        out.println();
        out.print("String sql = \"DELETE FROM ");
        out.print(new CharBuffer().append(this._associationTable.getName()).append(" WHERE ").toString());
        out.print(this._targetLink.generateMatchArgSQL(null));
        out.println("\";");
        out.println();
        out.println("try {");
        out.pushDepth();
        out.println("java.sql.PreparedStatement pstmt = __caucho_session.prepareStatement(sql);");
        out.println("int index = 1;");
        this.getTargetType().getId().generateSet(out, "pstmt", "index", "v");
        out.println("if (pstmt.executeUpdate() == 1)");
        out.println("  return true;");
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  __caucho_log.log(java.util.logging.Level.FINE, e.toString(), e);");
        out.println("}");
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        JMethod setter = this.getSetterMethod();
        if (setter == null) {
            return;
        }
        JType type = this.getGetterMethod().getGenericReturnType();
        out.println();
        out.print(new CharBuffer().append("public void ").append(setter.getName()).append("(").toString());
        out.print(new CharBuffer().append(type.getPrintName()).append(" value)").toString());
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println(new CharBuffer().append("if (\"").append(this._sourceLink.getSourceTable().getName()).append("\".equals(table)) {").toString());
        out.pushDepth();
        this.generateExpire(out);
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
        String var = new CharBuffer().append("_caucho_").append(this.getGetterName()).toString();
        out.println(new CharBuffer().append("if (").append(var).append(" != null)").toString());
        out.println(new CharBuffer().append("  ").append(var).append(".update();").toString());
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.field.EntityManyToManyField");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

