/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeId
extends Id {
    private static final L10N L = new L10N(CompositeId._resin_compat_class_0());
    protected static final Logger log = Log.open(CompositeId._resin_compat_class_0());
    private JClass _keyClass;
    private static Class _resin_compat_class_0;

    public CompositeId(EntityType ownerType, ArrayList<IdField> keys) {
        super(ownerType, keys);
    }

    public void setKeyClass(JClass keyClass) {
        this._keyClass = keyClass;
        this.getOwnerType().addDependency(keyClass);
    }

    @Override
    public String getForeignTypeName() {
        if (this._keyClass != null) {
            return this._keyClass.getName();
        }
        return this.getOwnerType().getName();
    }

    public String getForeignMakeKeyName() {
        return this.getOwnerType().getName().replace('.', '_').replace('/', '_');
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        this.generatePrologue(out, completedSet, this.getForeignMakeKeyName());
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet, String name) throws IOException {
        this.generatePrologueMake(out, completedSet);
        this.generatePrologueLoad(out, completedSet);
    }

    public void generatePrologueMake(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        IdField key;
        int i;
        String makeName = new CharBuffer().append("__caucho_make_key_").append(this.getForeignMakeKeyName()).toString();
        if (completedSet.contains(makeName)) {
            return;
        }
        completedSet.add(makeName);
        out.println();
        out.print("private static ");
        out.print(new CharBuffer().append(this.getForeignTypeName()).append(" ").append(makeName).toString());
        out.print("(");
        ArrayList<IdField> keys = this.getKeys();
        for (i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                out.print(", ");
            }
            key = keys.get(i);
            out.print(new CharBuffer().append(key.getJavaTypeName()).append(" a").append(i).toString());
        }
        out.println(")");
        out.println("{");
        out.pushDepth();
        out.println(new CharBuffer().append(this.getForeignTypeName()).append(" key = new ").append(this.getForeignTypeName()).append("();").toString());
        for (i = 0; i < keys.size(); ++i) {
            key = keys.get(i);
            out.println(new CharBuffer().append(key.generateSetKeyProperty("key", new CharBuffer().append("a").append(i).toString())).append(";").toString());
        }
        out.println("return key;");
        out.popDepth();
        out.println("}");
    }

    public void generatePrologueLoad(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        int i;
        String loadName = new CharBuffer().append("__caucho_load_key_").append(this.getForeignMakeKeyName()).toString();
        if (completedSet.contains(loadName)) {
            return;
        }
        completedSet.add(loadName);
        out.println();
        out.print("private static ");
        out.print(new CharBuffer().append(this.getForeignTypeName()).append(" ").append(loadName).toString());
        out.println("(com.caucho.amber.connection.AmberConnectionImpl aConn, java.sql.ResultSet rs, int index)");
        out.println("  throws java.sql.SQLException");
        out.println("{");
        out.pushDepth();
        int index = 0;
        ArrayList<IdField> keys = this.getKeys();
        for (i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            String javaType = key.getJavaTypeName();
            out.print(new CharBuffer().append(javaType).append(" a").append(i).append(" = (").append(javaType).append(") ").toString());
            index = key.getType().generateLoad(out, "rs", "index", index);
            out.println(";");
            out.println("if (rs.wasNull())");
            out.println("  return null;");
        }
        out.println(new CharBuffer().append(this.getForeignTypeName()).append(" key = new ").append(this.getForeignTypeName()).append("();").toString());
        for (i = 0; i < keys.size(); ++i) {
            out.println(new CharBuffer().append(keys.get(i).generateSetKeyProperty("key", new CharBuffer().append("a").append(i).toString())).append(";").toString());
        }
        out.println("return key;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        out.print(new CharBuffer().append("__caucho_load_key_").append(this.getForeignMakeKeyName()).toString());
        out.print(new CharBuffer().append("(aConn, ").append(rs).append(", ").append(indexVar).append(" + ").append(index).append(")").toString());
        ArrayList<IdField> keys = this.getKeys();
        return index += keys.size();
    }

    @Override
    public String generateSelect(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateSelect(id));
        }
        return cb.close();
    }

    @Override
    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public String generateGetProperty(String value) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(new CharBuffer().append("__caucho_make_key_").append(this.getForeignMakeKeyName()).toString());
        cb.append("(");
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateGet(value));
        }
        cb.append(")");
        return cb.close();
    }

    public String generateGetProxyProperty(String value) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(new CharBuffer().append("__caucho_make_key_").append(this.getForeignMakeKeyName()).toString());
        cb.append("(");
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(keys.get(i).generateGetProxyProperty(value));
        }
        cb.append(")");
        return cb.close();
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateLoadFromObject(out, obj);
        }
    }

    @Override
    public void generateSet(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        out.println(new CharBuffer().append("if (").append(obj).append(" != null) {").toString());
        out.pushDepth();
        out.println(new CharBuffer().append(this.getForeignTypeName()).append(" ").append(obj).append("_key = (").append(this.getForeignTypeName()).append(") ").append(obj).append(";").toString());
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            key.generateSet(out, key.generateGetKeyProperty(new CharBuffer().append(obj).append("_key").toString()));
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateUpdateFromObject(out, obj);
        }
    }

    public String generateWhere(String id) {
        ArrayList<IdField> keys = this.getKeys();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(keys.get(i).generateWhere(id));
        }
        return cb.close();
    }

    @Override
    public String generateCreateTableSQL(AmberManager manager) {
        return null;
    }

    @Override
    public void generateSetKey(JavaWriter out, String pstmt, String obj, String index) throws IOException {
        this.generateSet(out, pstmt, obj, index);
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSet(out, pstmt, obj, index);
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSet(out, pstmt, index);
        }
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        ArrayList<IdField> keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            keys.get(i).generateSetInsert(out, pstmt, index);
        }
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public void generateMatch(JavaWriter out, String key) throws IOException {
        out.println(new CharBuffer().append("return ").append(this.generateEquals("super", key)).append(";").toString());
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return new CharBuffer().append(leftBase).append(".equals(").append(value).append(")").toString();
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.field.CompositeId");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

