/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassWrapper;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractField
implements AmberField {
    private static final L10N L = new L10N(AbstractField._resin_compat_class_0());
    protected static final Logger log = Log.open(AbstractField._resin_compat_class_0());
    private EntityType _sourceType;
    private String _name;
    private JType _javaType;
    private JMethod _getterMethod;
    private JMethod _setterMethod;
    private boolean _isLazy;
    private int _updateIndex;
    private int _loadGroupIndex;
    private static Class _resin_compat_class_0;

    AbstractField(EntityType sourceType) {
        this._sourceType = sourceType;
        this._loadGroupIndex = sourceType.getDefaultLoadGroupIndex();
    }

    AbstractField(EntityType sourceType, String name) throws ConfigException {
        this(sourceType);
        this.setName(name);
    }

    public void setName(String name) throws ConfigException {
        this._name = name;
        if (!this.getSourceType().isFieldAccess()) {
            char ch = name.charAt(0);
            if (Character.isLowerCase(ch)) {
                name = new CharBuffer().append(Character.toUpperCase(ch)).append(name.substring(1)).toString();
            }
            String getter = new CharBuffer().append("get").append(name).toString();
            String setter = new CharBuffer().append("set").append(name).toString();
            this._getterMethod = EntityType.getGetter(this.getBeanClass(), getter);
            if (this._getterMethod == null) {
                getter = new CharBuffer().append("is").append(name).toString();
                this._getterMethod = EntityType.getGetter(this.getBeanClass(), getter);
            }
            if (this._getterMethod == null) {
                throw new ConfigException(L.l("{0}: {1} has no matching getter.", (Object)this.getBeanClass().getName(), name));
            }
            this._javaType = this._getterMethod.getGenericReturnType();
            this._setterMethod = EntityType.getSetter(this.getBeanClass(), setter);
        } else {
            JField field = EntityType.getField(this.getBeanClass(), name);
            if (field == null) {
                throw new ConfigException(L.l("{0}: {1} has no matching field.", (Object)this.getBeanClass().getName(), name));
            }
            this._javaType = field.getGenericType();
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected void setJavaType(JType type) {
        this._javaType = type;
    }

    protected void setJavaType(Class type) {
        this.setJavaType(new JClassWrapper(type, this.getAmberManager().getJClassLoader()));
    }

    @Override
    public EntityType getSourceType() {
        return this._sourceType;
    }

    public AmberManager getAmberManager() {
        return this.getSourceType().getAmberManager();
    }

    public JClass getBeanClass() {
        return this.getSourceType().getBeanClass();
    }

    @Override
    public Table getTable() {
        return this.getSourceType().getTable();
    }

    @Override
    public int getIndex() {
        return this._updateIndex;
    }

    @Override
    public void setIndex(int index) {
        this._updateIndex = index;
    }

    @Override
    public int getLoadGroupIndex() {
        return this._loadGroupIndex;
    }

    public void setLazy(boolean isLazy) {
        this._isLazy = isLazy;
    }

    @Override
    public JMethod getGetterMethod() {
        return this._getterMethod;
    }

    @Override
    public String getGetterName() {
        if (this.getSourceType().isFieldAccess()) {
            return new CharBuffer().append("__caucho_get_").append(this.getName()).toString();
        }
        return this._getterMethod.getName();
    }

    @Override
    public String getJavaTypeName() {
        return this.getJavaType().getPrintName();
    }

    private String getJavaTypeName(Class cl) {
        if (cl.isArray()) {
            return new CharBuffer().append(this.getJavaTypeName(cl.getComponentType())).append("[]").toString();
        }
        return cl.getName();
    }

    @Override
    public JType getJavaType() {
        return this._javaType;
    }

    @Override
    public JMethod getSetterMethod() {
        return this._setterMethod;
    }

    @Override
    public String getSetterName() {
        if (this.getSourceType().isFieldAccess()) {
            return new CharBuffer().append("__caucho_set_").append(this.getName()).toString();
        }
        if (this._setterMethod != null) {
            return this._setterMethod.getName();
        }
        return new CharBuffer().append("set").append(this.getGetterName().substring(3)).toString();
    }

    public boolean isFieldAccess() {
        return this.getSourceType().isFieldAccess();
    }

    @Override
    public boolean isAbstract() {
        if (this.getSourceType().isFieldAccess()) {
            return true;
        }
        if (this._getterMethod == null) {
            return false;
        }
        return this._getterMethod.isAbstract();
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public void init() throws ConfigException {
        if (this._isLazy) {
            this._loadGroupIndex = this.getSourceType().nextLoadGroupIndex();
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        if (this.isAbstract()) {
            out.println();
            out.print("public ");
            out.print(this.getJavaType().getPrintName());
            out.print(new CharBuffer().append(" ").append(this.getFieldName()).append(";").toString());
        }
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        return null;
    }

    @Override
    public String generateSelect(String id) {
        return null;
    }

    @Override
    public String generateWhere(String id) {
        return null;
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
    }

    @Override
    public void generateUpdate(JavaWriter out, String maskVar, String pstmt, String index) throws IOException {
        int group = this.getIndex() / 64;
        long mask = 1L << this.getIndex() % 64;
        out.println();
        out.println(new CharBuffer().append("if ((").append(maskVar).append("_").append(group).append(" & ").append(mask).append("L) != 0) {").toString());
        out.pushDepth();
        this.generateSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public boolean hasLoadGroup(int index) {
        return index == this._loadGroupIndex;
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return index;
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
        if (this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return;
        }
        String getter = this.getGetterName();
        String loadVar = new CharBuffer().append("__caucho_loadMask_").append(this.getLoadGroupIndex() / 64).toString();
        long loadMask = 1L << this.getLoadGroupIndex();
        out.println(new CharBuffer().append("if ((").append(loadVar).append(" & ").append(loadMask).append("L) != 0)").toString());
        out.print("  ");
        out.println(new CharBuffer().append("  ").append(this.generateSuperSetter(this.generateGet(obj))).append(";").toString());
    }

    @Override
    public void generateSet(JavaWriter out, String obj) throws IOException {
        out.println(new CharBuffer().append(this.generateSuperSetter(obj)).append(";").toString());
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        out.println(new CharBuffer().append(this.generateSuperSetter(this.generateGet(obj))).append(";").toString());
    }

    @Override
    public void generateGet(JavaWriter out, String value) throws IOException {
        out.print(this.generateGet(value));
    }

    public String generateNull() {
        return "null";
    }

    @Override
    public String generateGet(String obj) {
        if (obj == null) {
            return this.generateNull();
        }
        if (obj.equals("super")) {
            return this.generateSuperGetter();
        }
        if (!this.isAbstract()) {
            return new CharBuffer().append(obj).append(".").append(this._getterMethod.getName()).append("()").toString();
        }
        if (this._getterMethod != null) {
            return new CharBuffer().append(obj).append(".").append(this._getterMethod.getName()).append("()").toString();
        }
        return new CharBuffer().append(obj).append(".").append(this.getFieldName()).toString();
    }

    @Override
    public String generateSet(String obj, String value) {
        if (obj.equals("super")) {
            return this.generateSuperSetter(value);
        }
        if (this.isAbstract()) {
            return new CharBuffer().append(obj).append(".").append(this.getFieldName()).append(" = ").append(value).toString();
        }
        return new CharBuffer().append(obj).append(".").append(this._setterMethod.getName()).append("(").append(value).append(")").toString();
    }

    protected String getFieldName() {
        return new CharBuffer().append("__amber_").append(this.getName()).toString();
    }

    public final String generateInsert() {
        return null;
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
    }

    @Override
    public String generateSuperGetter() {
        return new CharBuffer().append("__caucho_super_get_").append(this.getName()).append("()").toString();
    }

    @Override
    public String generateSuperSetter(String value) {
        return new CharBuffer().append("__caucho_super_set_").append(this.getName()).append("(").append(value).append(")").toString();
    }

    @Override
    public void generateSuperGetter(JavaWriter out) throws IOException {
        out.println();
        out.println(new CharBuffer().append("public final ").append(this.getJavaTypeName()).append(" __caucho_super_get_").append(this.getName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println(new CharBuffer().append("return ").append(this.getFieldName()).append(";").toString());
        } else {
            out.println(new CharBuffer().append("return super.").append(this.getGetterName()).append("();").toString());
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSuperSetter(JavaWriter out) throws IOException {
        out.println();
        out.println(new CharBuffer().append("public final void __caucho_super_set_").append(this.getName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        if (this.isAbstract() || this.getGetterMethod() == null) {
            out.println(new CharBuffer().append(this.getFieldName()).append(" = v;").toString());
        } else if (this.getSetterMethod() != null) {
            out.println(new CharBuffer().append("super.").append(this.getSetterMethod().getName()).append("(v);").toString());
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateCreateTableSQL(AmberManager manager) {
        return null;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
        this.generateSet(out, pstmt, index, "super");
    }

    @Override
    public void generateInsertSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateSet(out, pstmt, index, obj);
    }

    @Override
    public void generateUpdateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
        this.generateSet(out, pstmt, index, obj);
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() == updateIndex) {
            String value = this.generateGet(src);
            out.println(new CharBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
        if (this.getLoadGroupIndex() == loadIndex) {
            String value = this.generateGet(src);
            out.println(new CharBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String obj) throws IOException {
    }

    @Override
    public String toObject(String value) {
        return value;
    }

    @Override
    public void link() {
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
    }

    @Override
    public void generateExpire(JavaWriter out) throws IOException {
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
    }

    @Override
    public void childDelete(AmberConnectionImpl aConn, Serializable primaryKey) throws SQLException {
    }

    @Override
    public String generateCastFromObject(String value) {
        return value;
    }

    @Override
    public String generateEquals(String leftBase, String value) {
        return new CharBuffer().append(leftBase).append(".equals(").append(value).append(")").toString();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return new CharBuffer().append(this.getClass().getName()).append("[").append(this.getName()).append("]").toString();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.field.AbstractField");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

