/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.logging.Logger;

public class RowInvalidateCompletion
extends AmberCompletion {
    private static final L10N L = new L10N(RowInvalidateCompletion._resin_compat_class_0());
    private static final Logger log = Log.open(RowInvalidateCompletion._resin_compat_class_0());
    private String _table;
    private Object _key;
    private static Class _resin_compat_class_0;

    public RowInvalidateCompletion(String table, Object key) {
        if (table == null || key == null) {
            throw new NullPointerException();
        }
        this._table = table;
        this._key = key;
    }

    public boolean complete(AmberEntityHome home, Object key, EntityItem entityItem) {
        if (home.getEntityType().getTable().getName().equals(this._table) && this._key.equals(key)) {
            entityItem.expire();
        } else {
            entityItem.getEntity().__caucho_invalidate_foreign(this._table, key);
        }
        return false;
    }

    public boolean complete(ResultSetCacheChunk chunk) {
        if (chunk.invalidate(this._table, this._key)) {
            chunk.invalidate();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RowInvalidateCompletion comp = (RowInvalidateCompletion)o;
        return this._table.equals(comp._table) && this._key.equals(comp._key);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.entity.RowInvalidateCompletion");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

