/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.ejb3;

import com.caucho.amber.AmberManager;
import com.caucho.amber.connection.AmberConnectionImpl;
import com.caucho.amber.ejb3.EntityManagerProxy;
import com.caucho.amber.ejb3.QueryImpl;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.jca.CloseResource;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.util.L10N;
import javax.ejb.EntityManager;
import javax.ejb.Query;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerImpl
implements EntityManager,
CloseResource {
    private static final L10N L = new L10N(EntityManagerImpl._resin_compat_class_0());
    private EntityManagerProxy _entityManagerProxy;
    private AmberManager _amberManager;
    private boolean _isRegistered;
    private AmberConnectionImpl _aConn;
    private static Class _resin_compat_class_0;

    EntityManagerImpl(AmberManager amberManager, EntityManagerProxy proxy) {
        this._amberManager = amberManager;
        this._entityManagerProxy = proxy;
    }

    public void persist(Object entity) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            aConn.create(entity);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public <T> T merge(T entity) {
        throw new UnsupportedOperationException();
    }

    public void remove(Object entity) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            aConn.delete(entity);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public Object find(String entityName, Object primaryKey) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            return aConn.load(entityName, primaryKey);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            return (T)aConn.load(entityClass, primaryKey);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public void flush() {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            aConn.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public Query createQuery(String sql) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            AbstractQuery queryProgram = aConn.parseQuery(sql, false);
            return new QueryImpl(queryProgram, aConn);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    public Query createNamedQuery(String sql) {
        throw new UnsupportedOperationException();
    }

    public Query createNativeQuery(String sql) {
        throw new UnsupportedOperationException();
    }

    public Query createNativeQuery(String sql, String map) {
        throw new UnsupportedOperationException();
    }

    public Query createNativeQuery(String sql, Class type) {
        throw new UnsupportedOperationException();
    }

    public void refresh(Object entity) {
    }

    public boolean contains(Object entity) {
        try {
            AmberConnectionImpl aConn = this.getAmberConnection();
            return aConn.contains(entity);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBExceptionWrapper(e);
        }
    }

    private AmberConnectionImpl getAmberConnection() {
        if (this._aConn == null) {
            this._aConn = this._amberManager.createAmberConnection();
        }
        return this._aConn;
    }

    void register() {
        if (!this._isRegistered) {
            UserTransactionProxy.getInstance().enlistCloseResource(this);
        }
        this._isRegistered = true;
    }

    @Override
    public void close() {
        AmberConnectionImpl aConn = this._aConn;
        this._aConn = null;
        this._isRegistered = false;
        if (aConn != null) {
            aConn.cleanup();
        }
        this._entityManagerProxy.unset(this);
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("com.caucho.amber.ejb3.EntityManagerImpl");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

