/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MethodMap {
    private static final int MORE_SPECIFIC = 0;
    private static final int LESS_SPECIFIC = 1;
    private static final int INCOMPARABLE = 2;
    Map methodByNameMap = new Hashtable();
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Ljava$lang$Character;
    private static /* synthetic */ Class class$Ljava$lang$Byte;
    private static /* synthetic */ Class class$Ljava$lang$Short;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Float;
    private static /* synthetic */ Class class$Ljava$lang$Double;

    public void add(Method method) {
        String methodName = method.getName();
        ArrayList<Method> l = this.get(methodName);
        if (l == null) {
            l = new ArrayList<Method>();
            this.methodByNameMap.put(methodName, l);
        }
        l.add(method);
    }

    public List get(String key) {
        return (List)this.methodByNameMap.get(key);
    }

    public Method find(String methodName, Object[] args) throws AmbiguousException {
        List methodList = this.get(methodName);
        if (methodList == null) {
            return null;
        }
        int l = args.length;
        Class[] classes = new Class[l];
        int i = 0;
        while (i < l) {
            Object arg = args[i];
            classes[i] = arg == null ? (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : MethodMap.class$("java.lang.Object")) : arg.getClass();
            ++i;
        }
        return MethodMap.getMostSpecific(methodList, classes);
    }

    private static final Method getMostSpecific(List methods, Class[] classes) throws AmbiguousException {
        LinkedList applicables = MethodMap.getApplicables(methods, classes);
        if (applicables.isEmpty()) {
            return null;
        }
        if (applicables.size() == 1) {
            return (Method)applicables.getFirst();
        }
        LinkedList<Method> maximals = new LinkedList<Method>();
        Iterator applicable = applicables.iterator();
        while (applicable.hasNext()) {
            Method app = (Method)applicable.next();
            Class[] appArgs = app.getParameterTypes();
            boolean lessSpecific = false;
            Iterator maximal = maximals.iterator();
            while (!lessSpecific && maximal.hasNext()) {
                Method max = (Method)maximal.next();
                switch (MethodMap.moreSpecific(appArgs, max.getParameterTypes())) {
                    case 0: {
                        maximal.remove();
                        break;
                    }
                    case 1: {
                        lessSpecific = true;
                        break;
                    }
                }
            }
            if (lessSpecific) continue;
            maximals.addLast(app);
        }
        if (maximals.size() > 1) {
            throw new AmbiguousException();
        }
        return (Method)maximals.getFirst();
    }

    private static final int moreSpecific(Class[] c1, Class[] c2) {
        boolean c1MoreSpecific = false;
        boolean c2MoreSpecific = false;
        int i = 0;
        while (i < c1.length) {
            if (c1[i] != c2[i]) {
                c1MoreSpecific = c1MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c2[i], c1[i]);
                c2MoreSpecific = c2MoreSpecific || MethodMap.isStrictMethodInvocationConvertible(c1[i], c2[i]);
            }
            ++i;
        }
        if (c1MoreSpecific) {
            if (c2MoreSpecific) {
                return 2;
            }
            return 0;
        }
        if (c2MoreSpecific) {
            return 1;
        }
        return 2;
    }

    private static final LinkedList getApplicables(List methods, Class[] classes) {
        LinkedList<Method> list = new LinkedList<Method>();
        Iterator imethod = methods.iterator();
        while (imethod.hasNext()) {
            Method method = (Method)imethod.next();
            if (!MethodMap.isApplicable(method, classes)) continue;
            list.add(method);
        }
        return list;
    }

    private static final boolean isApplicable(Method method, Class[] classes) {
        Class<?>[] methodArgs = method.getParameterTypes();
        if (methodArgs.length != classes.length) {
            return false;
        }
        int i = 0;
        while (i < classes.length) {
            if (!MethodMap.isMethodInvocationConvertible(methodArgs[i], classes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final boolean isMethodInvocationConvertible(Class formal, Class actual) {
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Boolean.TYPE && actual == (class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = MethodMap.class$("java.lang.Boolean")))) {
                return true;
            }
            if (formal == Character.TYPE && actual == (class$Ljava$lang$Character != null ? class$Ljava$lang$Character : (class$Ljava$lang$Character = MethodMap.class$("java.lang.Character")))) {
                return true;
            }
            if (formal == Byte.TYPE && actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte")))) {
                return true;
            }
            if (formal == Short.TYPE && (actual == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = MethodMap.class$("java.lang.Short"))) || actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte"))))) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = MethodMap.class$("java.lang.Integer"))) || actual == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = MethodMap.class$("java.lang.Short"))) || actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte"))))) {
                return true;
            }
            if (formal == Long.TYPE && (actual == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = MethodMap.class$("java.lang.Long"))) || actual == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = MethodMap.class$("java.lang.Integer"))) || actual == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = MethodMap.class$("java.lang.Short"))) || actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte"))))) {
                return true;
            }
            if (formal == Float.TYPE && (actual == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = MethodMap.class$("java.lang.Float"))) || actual == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = MethodMap.class$("java.lang.Long"))) || actual == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = MethodMap.class$("java.lang.Integer"))) || actual == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = MethodMap.class$("java.lang.Short"))) || actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte"))))) {
                return true;
            }
            if (formal == Double.TYPE && (actual == (class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = MethodMap.class$("java.lang.Double"))) || actual == (class$Ljava$lang$Float != null ? class$Ljava$lang$Float : (class$Ljava$lang$Float = MethodMap.class$("java.lang.Float"))) || actual == (class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = MethodMap.class$("java.lang.Long"))) || actual == (class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = MethodMap.class$("java.lang.Integer"))) || actual == (class$Ljava$lang$Short != null ? class$Ljava$lang$Short : (class$Ljava$lang$Short = MethodMap.class$("java.lang.Short"))) || actual == (class$Ljava$lang$Byte != null ? class$Ljava$lang$Byte : (class$Ljava$lang$Byte = MethodMap.class$("java.lang.Byte"))))) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isStrictMethodInvocationConvertible(Class formal, Class actual) {
        if (formal.isAssignableFrom(actual)) {
            return true;
        }
        if (formal.isPrimitive()) {
            if (formal == Short.TYPE && actual == Byte.TYPE) {
                return true;
            }
            if (formal == Integer.TYPE && (actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Long.TYPE && (actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Float.TYPE && (actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
            if (formal == Double.TYPE && (actual == Float.TYPE || actual == Long.TYPE || actual == Integer.TYPE || actual == Short.TYPE || actual == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class AmbiguousException
    extends Exception {
    }
}

