/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.texen.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.tools.ant.Project;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.texen.Generator;
import org.apache.velocity.util.StringUtils;

public class Texen {
    private static final String ERR_MSG_FRAGMENT = ". For more information consult the velocity log, or invoke ant with the -debug flag.";
    protected String controlTemplate;
    protected String templatePath;
    protected String outputDirectory;
    protected String outputFile;
    protected String outputEncoding;
    protected String inputEncoding;
    protected ExtendedProperties contextProperties;
    protected String contextPropertiesFile;
    protected boolean useClasspath;
    private String fileSeparator = System.getProperty("file.separator");
    protected Project project;

    public void setControlTemplate(String controlTemplate) {
        this.controlTemplate = controlTemplate;
    }

    public String getControlTemplate() {
        return this.controlTemplate;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    protected void processTemplatePath(String templatePath) throws Exception {
        StringBuffer resolvedPath = new StringBuffer();
        StringTokenizer st = new StringTokenizer(templatePath, ",");
        while (st.hasMoreTokens()) {
            File fullPath = this.resolveFile(st.nextToken());
            resolvedPath.append(fullPath.getCanonicalPath());
            if (!st.hasMoreTokens()) continue;
            resolvedPath.append(",");
        }
        this.templatePath = resolvedPath.toString();
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setOutputDirectory(File outputDirectory) throws Exception {
        try {
            this.outputDirectory = outputDirectory.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new Exception("There is a problem with the outputDirectory: " + ioe);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setContextProperties(String file) {
        this.contextPropertiesFile = file;
    }

    protected void processContextProperties(String file) throws Exception {
        String[] sources = StringUtils.split(file, ",");
        this.contextProperties = new ExtendedProperties();
        int i = 0;
        while (i < sources.length) {
            ExtendedProperties source = new ExtendedProperties();
            try {
                File fullPath = this.resolveFile(sources[i]);
                this.log("Using contextProperties file: " + fullPath);
                source.load((InputStream)new FileInputStream(fullPath));
            }
            catch (Exception e) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                try {
                    InputStream inputStream = classLoader.getResourceAsStream(sources[i]);
                    if (inputStream == null) {
                        throw new Exception("Context properties file " + sources[i] + " could not be found in the file system or on the classpath!");
                    }
                    source.load(inputStream);
                }
                catch (IOException ioe) {
                    source = null;
                }
            }
            Iterator j = source.getKeys();
            while (j.hasNext()) {
                String name = (String)j.next();
                String value = source.getString(name);
                this.contextProperties.setProperty(name, (Object)value);
            }
            ++i;
        }
    }

    public ExtendedProperties getContextProperties() {
        return this.contextProperties;
    }

    public void setUseClasspath(boolean useClasspath) {
        this.useClasspath = useClasspath;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public Context initControlContext() throws Exception {
        return new VelocityContext();
    }

    public void execute() throws Exception {
        if (this.templatePath == null && !this.useClasspath) {
            throw new Exception("The template path needs to be defined if you are not using the classpath for locating templates!");
        }
        if (this.controlTemplate == null) {
            throw new Exception("The control template needs to be defined!");
        }
        if (this.outputDirectory == null) {
            throw new Exception("The output directory needs to be defined!");
        }
        if (this.outputFile == null) {
            throw new Exception("The output file needs to be defined!");
        }
        if (this.contextPropertiesFile != null) {
            this.processContextProperties(this.contextPropertiesFile);
        }
        try {
            File file;
            if (this.templatePath != null) {
                this.processTemplatePath(this.templatePath);
                this.log("Using templatePath: " + this.templatePath);
                Velocity.setProperty("file.resource.loader.path", this.templatePath);
            }
            if (this.useClasspath) {
                this.log("Using classpath");
                Velocity.addProperty("resource.loader", "classpath");
                Velocity.setProperty("classpath.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                Velocity.setProperty("classpath.resource.loader.cache", "false");
                Velocity.setProperty("classpath.resource.loader.modificationCheckInterval", "2");
            }
            Velocity.init();
            Generator generator = Generator.getInstance();
            generator.setOutputPath(this.outputDirectory);
            generator.setInputEncoding(this.inputEncoding);
            generator.setOutputEncoding(this.outputEncoding);
            if (this.templatePath != null) {
                generator.setTemplatePath(this.templatePath);
            }
            if (!(file = new File(this.outputDirectory)).exists()) {
                file.mkdirs();
            }
            String path = this.outputDirectory + File.separator + this.outputFile;
            this.log("Generating to file " + path);
            Writer writer = generator.getWriter(path, this.outputEncoding);
            Context c = this.initControlContext();
            this.populateInitialContext(c);
            if (this.contextProperties != null) {
                Iterator i = this.contextProperties.getKeys();
                while (i.hasNext()) {
                    String property = (String)i.next();
                    String value = this.contextProperties.getString(property);
                    try {
                        c.put(property, new Integer(value));
                    }
                    catch (NumberFormatException nfe) {
                        String booleanString = this.contextProperties.testBoolean(value);
                        if (booleanString != null) {
                            c.put(property, new Boolean(booleanString));
                            continue;
                        }
                        if (property.endsWith("file.contents")) {
                            value = StringUtils.fileContentsToString(this.resolveFile(value).getCanonicalPath());
                            property = property.substring(0, property.indexOf("file.contents") - 1);
                        }
                        c.put(property, value);
                    }
                }
            }
            writer.write(generator.parse(this.controlTemplate, c));
            writer.flush();
            writer.close();
            generator.shutdown();
            this.cleanup();
        }
        catch (MethodInvocationException e) {
            throw new Exception("Exception thrown by '" + e.getReferenceName() + "." + e.getMethodName() + "'" + ERR_MSG_FRAGMENT);
        }
        catch (ParseErrorException e) {
            throw new Exception("Velocity syntax error. For more information consult the velocity log, or invoke ant with the -debug flag.");
        }
        catch (ResourceNotFoundException e) {
            throw new Exception("Resource not found. For more information consult the velocity log, or invoke ant with the -debug flag.");
        }
        catch (Exception e) {
            throw new Exception("Generation failed. For more information consult the velocity log, or invoke ant with the -debug flag.");
        }
    }

    protected void populateInitialContext(Context context) throws Exception {
        context.put("now", new Date().toString());
    }

    protected void cleanup() throws Exception {
    }

    private final void log(String message) {
        if (this.project != null) {
            this.project.log(message);
        } else {
            System.out.println(message);
        }
    }

    private final File resolveFile(String file) throws Exception {
        if (this.project != null) {
            return this.project.resolveFile(file);
        }
        return new File(file);
    }
}

