/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.texen;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class Generator {
    public static final String OUTPUT_PATH = "output.path";
    public static final String TEMPLATE_PATH = "template.path";
    private static final String DEFAULT_TEXEN_PROPERTIES = "org/apache/velocity/texen/defaults/texen.properties";
    private static Generator instance = new Generator();
    private Properties props = new Properties();
    private Context controlContext;
    private Hashtable writers = new Hashtable();
    protected String outputEncoding;
    protected String inputEncoding;
    private static /* synthetic */ Class class$Lorg$apache$velocity$app$Velocity;

    public static Generator getInstance() {
        return instance;
    }

    protected void setDefaultProps() {
        ClassLoader classLoader = (class$Lorg$apache$velocity$app$Velocity != null ? class$Lorg$apache$velocity$app$Velocity : (class$Lorg$apache$velocity$app$Velocity = Generator.class$("org.apache.velocity.app.Velocity"))).getClassLoader();
        try {
            InputStream inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(DEFAULT_TEXEN_PROPERTIES);
                this.props.load(inputStream);
            }
            finally {
                Object var4_4 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception ioe) {
            System.err.println("Cannot get default properties!");
        }
    }

    public void setTemplatePath(String templatePath) {
        ((Hashtable)this.props).put(TEMPLATE_PATH, templatePath);
    }

    public String getTemplatePath() {
        return this.props.getProperty(TEMPLATE_PATH);
    }

    public void setOutputPath(String outputPath) {
        ((Hashtable)this.props).put(OUTPUT_PATH, outputPath);
    }

    public String getOutputPath() {
        return this.props.getProperty(OUTPUT_PATH);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public Writer getWriter(String path, String encoding) throws Exception {
        BufferedWriter writer;
        if (encoding == null || encoding.length() == 0 || encoding.equals("8859-1") || encoding.equals("8859_1")) {
            FileWriter fileWriter = new FileWriter(path);
        } else {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), encoding));
        }
        return writer;
    }

    public Template getTemplate(String templateName, String encoding) throws Exception {
        Template template;
        if (encoding == null || encoding.length() == 0 || encoding.equals("8859-1") || encoding.equals("8859_1")) {
            Template template2 = Velocity.getTemplate(templateName);
        } else {
            template = Velocity.getTemplate(templateName, encoding);
        }
        return template;
    }

    public String parse(String inputTemplate, String outputFile) throws Exception {
        return this.parse(inputTemplate, outputFile, null, null);
    }

    public String parse(String inputTemplate, String outputFile, String objectID, Object object) throws Exception {
        return this.parse(inputTemplate, null, outputFile, null, objectID, object);
    }

    public String parse(String inputTemplate, String intputEncoding, String outputFile, String outputEncoding, String objectID, Object object) throws Exception {
        if (objectID != null && object != null) {
            this.controlContext.put(objectID, object);
        }
        Template template = this.getTemplate(inputTemplate, this.inputEncoding != null ? this.inputEncoding : this.inputEncoding);
        if (outputFile == null || outputFile.equals("")) {
            StringWriter sw = new StringWriter();
            template.merge(this.controlContext, sw);
            return sw.toString();
        }
        Writer writer = null;
        if (this.writers.get(outputFile) == null) {
            writer = this.getWriter(this.getOutputPath() + File.separator + outputFile, outputEncoding != null ? outputEncoding : this.outputEncoding);
            this.writers.put(outputFile, writer);
        } else {
            writer = (Writer)this.writers.get(outputFile);
        }
        VelocityContext vc = new VelocityContext(this.controlContext);
        template.merge(vc, writer);
        return "";
    }

    public String parse(String controlTemplate, Context controlContext) throws Exception {
        this.controlContext = controlContext;
        this.fillContextDefaults(this.controlContext);
        this.fillContextProperties(this.controlContext);
        Template template = this.getTemplate(controlTemplate, this.inputEncoding);
        StringWriter sw = new StringWriter();
        template.merge(controlContext, sw);
        return sw.toString();
    }

    protected Context getContext(Hashtable objs) {
        this.fillContextHash(this.controlContext, objs);
        return this.controlContext;
    }

    protected void fillContextHash(Context context, Hashtable objs) {
        Enumeration enumeration = objs.keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            context.put(key, objs.get(key));
        }
    }

    protected void fillContextDefaults(Context context) {
        context.put("generator", instance);
        context.put("outputDirectory", this.getOutputPath());
    }

    protected void fillContextProperties(Context context) {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String nm = (String)enumeration.nextElement();
            if (!nm.startsWith("context.objects.")) continue;
            String contextObj = this.props.getProperty(nm);
            int colon = nm.lastIndexOf(46);
            String contextName = nm.substring(colon + 1);
            try {
                Class<?> cls = Class.forName(contextObj);
                Object o = cls.newInstance();
                context.put(contextName, o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        Iterator iterator = this.writers.values().iterator();
        while (iterator.hasNext()) {
            Writer writer = (Writer)iterator.next();
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.writers.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Generator() {
        this.setDefaultProps();
    }

    public Generator(String propFile) {
        try {
            BufferedInputStream bi = null;
            try {
                bi = new BufferedInputStream(new FileInputStream(propFile));
                this.props.load(bi);
            }
            finally {
                Object var4_4 = null;
                if (bi != null) {
                    bi.close();
                }
            }
        }
        catch (Exception e) {
            this.setDefaultProps();
        }
    }

    public Generator(Properties props) {
        this.props = (Properties)((Hashtable)props).clone();
    }
}

