/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    private static final DateFormat ISO8601_FORMAT_OUT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'000Z'");
    private static final DateFormat ISO8601_FORMAT_IN = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static final void formatDate(Date date, StringBuffer buffer) {
        ISO8601_FORMAT_OUT.format(date, buffer, new FieldPosition(0));
    }

    public static final String formatDate(Date date) {
        if (date == null || date.getTime() == 0L) {
            return null;
        }
        return ISO8601_FORMAT_OUT.format(date);
    }

    public static final Date parseDate(String str) {
        if (str == null) {
            return new Date(0L);
        }
        str = str.substring(0, 23);
        try {
            return ISO8601_FORMAT_IN.parse(str);
        }
        catch (Throwable throwable) {
            return new Date(0L);
        }
    }

    public static final String toHumanDate(String str) {
        if (str == null) {
            return "";
        }
        str = str.replace('T', ' ');
        str = str.substring(0, 19) + 'Z';
        return str;
    }

    static {
        ISO8601_FORMAT_IN.setTimeZone(TimeZone.getTimeZone("GMT"));
        ISO8601_FORMAT_OUT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

