/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;

public class PathUtil {
    public static final boolean isEmpty(String path) {
        return path == null || "".equals(path.trim()) || "/".equals(path.trim());
    }

    public static final String removeTail(String path) {
        if (PathUtil.isEmpty(path)) {
            return null;
        }
        int index = (path = PathUtil.removeTrailingSlash(path)).lastIndexOf(47);
        if (index <= 0) {
            return "/";
        }
        return path.substring(0, index);
    }

    public static final String append(String path, String segment) {
        path = PathUtil.isEmpty(path) ? "" : PathUtil.removeTrailingSlash(path);
        String string = segment = PathUtil.isEmpty(segment) ? "" : PathUtil.removeLeadingSlash(segment);
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - "/".length());
        }
        if (segment.startsWith("/")) {
            segment = segment.substring("/".length());
        }
        return path + '/' + segment;
    }

    public static String tail(String path) {
        int index = (path = PathUtil.removeTrailingSlash(path)).lastIndexOf(47);
        if (index >= 0) {
            return path.substring(index + 1);
        }
        return path;
    }

    public static String head(String path) {
        int index = (path = PathUtil.removeLeadingSlash(path)).indexOf(47);
        if (index >= 0) {
            return path.substring(0, index);
        }
        return path;
    }

    public static String removeLeadingSlash(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    public static final String removeTrailingSlash(String path) {
        if (PathUtil.isEmpty(path)) {
            return path;
        }
        if (path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static void encode(String urlPart, StringBuffer dst) {
        StringTokenizer tokens = new StringTokenizer(urlPart, " /+()", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (" ".equals(token)) {
                dst.append("%20");
                continue;
            }
            if ("+".equals(token) || "/".equals(token) || "(".equals(token) || ")".equals(token)) {
                dst.append(token);
                continue;
            }
            try {
                dst.append(URLEncoder.encode(token, "UTF-8"));
            }
            catch (IOException e) {
                dst.append(token);
            }
        }
    }

    public static String encode(String source) {
        StringBuffer sb = new StringBuffer();
        PathUtil.encode(source, sb);
        return sb.toString();
    }

    public static String decode(String source) {
        if (source == null) {
            return source;
        }
        StringBuffer dst = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(source, "+/:", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("+".equals(token)) {
                dst.append("+");
                continue;
            }
            if ("/".equals(token)) {
                dst.append("/");
                continue;
            }
            if (":".equals(token)) {
                dst.append(":");
                continue;
            }
            try {
                dst.append(URLDecoder.decode(token, "UTF-8"));
            }
            catch (IOException e) {
                dst.append(token);
            }
        }
        return dst.toString();
    }

    public static String getFSCommonRoot(String[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        String root = paths[0].replace(File.separatorChar, '/');
        for (int i = 1; i < paths.length; ++i) {
            root = PathUtil.getCommonAncestor(root, paths[i].replace(File.separatorChar, '/'));
        }
        File fileRoot = new File(root);
        if (fileRoot.isFile()) {
            root = PathUtil.removeTail(root);
        }
        return root;
    }

    public static String getCommonRoot(String[] paths) {
        int i;
        if (paths.length == 1) {
            return PathUtil.removeLeadingSlash(PathUtil.removeTail(paths[0]));
        }
        String root = paths[0].replace(File.separatorChar, '/');
        for (i = 1; i < paths.length; ++i) {
            root = PathUtil.getCommonAncestor(root, paths[i].replace(File.separatorChar, '/'));
        }
        root = PathUtil.removeLeadingSlash(root);
        root = PathUtil.removeTrailingSlash(root);
        for (i = 0; i < paths.length; ++i) {
            if (!paths[i].replace(File.separatorChar, '/').equals(root)) continue;
            root = PathUtil.removeTail(root);
            break;
        }
        return root;
    }

    private static String getCommonAncestor(String path1, String path2) {
        String root;
        String longerPath = path1.length() > path2.length() ? path1 : path2;
        String string = root = path1.length() > path2.length() ? path2 : path1;
        if ("".equals(root)) {
            root = "/";
        }
        while (!PathUtil.isEmpty(root)) {
            boolean rootFound;
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            boolean bl = rootFound = FSUtil.isWindows ? longerPath.toLowerCase().startsWith(root.toLowerCase()) : longerPath.startsWith(root);
            if (rootFound) {
                return PathUtil.removeTrailingSlash(root);
            }
            root = PathUtil.removeTail(root);
        }
        return PathUtil.removeTrailingSlash(root);
    }

    public static boolean isURL(String pathOrUrl) {
        return pathOrUrl != null && (pathOrUrl.startsWith("http://") || pathOrUrl.startsWith("https://") || pathOrUrl.startsWith("svn://") || pathOrUrl.startsWith("svn+ssh://"));
    }
}

