/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.util.LoggingStreamLogger;

public class LoggingOutputStream
extends OutputStream {
    private final OutputStream myOutputStream;
    private final StringBuffer myBuffer;
    private final LoggingStreamLogger myLogger;

    public LoggingOutputStream(OutputStream outputStream, LoggingStreamLogger logger) {
        this.myOutputStream = outputStream;
        this.myBuffer = logger != null ? new StringBuffer() : null;
        this.myLogger = logger;
    }

    public void write(int b) throws IOException {
        this.myOutputStream.write(b);
        if (this.myBuffer != null) {
            this.myBuffer.append((char)b);
        }
    }

    public void close() throws IOException {
        this.myOutputStream.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.myOutputStream.write(b, off, len);
        if (this.myBuffer != null) {
            this.myBuffer.append(new String(b, off, len));
        }
    }

    public void flush() throws IOException {
        this.myOutputStream.flush();
    }

    public void log() {
        if (this.myBuffer != null && this.myBuffer.length() > 0) {
            this.myLogger.logStream(this.myBuffer.toString(), true);
            this.myBuffer.delete(0, this.myBuffer.length());
        }
    }
}

