/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.util.LoggingStreamLogger;

public class LoggingInputStream
extends InputStream {
    private final InputStream myInputStream;
    private final StringBuffer myBuffer;
    private final LoggingStreamLogger myLogger;

    public LoggingInputStream(InputStream inputStream, LoggingStreamLogger logger) {
        this.myInputStream = inputStream;
        this.myBuffer = logger != null ? new StringBuffer() : null;
        this.myLogger = logger;
    }

    public int read() throws IOException {
        int read = this.myInputStream.read();
        if (this.myBuffer != null && read >= 0) {
            this.myBuffer.append((char)read);
        }
        return read;
    }

    public void close() throws IOException {
        this.myInputStream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.myInputStream.read(b, off, len);
        if (this.myBuffer != null && read >= 0) {
            this.myBuffer.append(new String(b, off, read));
        }
        return read;
    }

    public int available() throws IOException {
        return this.myInputStream.available();
    }

    public void reset() throws IOException {
        this.myInputStream.reset();
    }

    public boolean markSupported() {
        return this.myInputStream.markSupported();
    }

    public void mark(int readlimit) {
        this.myInputStream.mark(readlimit);
    }

    public long skip(long n) throws IOException {
        return this.myInputStream.skip(n);
    }

    public void log() {
        if (this.myBuffer != null && this.myBuffer.length() > 0) {
            this.myLogger.logStream(this.myBuffer.toString(), false);
            this.myBuffer.delete(0, this.myBuffer.length());
        }
    }
}

