/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.util.DebugDefaultLogger;
import org.tmatesoft.svn.util.DebugLogger;
import org.tmatesoft.svn.util.LoggingInputStream;
import org.tmatesoft.svn.util.LoggingOutputStream;

public class DebugLog {
    private static DebugLogger ourLogger;
    private static final File ourSafeModeTrigger;

    public static void setLogger(DebugLogger logger) {
        ourLogger = logger;
    }

    public static boolean isEnabled() {
        return DebugLog.getLogger() != null;
    }

    public static void log(String message) {
        if (DebugLog.getLogger() == null || !DebugLog.getLogger().isFineEnabled()) {
            return;
        }
        DebugLog.getLogger().logFine(message);
    }

    public static void logInfo(String message) {
        if (DebugLog.getLogger() == null || !DebugLog.getLogger().isInfoEnabled()) {
            return;
        }
        DebugLog.getLogger().logInfo(message);
    }

    public static void benchmark(String message) {
        if (DebugLog.getLogger() == null || !DebugLog.getLogger().isInfoEnabled()) {
            return;
        }
        DebugLog.getLogger().logInfo(message);
    }

    public static void error(String message) {
        if (DebugLog.getLogger() == null || !DebugLog.getLogger().isErrorEnabled()) {
            return;
        }
        DebugLog.getLogger().logError(message, null);
    }

    public static void error(Throwable th) {
        if (DebugLog.getLogger() == null || !DebugLog.getLogger().isErrorEnabled()) {
            return;
        }
        DebugLog.getLogger().logError(th.getMessage(), th);
    }

    public static boolean isGeneratorDisabled() {
        if (DebugLog.getLogger() == null) {
            return false;
        }
        if (DebugLog.isSafeModeDefault()) {
            return !Boolean.getBoolean("javasvn.generator.enabled");
        }
        if (System.getProperty("javasvn.generator.enabled") == null) {
            return false;
        }
        return !Boolean.getBoolean("javasvn.generator.enabled");
    }

    public static LoggingInputStream getLoggingInputStream(String protocol, InputStream stream) {
        if (DebugLog.getLogger() == null) {
            return new LoggingInputStream(stream, null);
        }
        return DebugLog.getLogger().getLoggingInputStream(protocol, stream);
    }

    public static LoggingOutputStream getLoggingOutputStream(String protocol, OutputStream stream) {
        if (DebugLog.getLogger() == null) {
            return new LoggingOutputStream(stream, null);
        }
        return DebugLog.getLogger().getLoggingOutputStream(protocol, stream);
    }

    static boolean isSafeModeDefault() {
        if (DebugLog.getLogger() == null) {
            return false;
        }
        return ourSafeModeTrigger.exists();
    }

    private static DebugLogger getLogger() {
        if (ourLogger == null) {
            ourLogger = new DebugDefaultLogger();
        }
        return ourLogger;
    }

    static {
        ourSafeModeTrigger = new File(".javasvn.safemode");
    }
}

