/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.progress;

import org.tmatesoft.svn.core.progress.ISVNProgressViewer;
import org.tmatesoft.svn.util.SVNAssert;

public class SVNProgressRangeViewer
implements ISVNProgressViewer {
    private final double lowerBound;
    private final double upperBound;
    private final ISVNProgressViewer parentProgressViewer;

    public static ISVNProgressViewer createInstance(ISVNProgressViewer parentProgressViewer, long currentIndex, long indexCount) {
        SVNAssert.assertNotNull(parentProgressViewer);
        SVNAssert.assertTrue(currentIndex >= 0L);
        SVNAssert.assertTrue(currentIndex < indexCount);
        if (currentIndex == 0L && indexCount == 1L) {
            return parentProgressViewer;
        }
        double lowerBound = 1.0 * (double)currentIndex / (double)indexCount;
        double upperBound = 1.0 * (double)(currentIndex + 1L) / (double)indexCount;
        return new SVNProgressRangeViewer(parentProgressViewer, lowerBound, upperBound);
    }

    public static ISVNProgressViewer createInstance(ISVNProgressViewer parentProgressViewer, double lowerBound, double upperBound) {
        SVNAssert.assertNotNull(parentProgressViewer);
        SVNAssert.assertTrue(lowerBound >= 0.0 && lowerBound <= upperBound && upperBound <= 1.0);
        return new SVNProgressRangeViewer(parentProgressViewer, lowerBound, upperBound);
    }

    private SVNProgressRangeViewer(ISVNProgressViewer parentProgressViewer, double lowerBound, double upperBound) {
        SVNAssert.assertNotNull(parentProgressViewer);
        this.parentProgressViewer = parentProgressViewer;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void setProgress(double value) {
        SVNAssert.assertTrue(0.0 <= value && value <= 1.0);
        double boundedValue = (1.0 - value) * this.lowerBound + value * this.upperBound;
        this.parentProgressViewer.setProgress(boundedValue);
    }
}

