/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.PathUtil;

public class SVNRepositoryLocation {
    private String myPath;
    private final String myHost;
    private final int myPort;
    private final String myProtocol;
    private String myAsString;
    static /* synthetic */ Class class$org$tmatesoft$svn$core$io$SVNRepositoryLocation;

    public static boolean equals(SVNRepositoryLocation location1, SVNRepositoryLocation location2) {
        if (location1 == null || location2 == null) {
            return location1 == location2;
        }
        return location1.toString().equals(location2.toString());
    }

    public static SVNRepositoryLocation parseURL(String location) throws SVNException {
        if (location == null) {
            return null;
        }
        int index = location.indexOf(58);
        if (index < 0) {
            throw new SVNException("malformed url: " + location);
        }
        String protocol = location.substring(0, index);
        location = "http" + location.substring(protocol.length());
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            throw new SVNException("malformed url " + location);
        }
        if (url != null) {
            String path;
            String host = url.getHost();
            int port = url.getPort();
            if (port < 0) {
                if ("svn".equals(protocol)) {
                    port = 3690;
                } else if ("http".equals(protocol)) {
                    port = 80;
                } else if ("https".equals(protocol)) {
                    port = 443;
                } else if ("svn+ssh".equals(protocol)) {
                    port = 22;
                }
            }
            if (!(path = url.getPath()).endsWith("/")) {
                path = path + "/";
            }
            return new SVNRepositoryLocation(protocol, host, port, path);
        }
        throw new SVNException("malformed url " + location);
    }

    public SVNRepositoryLocation(String protocol, String host, int port, String path) {
        this.myHost = host;
        this.myProtocol = protocol;
        this.myPort = port;
        this.myPath = path;
        this.myPath = PathUtil.removeTrailingSlash(this.myPath);
        this.myPath = PathUtil.encode(this.myPath);
    }

    public String getProtocol() {
        return this.myProtocol;
    }

    public String getHost() {
        return this.myHost;
    }

    public String getPath() {
        return this.myPath;
    }

    public int getPort() {
        return this.myPort;
    }

    public String toString() {
        if (this.myAsString != null) {
            return this.myAsString;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.myProtocol);
        sb.append("://");
        sb.append(PathUtil.encode(this.myHost));
        if (this.myPort != SVNRepositoryLocation.getDefaultPort(this.myProtocol)) {
            sb.append(':');
            sb.append(this.myPort);
        }
        sb.append(this.myPath);
        this.myAsString = sb.toString();
        return sb.toString();
    }

    public String toCanonicalForm() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.myProtocol);
        sb.append("://");
        sb.append(PathUtil.encode(this.myHost));
        sb.append(':');
        sb.append(this.myPort);
        sb.append(this.myPath);
        return sb.toString();
    }

    private static int getDefaultPort(String protocol) {
        if ("http".equals(protocol)) {
            return 80;
        }
        if ("svn".equals(protocol)) {
            return -1;
        }
        if ("https".equals(protocol)) {
            return 443;
        }
        if ("svn+ssh".equals(protocol)) {
            return 22;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != (class$org$tmatesoft$svn$core$io$SVNRepositoryLocation == null ? (class$org$tmatesoft$svn$core$io$SVNRepositoryLocation = SVNRepositoryLocation.class$("org.tmatesoft.svn.core.io.SVNRepositoryLocation")) : class$org$tmatesoft$svn$core$io$SVNRepositoryLocation)) {
            return false;
        }
        return this.toCanonicalForm().equals(((SVNRepositoryLocation)o).toCanonicalForm());
    }

    public int hashCode() {
        return this.toCanonicalForm().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

