/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.internal.io.SVNAnnotate;
import org.tmatesoft.svn.core.io.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNDirEntry;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLogEntry;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;

public abstract class SVNRepository {
    private OutputStream myLoggingOutput;
    private OutputStream myLoggingInput;
    private String myRepositoryUUID;
    private String myRepositoryRoot;
    private SVNRepositoryLocation myLocation;
    private int myLockCount;
    private Thread myLocker;
    private ISVNCredentialsProvider myUserCredentialsProvider;

    protected SVNRepository(SVNRepositoryLocation location) {
        this.myLocation = location;
    }

    public SVNRepositoryLocation getLocation() {
        return this.myLocation;
    }

    public void setLoggingStreams(OutputStream out, OutputStream in) {
        this.myLoggingOutput = out;
        this.myLoggingInput = in;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public String getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public void setCredentialsProvider(ISVNCredentialsProvider provider) {
        this.myUserCredentialsProvider = provider;
    }

    public ISVNCredentialsProvider getCredentialsProvider() {
        return this.myUserCredentialsProvider;
    }

    protected void setRepositoryCredentials(String uuid, String root) {
        if (uuid != null && root != null) {
            this.myRepositoryUUID = uuid;
            this.myRepositoryRoot = root;
            DebugLog.log("REPOSITORY: " + uuid + ":" + root);
        }
    }

    public abstract void testConnection() throws SVNException;

    public abstract long getLatestRevision() throws SVNException;

    public abstract long getDatedRevision(Date var1) throws SVNException;

    public abstract Map getRevisionProperties(long var1, Map var3) throws SVNException;

    public abstract void setRevisionPropertyValue(long var1, String var3, String var4) throws SVNException;

    public abstract String getRevisionPropertyValue(long var1, String var3) throws SVNException;

    public abstract SVNNodeKind checkPath(String var1, long var2) throws SVNException;

    public abstract long getFile(String var1, long var2, Map var4, OutputStream var5) throws SVNException;

    public abstract long getDir(String var1, long var2, Map var4, ISVNDirEntryHandler var5) throws SVNException;

    public abstract int getFileRevisions(String var1, long var2, long var4, ISVNFileRevisionHandler var6) throws SVNException;

    public abstract int log(String[] var1, long var2, long var4, boolean var6, boolean var7, ISVNLogEntryHandler var8) throws SVNException;

    public abstract int getLocations(String var1, long var2, long[] var4, ISVNLocationEntryHandler var5) throws SVNException;

    public Collection getFileRevisions(String path, Collection revisions, long sRevision, long eRevision) throws SVNException {
        final Collection result = revisions != null ? revisions : new LinkedList();
        ISVNFileRevisionHandler handler = new ISVNFileRevisionHandler(){

            public void hanldeFileRevision(SVNFileRevision fileRevision) {
                result.add(fileRevision);
            }

            public OutputStream handleDiffWindow(String token, SVNDiffWindow delta) {
                return null;
            }

            public void hanldeDiffWindowClosed(String token) {
            }
        };
        this.getFileRevisions(path, sRevision, eRevision, handler);
        return result;
    }

    public Collection getDir(String path, long revision, Map properties, Collection dirEntries) throws SVNException {
        final Collection result = dirEntries != null ? dirEntries : new LinkedList();
        ISVNDirEntryHandler handler = null;
        handler = new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) {
                result.add(dirEntry);
            }
        };
        this.getDir(path, revision, properties, handler);
        return result;
    }

    public Collection log(String[] targetPaths, Collection entries, long startRevision, long endRevision, boolean changedPath, boolean strictNode) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.log(targetPaths, startRevision, endRevision, changedPath, strictNode, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) {
                result.add(logEntry);
            }
        });
        return result;
    }

    public Collection getLocations(String path, Collection entries, long pegRevision, long[] revisions) throws SVNException {
        final Collection result = entries != null ? entries : new LinkedList();
        this.getLocations(path, pegRevision, revisions, new ISVNLocationEntryHandler(){

            public void handleLocationEntry(SVNLocationEntry locationEntry) {
                result.add(locationEntry);
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(String path, long startRevision, long endRevision, ISVNAnnotateHandler handler) throws SVNException {
        if (handler == null) {
            return;
        }
        if (endRevision < 0L || endRevision < 0L) {
            long lastRevision = this.getLatestRevision();
            startRevision = startRevision < 0L ? lastRevision : startRevision;
            endRevision = endRevision < 0L ? lastRevision : endRevision;
        }
        SVNAnnotate annotate = new SVNAnnotate();
        annotate.setAnnotateHandler(handler);
        try {
            this.getFileRevisions(path, startRevision, endRevision, annotate);
        }
        finally {
            annotate.dispose();
        }
    }

    public abstract void diff(String var1, long var2, String var4, boolean var5, boolean var6, ISVNReporterBaton var7, ISVNEditor var8) throws SVNException;

    public abstract void update(long var1, String var3, boolean var4, ISVNReporterBaton var5, ISVNEditor var6) throws SVNException;

    public abstract void status(long var1, String var3, boolean var4, ISVNReporterBaton var5, ISVNEditor var6) throws SVNException;

    public abstract void update(String var1, long var2, String var4, boolean var5, ISVNReporterBaton var6, ISVNEditor var7) throws SVNException;

    public void checkout(long revision, String target, boolean recursive, ISVNEditor editor) throws SVNException {
        final long lastRev = revision >= 0L ? revision : this.getLatestRevision();
        SVNNodeKind nodeKind = this.checkPath("", revision);
        if (nodeKind == SVNNodeKind.FILE) {
            throw new SVNException("svn: URL '" + this.getLocation().toString() + "' refers to a file, not a directory");
        }
        this.update(revision, target, recursive, new ISVNReporterBaton(){

            public void report(ISVNReporter reporter) throws SVNException {
                reporter.setPath("", lastRev, true);
                reporter.finishReport();
            }
        }, editor);
    }

    public abstract ISVNEditor getCommitEditor(String var1, ISVNWorkspaceMediator var2) throws SVNException;

    protected synchronized void lock() {
        try {
            while (this.myLockCount > 0 || this.myLocker != null) {
                if (Thread.currentThread() == this.myLocker) {
                    throw new Error("SVNRerpository methods are not reenterable");
                }
                this.wait();
            }
            this.myLocker = Thread.currentThread();
            this.myLockCount = 1;
        }
        catch (InterruptedException e) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    protected synchronized void unlock() {
        if (--this.myLockCount <= 0) {
            this.myLockCount = 0;
            this.myLocker = null;
            this.notifyAll();
        }
    }

    protected OutputStream getOutputLoggingStream() {
        return this.myLoggingOutput;
    }

    protected OutputStream getInputLoggingStream() {
        return this.myLoggingInput;
    }

    protected static boolean isInvalidRevision(long revision) {
        return revision < 0L;
    }

    protected static boolean isValidRevision(long revision) {
        return revision >= 0L;
    }

    protected static Long getRevisionObject(long revision) {
        return SVNRepository.isValidRevision(revision) ? new Long(revision) : null;
    }

    protected static void assertValidRevision(long revision) throws SVNException {
        if (!SVNRepository.isValidRevision(revision)) {
            throw new SVNException("only valid revisions (>=0) are accepted in this method");
        }
    }

    protected static String getCanonicalURL(String url) throws SVNException {
        if (url == null) {
            return null;
        }
        SVNRepositoryLocation location = SVNRepositoryLocation.parseURL(url);
        if (location != null) {
            return location.toString();
        }
        return null;
    }
}

