/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.tmatesoft.svn.core.diff.ISVNRAData;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;

public class SVNRAFileData
implements ISVNRAData {
    private RandomAccessFile myFile;
    private File myRawFile;
    private byte[] myBuffer;
    private SelfStream mySelfStream;
    private boolean myIsReadonly;

    public SVNRAFileData(File file, boolean readonly) {
        this.myRawFile = file;
        this.myIsReadonly = readonly;
    }

    public InputStream read(long offset, long length) throws IOException {
        if (this.mySelfStream != null) {
            this.mySelfStream.reset(length, offset);
        } else {
            this.mySelfStream = new SelfStream(length, offset);
        }
        return this.mySelfStream;
    }

    public void append(InputStream source, long length) throws IOException {
        int read;
        int lLength = (int)length;
        if (this.myBuffer == null || (long)this.myBuffer.length < length) {
            this.myBuffer = new byte[lLength];
        }
        if (this.myFile == null) {
            this.getRAFile().seek(this.myFile.length());
        }
        do {
            read = source.read(this.myBuffer, 0, lLength);
            this.myFile.write(this.myBuffer, 0, read);
        } while ((lLength -= read) > 0);
    }

    public void close() throws IOException {
        if (this.myFile == null) {
            return;
        }
        this.myFile.close();
        this.myFile = null;
    }

    public long length() {
        return this.myRawFile.length();
    }

    public long lastModified() {
        return this.myRawFile.lastModified();
    }

    private RandomAccessFile getRAFile() throws IOException {
        if (this.myFile == null) {
            if (!this.myRawFile.exists()) {
                this.myRawFile.getParentFile().mkdirs();
                this.myRawFile.createNewFile();
            }
            if (!this.myIsReadonly) {
                FSUtil.setReadonly(this.myRawFile, false);
            }
            this.myFile = new RandomAccessFile(this.myRawFile, this.myIsReadonly ? "r" : "rw");
        }
        return this.myFile;
    }

    private final class SelfStream
    extends InputStream {
        private long myOffset;
        private int myLength;

        private SelfStream(long length, long offset) {
            this.myOffset = offset;
            this.myLength = (int)length;
        }

        public void reset(long length, long offset) {
            this.myOffset = offset;
            this.myLength = (int)length;
        }

        public int read() throws IOException {
            byte[] buffer = new byte[]{-1};
            this.read(buffer, 0, 1);
            return buffer[0];
        }

        public int read(byte[] buffer, int userOffset, int userLength) throws IOException {
            if (this.myLength <= 0) {
                return -1;
            }
            int available = (int)(SVNRAFileData.this.getRAFile().length() - this.myOffset);
            int toRead = Math.min(available, this.myLength);
            toRead = Math.min(userLength, toRead);
            this.myLength -= toRead;
            long pos = SVNRAFileData.this.getRAFile().length();
            SVNRAFileData.this.myFile.seek(this.myOffset);
            int result = SVNRAFileData.this.myFile.read(buffer, userOffset, toRead);
            SVNRAFileData.this.myFile.seek(pos);
            this.myOffset += (long)toRead;
            return result;
        }
    }
}

