/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.diff.delta.SVNSequenceLineReader;
import org.tmatesoft.svn.util.DebugLog;

public class FSUtil {
    public static final boolean isWindows;
    public static final OutputStream NULL_OUTPUT;
    private static ByteArrayOutputStream myLineBuffer;
    private static byte[] myBinaryBuffer;
    private static int myFirstByte;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final byte[] CR_BYTES;
    private static final byte[] LF_BYTES;
    private static final byte[] CRLF_BYTES;

    public static boolean isSymlink(File file) {
        if (isWindows || file == null) {
            return false;
        }
        if (!file.exists()) {
            File parent = file.getParentFile();
            String[] children = parent.list();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].equals(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }
        try {
            return !file.getAbsolutePath().equals(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isFileOrSymlinkExists(File file) {
        if (file == null) {
            return false;
        }
        if (isWindows) {
            return file.exists();
        }
        if (!file.exists()) {
            File parent = file.getParentFile();
            String[] children = parent.list();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].equals(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static void setHidden(File file, boolean hidden) {
        if (!isWindows || file == null || !file.exists() || file.isHidden()) {
            return;
        }
        try {
            Runtime.getRuntime().exec("attrib " + (hidden ? "+" : "-") + "H \"" + file.getAbsolutePath() + "\"");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setExecutable(File file, boolean executable) {
        if (isWindows || file == null || !file.exists()) {
            return;
        }
        try {
            Runtime.getRuntime().exec("chmod ugo" + (executable ? "+" : "-") + "x \"" + file.getAbsolutePath() + "\"");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setReadonly(File file, boolean readonly) {
        if (file.canWrite() == !readonly || !file.exists()) {
            return;
        }
        if (readonly && file.setReadOnly()) {
            return;
        }
        try {
            Process p = null;
            p = isWindows ? Runtime.getRuntime().exec("attrib " + (readonly ? "+" : "-") + "R \"" + file.getAbsolutePath() + "\"") : Runtime.getRuntime().exec(new String[]{"chmod", "ugo" + (readonly ? "-" : "+") + "w", file.getAbsolutePath()});
            if (p != null) {
                p.waitFor();
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    public static void deleteAll(File dir) {
        if (dir == null) {
            return;
        }
        File[] children = dir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                FSUtil.deleteAll(child);
            }
        }
        if (!dir.delete()) {
            DebugLog.log("can't delete file " + dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyAll(File source, File dst, String asName, FileFilter filter) throws IOException {
        block18: {
            IOException e22;
            BufferedInputStream is;
            block17: {
                if (source != null && source.equals(dst)) {
                    return dst;
                }
                if (!source.exists()) {
                    return null;
                }
                if (filter != null && !filter.accept(source)) {
                    return dst;
                }
                if (source.isDirectory()) {
                    File dstDir = new File(dst, asName);
                    dstDir.mkdirs();
                    File[] children = source.listFiles();
                    for (int i = 0; i < children.length; ++i) {
                        FSUtil.copyAll(children[i], dstDir, children[i].getName(), filter);
                    }
                    return dstDir;
                }
                is = null;
                OutputStream os = null;
                if (!(dst = new File(dst, asName)).getParentFile().exists()) {
                    dst.getParentFile().mkdirs();
                }
                try {
                    is = new BufferedInputStream(new FileInputStream(source));
                    os = new BufferedOutputStream(new FileOutputStream(dst));
                    FSUtil.copy(is, os, null, null, null);
                    Object var8_9 = null;
                    if (os == null) break block17;
                }
                catch (Throwable throwable) {
                    IOException e22;
                    Object var8_10 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    dst.setLastModified(source.lastModified());
                    throw throwable;
                }
                try {
                    os.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                    break block18;
                }
                catch (IOException e22) {
                    // empty catch block
                }
                {
                }
            }
        }
        dst.setLastModified(source.lastModified());
        return dst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareFiles(File f1, File f2, boolean isBinary) throws IOException {
        block41: {
            block36: {
                block40: {
                    block35: {
                        block39: {
                            block34: {
                                block31: {
                                    block32: {
                                        is1 = null;
                                        is2 = null;
                                        try {
                                            block37: {
                                                if (isBinary && f1.length() != f2.length()) {
                                                    var5_5 = false;
                                                    var11_8 = null;
                                                    if (is1 == null) break block31;
                                                    break block32;
                                                }
                                                is1 = new BufferedInputStream(new FileInputStream(f1));
                                                is2 = new BufferedInputStream(new FileInputStream(f2));
                                                if (isBinary) {
                                                    do {
                                                        if ((read1 = is1.read()) == (read2 = is2.read())) continue;
                                                        var7_24 = false;
                                                        var11_9 = null;
                                                        if (is1 != null) {
                                                            try {
                                                                is1.close();
                                                            }
                                                            catch (IOException e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        if (is2 == null) return var7_24;
                                                        try {
                                                            is2.close();
                                                            return var7_24;
                                                        }
                                                        catch (IOException e) {
                                                            // empty catch block
                                                        }
                                                        return var7_24;
                                                    } while (read1 >= 0 && read2 >= 0);
                                                } else {
                                                    reader = new SVNSequenceLineReader(new byte[0]);
                                                    lines1 = reader.read(is1);
                                                    lines2 = reader.read(is2);
                                                    if (lines1 == null || lines2 == null) {
                                                        var8_26 = lines1 == lines2;
                                                        break block34;
                                                    }
                                                    if (lines1.length != lines2.length) {
                                                        var8_27 = false;
                                                        break block35;
                                                    }
                                                    for (i = 0; i < lines1.length; ++i) {
                                                        if (lines1[i].equals(lines2[i])) continue;
                                                        var9_29 = false;
                                                        break block36;
                                                    }
                                                }
                                                var11_13 = null;
                                                if (is1 != null) {
                                                    ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl53:
                                                    // 1 sources

                                                    is1.close();
                                                    break block37;
lbl55:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (is2 == null) return true;
                                            try {}
                                            catch (IOException e) {
                                                return true;
                                            }
                                            is2.close();
                                            return true;
                                        }
                                        catch (Throwable var10_30) {
                                            block38: {
                                                var11_14 = null;
                                                if (is1 != null) {
                                                    ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl69:
                                                    // 1 sources

                                                    is1.close();
                                                    break block38;
lbl71:
                                                    // 1 sources

                                                    catch (IOException e) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            if (is2 == null) throw var10_30;
                                            ** try [egrp 2[TRYBLOCK] [8 : 265->273)] { 
lbl76:
                                            // 1 sources

                                            is2.close();
                                            throw var10_30;
lbl78:
                                            // 1 sources

                                            catch (IOException e) {
                                                // empty catch block
                                            }
                                            throw var10_30;
                                        }
                                    }
                                    ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl83:
                                    // 1 sources

                                    is1.close();
                                    break block31;
lbl85:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                }
                                if (is2 == null) return var5_5;
                                ** try [egrp 2[TRYBLOCK] [8 : 265->273)] { 
lbl90:
                                // 1 sources

                                is2.close();
                                return var5_5;
lbl92:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var5_5;
                            }
                            var11_10 = null;
                            if (is1 != null) {
                                ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl99:
                                // 1 sources

                                is1.close();
                                break block39;
lbl101:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                        }
                        if (is2 == null) return var8_26;
                        ** try [egrp 2[TRYBLOCK] [8 : 265->273)] { 
lbl106:
                        // 1 sources

                        is2.close();
                        return var8_26;
lbl108:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var8_26;
                    }
                    var11_11 = null;
                    if (is1 != null) {
                        ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl115:
                        // 1 sources

                        is1.close();
                        break block40;
lbl117:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (is2 == null) return var8_27;
                ** try [egrp 2[TRYBLOCK] [8 : 265->273)] { 
lbl122:
                // 1 sources

                is2.close();
                return var8_27;
lbl124:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var8_27;
            }
            var11_12 = null;
            if (is1 != null) {
                ** try [egrp 1[TRYBLOCK] [7 : 251->258)] { 
lbl131:
                // 1 sources

                is1.close();
                break block41;
lbl133:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (is2 == null) return var9_29;
        ** try [egrp 2[TRYBLOCK] [8 : 265->273)] { 
lbl138:
        // 1 sources

        is2.close();
        return var9_29;
lbl140:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var9_29;
    }

    public static String copy(InputStream is, OutputStream os, MessageDigest digest) throws IOException {
        return FSUtil.copy(is, os, null, digest);
    }

    public static String copy(InputStream is, OutputStream os, String eol, MessageDigest digest) throws IOException {
        return FSUtil.copy(is, os, eol, null, digest);
    }

    public static String copy(InputStream is, final OutputStream os, String eol, Map keywordsMap, final MessageDigest digest) throws IOException {
        OutputStream dos = digest != null ? new OutputStream(){

            public void write(int b) throws IOException {
                digest.update((byte)(b & 0xFF));
                os.write(b);
            }

            public void write(byte[] b, int o, int l) throws IOException {
                digest.update(b, o, l);
                os.write(b, o, l);
            }
        } : os;
        Map map = keywordsMap = keywordsMap != null && keywordsMap.isEmpty() ? null : keywordsMap;
        if (eol == null && keywordsMap == null) {
            while (true) {
                int read;
                if ((read = is.read(myBinaryBuffer)) < 0) {
                    return FSUtil.toHexDigest(digest);
                }
                dos.write(myBinaryBuffer, 0, read);
            }
        }
        byte[] replaceWith = eol != null ? SVNProperty.getEOLBytes(eol) : null;
        byte[] realEOL = null;
        OutputStream target = keywordsMap != null ? myLineBuffer : dos;
        myFirstByte = -1;
        do {
            if (replaceWith == null) {
                realEOL = FSUtil.readLine(is, target);
            } else if (FSUtil.readLine(is, target) == null) {
                replaceWith = null;
            }
            if (keywordsMap != null) {
                byte[] strBytes = myLineBuffer.toByteArray();
                if (strBytes.length > 0) {
                    String line = new String(strBytes);
                    Iterator keywords = keywordsMap.keySet().iterator();
                    while (keywords.hasNext()) {
                        String keyword = (String)keywords.next();
                        line = FSUtil.expandKeyword(line, keyword, (String)keywordsMap.get(keyword));
                    }
                    dos.write(line.getBytes());
                }
                myLineBuffer.reset();
            }
            if (replaceWith == null && realEOL != null) {
                dos.write(realEOL);
                continue;
            }
            if (replaceWith == null) continue;
            dos.write(replaceWith);
        } while (replaceWith != null || realEOL != null);
        return FSUtil.toHexDigest(digest);
    }

    private static byte[] readLine(InputStream is, OutputStream os) throws IOException {
        if (myFirstByte >= 0) {
            os.write(myFirstByte);
            myFirstByte = -1;
        }
        while (true) {
            int b = is.read();
            switch (b) {
                case 13: {
                    b = is.read();
                    myFirstByte = -1;
                    if (b == 10) {
                        return CRLF_BYTES;
                    }
                    if (b >= 0) {
                        myFirstByte = b;
                    }
                    return CR_BYTES;
                }
                case 10: {
                    myFirstByte = -1;
                    return LF_BYTES;
                }
            }
            if (b < 0) {
                myFirstByte = -1;
                return null;
            }
            os.write(b);
        }
    }

    private static String toHexDigest(MessageDigest digest) {
        if (digest == null) {
            return null;
        }
        byte[] result = digest.digest();
        String hexDigest = "";
        for (int i = 0; i < result.length; ++i) {
            byte b = result[i];
            int lo = b & 0xF;
            int hi = b >> 4 & 0xF;
            hexDigest = hexDigest + Integer.toHexString(hi) + Integer.toHexString(lo);
        }
        return hexDigest;
    }

    private static String expandKeyword(String line, String keyword, String value) {
        int prevIndex;
        int index = 0;
        StringBuffer result = new StringBuffer();
        if (value != null) {
            int prevIndex2;
            String pattern = "$" + keyword + "$";
            while (true) {
                prevIndex2 = index;
                if ((index = line.indexOf(pattern, index)) < 0) break;
                result.append(line.substring(prevIndex2, index));
                result.append("$");
                result.append(keyword);
                result.append(": ");
                result.append(value);
                if (value.length() > 0) {
                    result.append(' ');
                }
                result.append("$");
                index += pattern.length();
            }
            result.append(line.substring(prevIndex2));
            return result.toString();
        }
        String pattern = "$" + keyword + ": ";
        while (true) {
            prevIndex = index;
            index = line.indexOf(pattern, index);
            int lastIndex = line.indexOf("$", index + 1);
            if (index < 0 || lastIndex < 0) break;
            result.append(line.substring(prevIndex, index));
            result.append("$");
            result.append(keyword);
            result.append("$");
            index = lastIndex + 1;
        }
        result.append(line.substring(prevIndex));
        return result.toString();
    }

    public static String copy(File from, File to, String eol, MessageDigest digest) {
        return FSUtil.copy(from, to, eol, null, digest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String copy(File from, File to, String eol, Map keywords, MessageDigest digest) {
        IOException e1322;
        String e12222;
        OutputStream os;
        BufferedInputStream is;
        block21: {
            if (from != null && from.exists() && from.equals(to)) {
                return FSUtil.getChecksum(from, digest);
            }
            is = null;
            os = null;
            if (!from.exists()) {
                return null;
            }
            if (!to.exists()) {
                to.getParentFile().mkdirs();
                try {
                    to.createNewFile();
                }
                catch (IOException e12222) {
                    return null;
                }
            }
            FSUtil.setReadonly(to, false);
            is = new BufferedInputStream(new FileInputStream(from));
            os = new BufferedOutputStream(new FileOutputStream(to));
            e12222 = FSUtil.copy(is, os, eol, keywords, digest);
            Object var9_10 = null;
            if (os == null) break block21;
            try {
                os.close();
            }
            catch (IOException e1322) {
                // empty catch block
            }
        }
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e1322) {
                // empty catch block
            }
        }
        return e12222;
        catch (IOException e) {
            IOException e1322;
            block23: {
                try {
                    e.printStackTrace();
                    Object var9_11 = null;
                    if (os == null) break block23;
                }
                catch (Throwable throwable) {
                    IOException e1322;
                    Object var9_12 = null;
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e1322) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException e1322) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    os.close();
                }
                catch (IOException e1322) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e1322) {}
            }
        }
        return null;
    }

    public static void sleepForTimestamp() {
        long time = System.currentTimeMillis();
        time = 1010L - (time - time / 1000L * 1000L);
        DebugLog.benchmark("WATING FOR: " + time + " ms.");
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getChecksum(File file, MessageDigest digest) {
        String string;
        if (digest == null) return null;
        if (!file.isFile()) {
            return null;
        }
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                string = FSUtil.copy(is, NULL_OUTPUT, digest);
                Object var6_5 = null;
                if (is == null) return string;
            }
            catch (IOException e) {
                String string2 = null;
                Object var6_6 = null;
                if (is == null) return string2;
                try {
                    ((InputStream)is).close();
                    return string2;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (is == null) throw throwable;
            try {}
            catch (IOException e2) {
                throw throwable;
            }
            ((InputStream)is).close();
            throw throwable;
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return string;
        }
        ((InputStream)is).close();
        return string;
    }

    static {
        NULL_OUTPUT = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        String osName = System.getProperty("os.name");
        isWindows = osName != null && osName.toLowerCase().indexOf("windows") >= 0;
        myLineBuffer = new ByteArrayOutputStream();
        myBinaryBuffer = new byte[32768];
        CR_BYTES = new byte[]{13};
        LF_BYTES = new byte[]{10};
        CRLF_BYTES = new byte[]{13, 10};
    }
}

