/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNRootEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSAdminArea;
import org.tmatesoft.svn.core.internal.ws.fs.FSDirEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSFileEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSMerger;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

public class FSRootEntry
extends FSDirEntry
implements ISVNRootEntry {
    private static final String DEFAULT_GLOBAL_IGNORE = "*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store";
    private Map myTempLocations;
    private String myID;
    private FSMerger myMerger;
    private String myGlobalIgnore;
    private boolean myIsUseCommitTimes;

    public FSRootEntry(FSAdminArea area, String id, String location) {
        super(area, null, "", location);
        this.setGlobalIgnore(DEFAULT_GLOBAL_IGNORE);
        this.myID = id = id.replace(File.separatorChar, '/');
    }

    public String getType() {
        return "file";
    }

    public String getID() {
        return this.myID;
    }

    public String getWorkspaceProperty(String path, String name) throws SVNException {
        if (path == null || name == null) {
            return null;
        }
        ISVNEntry entry = this.locateEntry(path);
        if (entry != null) {
            return entry.getPropertyValue(name);
        }
        return null;
    }

    public void setWorkspaceProperty(String path, String name, String value) throws SVNException {
        if (path == null || name == null) {
            return;
        }
        ISVNEntry entry = this.locateEntry(path);
        if (entry != null) {
            entry.setPropertyValue(name, value);
        } else {
            DebugLog.log("can't locate entry at: " + path);
        }
    }

    public void setGlobalIgnore(String ignore) {
        this.myGlobalIgnore = ignore;
    }

    public String getGlobalIgnore() {
        if (this.myGlobalIgnore == null) {
            return DEFAULT_GLOBAL_IGNORE;
        }
        return this.myGlobalIgnore;
    }

    public void setUseCommitTimes(boolean useCommitTimes) {
        this.myIsUseCommitTimes = useCommitTimes;
    }

    public boolean isUseCommitTimes() {
        return this.myIsUseCommitTimes;
    }

    public OutputStream createTemporaryLocation(String path, Object id) throws IOException {
        if (id == null) {
            throw new IOException("id could not be null");
        }
        if (this.myTempLocations == null) {
            this.myTempLocations = new HashMap();
        }
        if (path == null) {
            path = this.getPath();
        }
        String name = PathUtil.tail(path);
        path = PathUtil.removeTail(path);
        path = PathUtil.append(path, ".svn/tmp");
        File parent = new File(this.myID, path = PathUtil.removeLeadingSlash(path));
        if (!parent.exists()) {
            parent.mkdirs();
            FSUtil.setHidden(parent.getParentFile(), true);
        }
        File tempFile = File.createTempFile("svn." + name + ".", ".tmp", parent);
        tempFile.deleteOnExit();
        this.myTempLocations.put(id, tempFile);
        return new BufferedOutputStream(new FileOutputStream(tempFile));
    }

    public InputStream getTemporaryLocation(Object id) throws IOException {
        if (this.myTempLocations == null || id == null) {
            throw new IOException("no such location: " + id);
        }
        File file = (File)this.myTempLocations.get(id);
        if (file == null) {
            throw new IOException("no such location: " + id);
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    public void deleteAdminFiles(String path) {
        path = PathUtil.append(path, ".svn");
        File parent = new File(this.myID, path);
        FSUtil.deleteAll(parent);
        if (this.myTempLocations != null) {
            this.myTempLocations.clear();
        }
    }

    public long getLength(Object id) throws IOException {
        if (this.myTempLocations == null || id == null) {
            throw new IOException("no such location: " + id);
        }
        File file = (File)this.myTempLocations.get(id);
        if (file == null) {
            throw new IOException("no such location: " + id);
        }
        return file.length();
    }

    public void deleteTemporaryLocation(Object id) {
        if (this.myTempLocations == null || id == null) {
            return;
        }
        File file = (File)this.myTempLocations.remove(id);
        if (file != null) {
            file.delete();
        }
    }

    public File getWorkingCopyFile(ISVNEntry entry) {
        return new File(this.myID, entry.getPath());
    }

    public File createTemporaryFile(FSFileEntry source) throws SVNException {
        File parent = new File(source.getAdminArea().getAdminArea(source), "tmp");
        if (!parent.exists()) {
            parent.mkdirs();
            FSUtil.setHidden(parent.getParentFile(), true);
        }
        File file = null;
        try {
            file = File.createTempFile("svn." + source.getName() + ".", ".tmp", parent);
            file.deleteOnExit();
        }
        catch (IOException e) {
            DebugLog.error(e);
        }
        return file;
    }

    public boolean isObstructed() {
        return false;
    }

    public boolean revert(String childName) throws SVNException {
        if (childName != null) {
            return super.revert(childName);
        }
        this.revertProperties();
        return true;
    }

    public FSMerger getMerger() {
        if (this.myMerger == null) {
            this.myMerger = new FSMerger();
        }
        return this.myMerger;
    }

    protected FSRootEntry getRootEntry() {
        return this;
    }

    protected ISVNEntry locateEntry(String path) throws SVNException {
        if (path == null) {
            return null;
        }
        ISVNEntry entry = this;
        StringTokenizer tokens = new StringTokenizer(path, "/");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!entry.isDirectory()) {
                return null;
            }
            entry = entry.asDirectory().getUnmanagedChild(token);
            if (entry != null) continue;
            return null;
        }
        return entry;
    }
}

