/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSMergerBySequence;
import org.tmatesoft.svn.core.io.SVNException;

public class FSMerger {
    private static final String EOL = System.getProperty("line.separator");

    public boolean isApplicable(ISVNEntry entry) {
        return entry instanceof FSEntry;
    }

    public int pretendMergeFiles(File base, File local, File latest) throws SVNException {
        if (base == null || local == null || latest == null) {
            throw new SVNException("At least one file is missing, can't merge");
        }
        return this.doMergeFiles(base, local, latest, null, "", "");
    }

    public int mergeFiles(File base, File local, File latest, File result, String start, String end) throws SVNException {
        if (base == null || local == null || latest == null) {
            throw new SVNException("At least one file is missing, can't merge");
        }
        return this.doMergeFiles(base, local, latest, result, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMergeFiles(File base, File local, File latest, File result, String start, String end) throws SVNException {
        int n;
        String conflictStart = "<<<<<<< " + start;
        String conflictEnd = ">>>>>>> " + end;
        String conflictSeparator = "=======";
        FSMergerBySequence merger = new FSMergerBySequence(conflictStart.getBytes(), "=======".getBytes(), conflictEnd.getBytes(), EOL.getBytes());
        OutputStream resultStream = result != null ? new FileOutputStream(result) : new ByteArrayOutputStream();
        try {
            n = merger.merge(new FileInputStream(base), new FileInputStream(local), new FileInputStream(latest), resultStream);
        }
        catch (Throwable throwable) {
            try {
                resultStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new SVNException(ex);
            }
        }
        resultStream.close();
        return n;
    }
}

