/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.util.PathUtil;

public class FSEntryHandler {
    public static void save(Writer os, Map entry, Collection childEntries, Collection deletedEntries) throws IOException {
        os.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        os.write("<wc-entries\n");
        os.write("   xmlns=\"svn:\">\n");
        FSEntryHandler.saveEntry(os, null, entry);
        Iterator entries = childEntries.iterator();
        while (entries.hasNext()) {
            FSEntryHandler.saveEntry(os, entry, (Map)entries.next());
        }
        entries = deletedEntries.iterator();
        while (entries.hasNext()) {
            FSEntryHandler.saveEntry(os, entry, (Map)entries.next());
        }
        os.write("</wc-entries>\n");
    }

    public static Map parse(BufferedReader reader) throws IOException {
        String line;
        HashMap<String, String> attrs = null;
        HashMap childEntries = new HashMap();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("<entry")) {
                attrs = new HashMap<String, String>();
                continue;
            }
            if (attrs == null) continue;
            String name = line.substring(0, line.indexOf(61));
            String value = line.substring(line.indexOf(34) + 1, line.lastIndexOf(34));
            value = FSEntryHandler.xmlDecode(value);
            attrs.put("svn:entry:" + name, value);
            if (!line.endsWith("/>")) continue;
            childEntries.put(attrs.get("svn:entry:name"), attrs);
            attrs = null;
        }
        return childEntries;
    }

    private static void saveEntry(Writer os, Map parent, Map entry) throws IOException {
        os.write("<entry\n");
        boolean first = true;
        Iterator entries = entry.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry e = entries.next();
            if (e.getValue() == null) continue;
            if (parent != null) {
                if ("svn:entry:revision".equals(e.getKey()) && e.getValue().equals(parent.get("svn:entry:revision")) || "svn:entry:copyfrom-rev".equals(e.getKey()) && e.getValue().equals(parent.get("svn:entry:copyfrom-rev")) || ("svn:entry:revision".equals(e.getKey()) || "svn:entry:url".equals(e.getKey())) && "dir".equals(entry.get("svn:entry:kind")) || "svn:entry:uuid".equals(e.getKey()) && e.getValue().equals(parent.get("svn:entry:uuid"))) continue;
                if ("svn:entry:url".equals(e.getKey()) || "svn:entry:copyfrom-url".equals(e.getKey())) {
                    String name = (String)entry.get("svn:entry:name");
                    name = FSEntryHandler.xmlDecode(name);
                    String url = (String)parent.get(e.getKey());
                    String expected = PathUtil.append(url, PathUtil.encode(name));
                    if (e.getValue().equals(expected)) continue;
                }
            }
            if (!first) {
                os.write(10);
            }
            first = false;
            os.write("   ");
            os.write(e.getKey().toString().substring("svn:entry:".length()));
            os.write("=\"");
            String value = e.getValue().toString();
            if ("svn:entry:url".equals(e.getKey()) || "svn:entry:copyfrom-url".equals(e.getKey())) {
                value = PathUtil.removeTrailingSlash(value);
            }
            value = FSEntryHandler.xmlEncode(value);
            os.write(value);
            os.write("\"");
        }
        os.write("/>\n");
    }

    private static String xmlEncode(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&apos;");
        value = value.replaceAll("\t", "&#09;");
        return value;
    }

    private static String xmlDecode(String value) {
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&#09;", "\t");
        value = value.replaceAll("&amp;", "&");
        return value;
    }
}

