/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.ws.fs;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.ISVNDirectoryContent;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNEntryContent;
import org.tmatesoft.svn.core.ISVNFileContent;
import org.tmatesoft.svn.core.internal.ws.fs.FSDirEntry;
import org.tmatesoft.svn.core.internal.ws.fs.FSUtil;
import org.tmatesoft.svn.core.io.SVNException;

public class FSDirEntryContent
implements ISVNDirectoryContent {
    private final FSDirEntry myEntry;

    public FSDirEntryContent(FSDirEntry entry) {
        this.myEntry = entry;
    }

    public String getName() {
        return this.myEntry.getName();
    }

    public String getPath() {
        return this.myEntry.getPath();
    }

    public boolean isDirectory() {
        return true;
    }

    public ISVNDirectoryContent asDirectory() {
        return this;
    }

    public ISVNFileContent asFile() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildContents() throws SVNException {
        try {
            ISVNEntry entry;
            ArrayList<ISVNEntryContent> contents = new ArrayList<ISVNEntryContent>();
            Iterator it = this.myEntry.childEntries();
            while (it.hasNext()) {
                entry = (ISVNEntry)it.next();
                contents.add(entry.getContent());
            }
            it = this.myEntry.unmanagedChildEntries(true);
            while (it.hasNext()) {
                entry = (ISVNEntry)it.next();
                contents.add(entry.getContent());
            }
            ArrayList<ISVNEntryContent> arrayList = contents;
            return arrayList;
        }
        finally {
            this.myEntry.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkingCopyContent() throws SVNException {
        try {
            File file = this.myEntry.getRootEntry().getWorkingCopyFile(this.myEntry);
            if (this.myEntry.isManaged()) {
                throw new SVNException("Can't delete managed/non-empty directory '" + file + "'.");
            }
            FSUtil.deleteAll(file);
        }
        finally {
            this.myEntry.dispose();
        }
    }
}

