/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.tmatesoft.svn.core.internal.io.svn.SVNDataSource;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.TimeUtil;

public class SVNWriter {
    private SVNWriter() {
    }

    public static void write(OutputStream os, String templateStr, Object[] src) throws SVNException {
        StringBuffer template = new StringBuffer(templateStr.length());
        for (int i = 0; i < templateStr.length(); ++i) {
            char ch = templateStr.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            template.append(ch);
        }
        int offset = 0;
        try {
            for (int i = 0; i < template.length(); ++i) {
                Object item;
                char ch = template.charAt(i);
                if (ch == '(' || ch == ')') {
                    os.write((byte)ch);
                    os.write(32);
                    continue;
                }
                if ((item = src[offset++]) == null) continue;
                if (item instanceof Date) {
                    item = TimeUtil.formatDate((Date)item);
                }
                if (ch == 'i') {
                    int read;
                    InputStream is = ((SVNDataSource)item).getInputStream();
                    long length = ((SVNDataSource)item).lenght();
                    os.write(Long.toString(length).getBytes("UTF-8"));
                    os.write(58);
                    byte[] buffer = new byte[Math.min(2048, (int)length)];
                    while ((read = is.read(buffer)) > 0) {
                        os.write(buffer, 0, read);
                    }
                }
                if (ch == 'b') {
                    byte[] bytes = (byte[])item;
                    os.write(Integer.toString(bytes.length).getBytes("UTF-8"));
                    os.write(58);
                    os.write(bytes);
                } else if (ch == 'n') {
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == 'w') {
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == 's') {
                    os.write(Integer.toString(item.toString().getBytes("UTF-8").length).getBytes("UTF-8"));
                    os.write(58);
                    os.write(item.toString().getBytes("UTF-8"));
                } else if (ch == '*') {
                    Object[] list;
                    ch = template.charAt(i + 1);
                    if (item instanceof Object[]) {
                        list = (Object[])item;
                        for (int j = 0; j < list.length; ++j) {
                            if (ch == 's') {
                                os.write(Integer.toString(list[j].toString().getBytes("UTF-8").length).getBytes("UTF-8"));
                                os.write(58);
                                os.write(list[j].toString().getBytes("UTF-8"));
                            } else if (ch == 'w') {
                                os.write(list[j].toString().getBytes("UTF-8"));
                            }
                            os.write(32);
                        }
                    } else if (item instanceof long[] && ch == 'n') {
                        list = (long[])item;
                        for (int j = 0; j < list.length; ++j) {
                            os.write(Long.toString((long)list[j]).getBytes("UTF-8"));
                            os.write(32);
                        }
                    }
                    ++i;
                }
                os.write(32);
            }
        }
        catch (IOException e) {
            DebugLog.error(e);
            throw new SVNException("error while sending data", e);
        }
    }
}

