/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.svn.RollbackInputStream;
import org.tmatesoft.svn.core.internal.io.svn.SVNEditModeReader;
import org.tmatesoft.svn.core.io.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNDirEntry;
import org.tmatesoft.svn.core.io.SVNError;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.LoggingInputStream;
import org.tmatesoft.svn.util.TimeUtil;

class SVNReader {
    private static final char[] VALID_TEMPLATE_CHARS = new char[]{'(', ')', '[', ']', 's', 'w', 'b', 'i', 'n', 't', 'p', 'd', 'f', 'l', 'a', 'r', 'e', 'x', '?', '*', 'z'};
    private static final char[] INVALID_CARDINALITY_SUBJECTS = new char[]{'(', ')', '[', ']', '?', '*', '<'};

    SVNReader() {
    }

    public static Date getDate(Object[] items, int index) {
        String str = SVNReader.getString(items, index);
        return TimeUtil.parseDate(str);
    }

    public static long getLong(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return -1L;
        }
        if (items[index] instanceof Long) {
            return (Long)items[index];
        }
        if (items[index] instanceof Integer) {
            System.err.println("fetching integer when should be long");
            new Exception().printStackTrace();
            return ((Integer)items[index]).intValue();
        }
        return -1L;
    }

    public static boolean getBoolean(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return false;
        }
        if (items[index] instanceof Boolean) {
            return (Boolean)items[index];
        }
        if (items[index] instanceof String) {
            return Boolean.valueOf((String)items[index]);
        }
        return false;
    }

    public static Map getMap(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return Collections.EMPTY_MAP;
        }
        if (items[index] instanceof Map) {
            return (Map)items[index];
        }
        return Collections.EMPTY_MAP;
    }

    public static List getList(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return Collections.EMPTY_LIST;
        }
        if (items[index] instanceof List) {
            return (List)items[index];
        }
        return Collections.EMPTY_LIST;
    }

    public static String getString(Object[] items, int index) {
        if (items == null || index >= items.length) {
            return null;
        }
        if (items[index] instanceof byte[]) {
            try {
                return new String((byte[])items[index], "UTF-8");
            }
            catch (IOException e) {
                return null;
            }
        }
        if (items[index] instanceof String) {
            return (String)items[index];
        }
        return null;
    }

    public static boolean hasValue(Object[] items, int index, boolean value) {
        return SVNReader.hasValue(items, index, (Object)value);
    }

    public static boolean hasValue(Object[] items, int index, int value) {
        return SVNReader.hasValue(items, index, new Long(value));
    }

    public static boolean hasValue(Object[] items, int index, Object value) {
        if (items == null || index >= items.length) {
            return false;
        }
        if (items[index] instanceof List) {
            Iterator iter = ((List)items[index]).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!element.equals(value)) continue;
                return true;
            }
        } else {
            if (items[index] == null) {
                return value == null;
            }
            if (items[index] instanceof byte[] && value instanceof String) {
                try {
                    items[index] = new String((byte[])items[index], "UTF-8");
                }
                catch (IOException e) {
                    return false;
                }
            }
            return items[index].equals(value);
        }
        return false;
    }

    public static Object[] parse(LoggingInputStream is, String templateStr, Object[] target) throws SVNException {
        if (!is.markSupported()) {
            throw new SVNException("SVNReader works only with markable input streams");
        }
        if (target != null) {
            for (int i = 0; i < target.length; ++i) {
                if (target[i] instanceof Collection || target[i] instanceof Map || target[i] instanceof ISVNDirEntryHandler || target[i] instanceof ISVNEditor || target[i] instanceof OutputStream) continue;
                target[i] = null;
            }
        }
        StringBuffer template = SVNReader.normalizeTemplate(templateStr);
        SVNEditModeReader editorBaton = null;
        int targetIndex = 0;
        for (int i = 0; i < template.length(); ++i) {
            char ch = template.charAt(i);
            boolean optional = ch == '?' || ch == '*';
            boolean multiple = ch == '*';
            boolean doRead = Character.isUpperCase(ch) && !SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, ch);
            ch = Character.toLowerCase(ch);
            if (optional) {
                char next = i + 1 < template.length() ? template.charAt(i + 1) : (char)'<';
                doRead = Character.isUpperCase(next) && !SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, next);
                if (SVNReader.isListed(INVALID_CARDINALITY_SUBJECTS, next = Character.toLowerCase(next))) {
                    throw new SVNException("malformed template '" + templateStr + "' invalid type after cardinality: " + next);
                }
                ++i;
                ch = next;
            }
            is.mark(512);
            Object result = null;
            try {
                String word;
                RollbackInputStream is2;
                String name;
                if (ch == 'b' || ch == 'i' || ch == 's') {
                    result = ch == 'b' ? SVNReader.readStringAsBytes(is) : (ch == 's' ? (Object)SVNReader.readString(is) : (Object)SVNReader.createDelegatingStream(is));
                } else if (ch == 'p') {
                    SVNReader.readChar(is, '(');
                    name = SVNReader.readString(is);
                    String value = null;
                    is2 = new RollbackInputStream(is);
                    ((InputStream)is2).mark(256);
                    try {
                        value = SVNReader.readString(is2);
                    }
                    catch (SVNException exception) {
                        try {
                            value = null;
                            ((InputStream)is2).reset();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    SVNReader.readChar(is, ')');
                    result = new String[]{name, value};
                } else if (ch == 'z') {
                    SVNReader.readChar(is, '(');
                    name = SVNReader.readString(is);
                    String value = null;
                    SVNReader.readChar(is, '(');
                    is2 = new RollbackInputStream(is);
                    ((InputStream)is2).mark(256);
                    try {
                        value = SVNReader.readString(is2);
                    }
                    catch (SVNException exception) {
                        try {
                            value = null;
                            ((InputStream)is2).reset();
                        }
                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                    SVNReader.readChar(is, ')');
                    SVNReader.readChar(is, ')');
                    result = new String[]{name, value};
                } else if (ch == 'w') {
                    word = SVNReader.readWord(is);
                    result = word;
                } else if (ch == 't') {
                    result = SVNReader.readBoolean(is);
                } else if (ch == 'n') {
                    result = new Long(SVNReader.readNumber(is));
                } else if (ch == '[') {
                    SVNReader.readChar(is, '(');
                    word = SVNReader.readWord(is);
                    if ("failure".equals(word)) {
                        SVNReader.readChar(is, '(');
                        ArrayList<SVNError> errors = new ArrayList<SVNError>();
                        is2 = new RollbackInputStream(is);
                        try {
                            while (true) {
                                is2.mark(5);
                                errors.add(SVNReader.readError(is2));
                            }
                        }
                        catch (SVNException e) {
                            try {
                                is2.reset();
                                SVNReader.readChar(is2, ')');
                                SVNReader.readChar(is2, ')');
                            }
                            catch (IOException e1) {
                            }
                            catch (SVNException e2) {
                                // empty catch block
                            }
                            throw new SVNException("svnserve reported an error", errors.toArray(new SVNError[errors.size()]));
                        }
                    }
                    if (!"success".equals(word)) {
                        throw new SVNException("network data doesn't match template, 'success' or 'failure' expected, '" + word + "' read");
                    }
                } else if (ch == ')' || ch == ']') {
                    SVNReader.readChar(is, ')');
                } else if (ch == '(') {
                    SVNReader.readChar(is, '(');
                } else if (ch == 'd') {
                    result = SVNReader.readDirEntry(DebugLog.getLoggingInputStream("svn", new RollbackInputStream(is)));
                } else if (ch == 'e') {
                    boolean hasMore;
                    if (editorBaton == null) {
                        editorBaton = new SVNEditModeReader();
                        if (target[targetIndex] instanceof ISVNEditor) {
                            editorBaton.setEditor((ISVNEditor)target[targetIndex]);
                        }
                    }
                    SVNReader.readChar(is, '(');
                    String commandName = SVNReader.readWord(is);
                    try {
                        hasMore = editorBaton.processCommand(commandName, is);
                    }
                    catch (Throwable th) {
                        DebugLog.error(th);
                        if (th instanceof SVNException) {
                            throw (SVNException)th;
                        }
                        throw new SVNException(th);
                    }
                    if (!"textdelta-chunk".equals(commandName)) {
                        SVNReader.readChar(is, ')');
                    }
                    if (!hasMore) {
                        return target;
                    }
                } else if (ch == 'x' && !"done".equals(word = SVNReader.readWord(is))) {
                    throw new SVNException("netword data doesn't match template, 'done' was expected, but '" + word + "' read.");
                }
                if (doRead) {
                    target = SVNReader.reportResult(target, targetIndex, result, multiple);
                }
                if (multiple) {
                    i -= 2;
                    continue;
                }
                if (!doRead) continue;
                ++targetIndex;
                continue;
            }
            catch (SVNException e) {
                try {
                    is.reset();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                if (optional) {
                    if (!doRead) continue;
                    ++targetIndex;
                    continue;
                }
                throw e;
            }
        }
        if (target == null) {
            target = new Object[]{};
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] reportResult(Object[] target, int index, Object result, boolean multiple) {
        if (target == null) {
            target = new Object[index + 1];
        } else if (index >= target.length) {
            Object[] array = new Object[index + 1];
            System.arraycopy(target, 0, array, 0, target.length);
            target = array;
        }
        if (target[index] instanceof ISVNDirEntryHandler) {
            ISVNDirEntryHandler handler = (ISVNDirEntryHandler)target[index];
            if (result instanceof SVNDirEntry) {
                handler.handleDirEntry((SVNDirEntry)result);
            }
        } else if (target[index] == null) {
            target[index] = result instanceof String[] ? new HashMap() : (multiple ? new LinkedList() : result);
        } else if (target[index] instanceof OutputStream && result instanceof InputStream) {
            InputStream in = (InputStream)result;
            OutputStream out = (OutputStream)target[index];
            try {
                int read;
                while ((read = in.read()) >= 0) {
                    out.write(read);
                }
                out.flush();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    while (in.read() >= 0) {
                    }
                }
                catch (IOException e1) {}
            }
        }
        if (target[index] instanceof List) {
            ((List)target[index]).add(result);
        } else if (target[index] instanceof Map && result instanceof String[]) {
            String[] property = (String[])result;
            ((Map)target[index]).put(property[0], property[1]);
        }
        return target;
    }

    private static StringBuffer normalizeTemplate(String template) throws SVNException {
        StringBuffer sb = new StringBuffer(template.length());
        for (int i = 0; i < template.length(); ++i) {
            char ch = template.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            char tch = Character.toLowerCase(ch);
            if (SVNReader.isListed(VALID_TEMPLATE_CHARS, tch)) {
                sb.append(ch);
                continue;
            }
            throw new SVNException("malformed template' " + template + "' invalid char: " + ch);
        }
        return sb;
    }

    private static boolean isListed(char[] chars, char test) {
        for (int i = 0; i < chars.length; ++i) {
            if (test != chars[i]) continue;
            return true;
        }
        return false;
    }

    private static char skipWhitespace(InputStream is) throws SVNException {
        try {
            char read;
            while (Character.isWhitespace(read = (char)is.read())) {
            }
            return read;
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    private static byte[] readStringAsBytes(InputStream is) throws SVNException {
        int length = SVNReader.readStringLength(is);
        return SVNReader.readBytes(is, length, null);
    }

    private static String readString(InputStream is) throws SVNException {
        int length = SVNReader.readStringLength(is);
        try {
            return new String(SVNReader.readBytes(is, length, null), 0, length, "UTF-8");
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    private static int readStringLength(InputStream is) throws SVNException {
        char ch = SVNReader.skipWhitespace(is);
        int length = 0;
        while (Character.isDigit(ch)) {
            length *= 10;
            length += ch - 48;
            try {
                ch = (char)is.read();
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
        }
        if (ch == ':') {
            return length;
        }
        throw new SVNException("network data doesn't match template, can't read string length.");
    }

    private static int readNumber(InputStream is) throws SVNException {
        char ch = SVNReader.skipWhitespace(is);
        int length = 0;
        while (Character.isDigit(ch)) {
            length *= 10;
            length += ch - 48;
            try {
                ch = (char)is.read();
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
        }
        if (Character.isWhitespace(ch)) {
            return length;
        }
        throw new SVNException("network data doesn't match template, can't read number.");
    }

    private static String readWord(InputStream is) throws SVNException {
        char ch = SVNReader.skipWhitespace(is);
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        try {
            while (!Character.isWhitespace(ch)) {
                if (count == 0 && !Character.isLetter(ch)) {
                    throw new SVNException("network data doesn't match template, invalid word start: " + ch);
                }
                if (count > 0 && !Character.isLetterOrDigit(ch) && ch != '-') {
                    throw new SVNException("network data doesn't match template, invalid word symbol: " + ch);
                }
                buffer.append(ch);
                ++count;
                ch = (char)is.read();
            }
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        return buffer.toString();
    }

    private static boolean readBoolean(InputStream is) throws SVNException {
        String word = SVNReader.readWord(is);
        if ("true".equalsIgnoreCase(word)) {
            return true;
        }
        if ("false".equalsIgnoreCase(word)) {
            return false;
        }
        throw new SVNException("network data doesn't match template, can't read boolean.");
    }

    private static void readChar(InputStream is, char test) throws SVNException {
        char ch = SVNReader.skipWhitespace(is);
        if (ch != test) {
            if (ch < '\u0000') {
                throw new SVNException("no more data to read");
            }
            throw new SVNException("network data doesn't match template, expected " + test + ", read " + ch + " (" + ch + ")");
        }
    }

    private static byte[] readBytes(InputStream is, int length, byte[] buffer) throws SVNException {
        if (buffer == null || buffer.length < length) {
            buffer = new byte[length];
        }
        try {
            is.read(buffer, 0, length);
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        return buffer;
    }

    private static InputStream createDelegatingStream(final InputStream source) throws SVNException {
        int length = SVNReader.readStringLength(source);
        final int[] counter = new int[]{length};
        return new InputStream(){

            public int read() throws IOException {
                if (counter[0] > 0) {
                    counter[0] = counter[0] - 1;
                    return source.read();
                }
                return -1;
            }
        };
    }

    private static SVNError readError(InputStream is) throws SVNException {
        RollbackInputStream pis = new RollbackInputStream(is);
        SVNReader.readChar(pis, '(');
        int errorCode = -1;
        try {
            ((InputStream)pis).mark(32);
            errorCode = SVNReader.readNumber(pis);
        }
        catch (SVNException e) {
            try {
                ((InputStream)pis).reset();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        String errorMessage = SVNReader.readString(pis);
        int lineNumber = -1;
        String location = null;
        try {
            ((InputStream)pis).mark(256);
            location = SVNReader.readString(pis);
            lineNumber = SVNReader.readNumber(pis);
        }
        catch (SVNException e) {
            try {
                ((InputStream)pis).reset();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        SVNReader.readChar(pis, ')');
        return new SVNError(errorMessage, location, errorCode, lineNumber);
    }

    private static SVNDirEntry readDirEntry(LoggingInputStream is) throws SVNException {
        Object[] items = SVNReader.parse(is, "(SWNTN(?S)(?S))", null);
        is.log();
        String name = SVNReader.getString(items, 0);
        SVNNodeKind kind = SVNNodeKind.parseKind(SVNReader.getString(items, 1));
        long size = SVNReader.getLong(items, 2);
        boolean hasProps = SVNReader.getBoolean(items, 3);
        long revision = SVNReader.getLong(items, 4);
        Date date = TimeUtil.parseDate(SVNReader.getString(items, 5));
        String author = SVNReader.getString(items, 6);
        return new SVNDirEntry(name, kind, size, hasProps, revision, date, author);
    }
}

