/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNJSchSession;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.io.ISVNCredentials;
import org.tmatesoft.svn.core.io.ISVNCredentialsProvider;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.SVNUtil;

public class SVNJSchConnector
implements ISVNConnector {
    private static final String CHANNEL_TYPE = "exec";
    private static final String SVNSERVE_COMMAND = "svnserve --tunnel";
    private ChannelExec myChannel;
    private InputStream myInputStream;
    private OutputStream myOutputStream;

    public void open(SVNRepositoryImpl repository) throws SVNException {
        ISVNCredentialsProvider provider = repository.getCredentialsProvider();
        if (provider == null) {
            throw new SVNException("Credentials provider is required for SSH connection");
        }
        provider.reset();
        ISVNCredentials credentials = SVNUtil.nextCredentials(provider, repository.getLocation(), null);
        SVNAuthenticationException lastException = null;
        Session session = null;
        while (credentials != null) {
            try {
                session = SVNJSchSession.getSession(repository.getLocation(), credentials);
                if (session != null && !session.isConnected()) {
                    session = null;
                    continue;
                }
                provider.accepted(credentials);
                lastException = null;
                break;
            }
            catch (SVNAuthenticationException e) {
                if (session != null && session.isConnected()) {
                    DebugLog.log("DISCONNECTING: " + session);
                    session.disconnect();
                    session = null;
                }
                lastException = e;
                credentials = SVNUtil.nextCredentials(provider, repository.getLocation(), e.getMessage());
            }
        }
        if (lastException != null || session == null) {
            if (lastException != null) {
                throw lastException;
            }
            throw new SVNAuthenticationException("Can't establish SSH connection without credentials");
        }
        repository.setCredentials(credentials);
        try {
            int retry = 1;
            while (true) {
                this.myChannel = (ChannelExec)session.openChannel(CHANNEL_TYPE);
                String command = SVNSERVE_COMMAND;
                this.myChannel.setCommand(command);
                this.myOutputStream = this.myChannel.getOutputStream();
                this.myInputStream = this.myChannel.getInputStream();
                DebugLog.log("JSCH command: " + command);
                try {
                    this.myChannel.connect();
                }
                catch (JSchException e) {
                    if (--retry < 0) {
                        throw new SVNException(e);
                    }
                    if (!session.isConnected()) continue;
                    session.disconnect();
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            this.close();
            if (session.isConnected()) {
                session.disconnect();
            }
            throw new SVNException(e);
        }
        this.myInputStream = new FilterInputStream(this.myInputStream){

            public void close() throws IOException {
            }
        };
        this.myOutputStream = new FilterOutputStream(this.myOutputStream){

            public void close() throws IOException {
            }
        };
    }

    public void close() throws SVNException {
        if (this.myChannel != null) {
            this.myChannel.disconnect();
        }
        this.myChannel = null;
        this.myOutputStream = null;
        this.myInputStream = null;
    }

    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }
}

