/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.LoggingInputStream;

public class SVNEditModeReader {
    private static final Map COMMANDS_MAP = new HashMap();
    private ISVNEditor myEditor;
    private SVNDiffWindowBuilder myBuilder;
    private OutputStream myDiffStream;
    private long myLenght;

    public void setEditor(ISVNEditor editor) {
        this.myEditor = editor;
        this.myBuilder = SVNDiffWindowBuilder.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processCommand(String commandName, LoggingInputStream parameters) throws SVNException {
        String pattern = (String)COMMANDS_MAP.get(commandName);
        if (pattern == null) {
            throw new SVNException("unknown command name: " + commandName);
        }
        if ("textdelta-chunk".equals(commandName)) {
            if (this.myBuilder.getDiffWindow() == null) {
                Object[] items = null;
                try {
                    items = SVNReader.parse(parameters, "(SB))", null);
                }
                catch (Throwable th) {
                    DebugLog.error(th);
                }
                finally {
                    parameters.log();
                }
                byte[] bytes = (byte[])items[1];
                this.myBuilder.accept(bytes, 0);
                if (this.myBuilder.getDiffWindow() != null) {
                    this.myLenght = this.myBuilder.getDiffWindow().getNewDataLength();
                    this.myDiffStream = this.myEditor.textDeltaChunk(this.myBuilder.getDiffWindow());
                    if (this.myDiffStream == null) {
                        this.myDiffStream = new OutputStream(){

                            public void write(int b) {
                            }
                        };
                    }
                    if (this.myLenght == 0L) {
                        this.closeDiffStream();
                    }
                }
            } else if (this.myDiffStream != null) {
                if (this.myLenght > 0L) {
                    byte[] line = null;
                    line = (byte[])SVNReader.parse(parameters, "(sB))", null)[0];
                    this.myLenght -= (long)line.length;
                    try {
                        this.myDiffStream.write(line);
                    }
                    catch (IOException e) {
                        throw new SVNException(e);
                    }
                }
                if (this.myLenght == 0L) {
                    this.closeDiffStream();
                }
            }
            return true;
        }
        boolean last = "close-edit".equals(commandName) || "abort-edit".equals(commandName);
        Object[] items = SVNReader.parse(parameters, pattern, new Object[10]);
        if ("target-rev".equals(commandName)) {
            this.myEditor.targetRevision(SVNReader.getLong(items, 0));
        } else if ("open-root".equals(commandName)) {
            this.myEditor.openRoot(SVNReader.getLong(items, 0));
        } else if ("delete-entry".equals(commandName)) {
            this.myEditor.deleteEntry((String)items[0], SVNReader.getLong(items, 1));
        } else if ("add-dir".equals(commandName)) {
            this.myEditor.addDir((String)items[0], (String)items[3], SVNReader.getLong(items, 4));
        } else if ("open-dir".equals(commandName)) {
            this.myEditor.openDir((String)items[0], SVNReader.getLong(items, 3));
        } else if ("change-dir-prop".equals(commandName)) {
            this.myEditor.changeDirProperty((String)items[1], (String)items[2]);
        } else if ("close-dir".equals(commandName)) {
            this.myEditor.closeDir();
        } else if ("add-file".equals(commandName)) {
            this.myEditor.addFile((String)items[0], (String)items[3], SVNReader.getLong(items, 4));
        } else if ("open-file".equals(commandName)) {
            this.myEditor.openFile((String)items[0], SVNReader.getLong(items, 3));
        } else if ("change-file-prop".equals(commandName)) {
            this.myEditor.changeFileProperty((String)items[1], (String)items[2]);
        } else if ("close-file".equals(commandName)) {
            this.myEditor.closeFile((String)items[1]);
        } else if ("apply-textdelta".equals(commandName)) {
            this.myBuilder.reset();
            this.myLenght = 0L;
            this.myDiffStream = null;
            this.myEditor.applyTextDelta((String)items[1]);
        } else if ("textdelta-end".equals(commandName)) {
            this.myEditor.textDeltaEnd();
        } else if ("close-edit".equals(commandName)) {
            this.myEditor.closeEdit();
        } else if ("abort-edit".equals(commandName)) {
            this.myEditor.abortEdit();
        }
        return !last;
    }

    private void closeDiffStream() throws SVNException {
        try {
            this.myDiffStream.close();
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
        this.myBuilder.reset(1);
        this.myDiffStream = null;
        this.myLenght = -1L;
    }

    static {
        COMMANDS_MAP.put("target-rev", "(N)");
        COMMANDS_MAP.put("open-root", "((?N)S)");
        COMMANDS_MAP.put("delete-entry", "(S(?N)S)");
        COMMANDS_MAP.put("add-dir", "(SSS(?S?N))");
        COMMANDS_MAP.put("open-dir", "(SSS(?N))");
        COMMANDS_MAP.put("change-dir-prop", "(SS(?S))");
        COMMANDS_MAP.put("close-dir", "(S)");
        COMMANDS_MAP.put("add-file", "(SSS(?S?N))");
        COMMANDS_MAP.put("open-file", "(SSS(?N))");
        COMMANDS_MAP.put("apply-textdelta", "(S(?S))");
        COMMANDS_MAP.put("textdelta-chunk", "(SS)");
        COMMANDS_MAP.put("textdelta-end", "(S)");
        COMMANDS_MAP.put("change-file-prop", "(SS(?S))");
        COMMANDS_MAP.put("close-file", "(S(?S))");
        COMMANDS_MAP.put("close-edit", "()");
        COMMANDS_MAP.put("abort-edit", "()");
    }
}

