/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.io.svn.SVNConnection;
import org.tmatesoft.svn.core.internal.io.svn.SVNDataSource;
import org.tmatesoft.svn.core.internal.io.svn.SVNReader;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

class SVNCommitEditor
implements ISVNEditor {
    private ISVNWorkspaceMediator myMediator;
    private SVNConnection myConnection;
    private SVNRepositoryImpl myRepository;
    private String myCurrentPath;
    private Runnable myCloseCallback;

    public SVNCommitEditor(SVNRepositoryImpl location, SVNConnection connection, ISVNWorkspaceMediator mediator, Runnable closeCallback) {
        this.myRepository = location;
        this.myConnection = connection;
        this.myMediator = mediator;
        this.myCloseCallback = closeCallback;
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentPath = "/";
        this.myConnection.write("(w((n)s))", new Object[]{"open-root", SVNCommitEditor.getRevisionObject(revision), "/"});
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.myConnection.write("(w(s(n)s))", new Object[]{"delete-entry", path, SVNCommitEditor.getRevisionObject(revision), this.myCurrentPath});
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        if (copyFromPath != null) {
            SVNRepositoryLocation location = this.myRepository.getLocation();
            String host = this.myRepository.getFullRoot();
            if (host == null) {
                host = location.getProtocol() + "://" + location.getHost() + ":" + location.getPort();
                host = PathUtil.append(host, this.myRepository.getRepositoryRoot());
            }
            copyFromPath = PathUtil.append(host, this.myRepository.getRepositoryPath(copyFromPath));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-dir", path, this.myCurrentPath, path, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-dir", path, this.myCurrentPath, path});
        }
        this.myCurrentPath = path;
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentPath = path;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-dir", path, SVNCommitEditor.computeParentPath(path), path, SVNCommitEditor.getRevisionObject(revision)});
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-dir-prop", this.myCurrentPath, name, value});
    }

    public void closeDir() throws SVNException {
        this.myConnection.write("(w(s))", new Object[]{"close-dir", this.myCurrentPath});
        this.myCurrentPath = SVNCommitEditor.computeParentPath(this.myCurrentPath);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        if (copyFromPath != null) {
            SVNRepositoryLocation location = this.myRepository.getLocation();
            String host = this.myRepository.getFullRoot();
            if (host == null) {
                host = location.getProtocol() + "://" + location.getHost() + ":" + location.getPort();
                host = PathUtil.append(host, this.myRepository.getRepositoryRoot());
            }
            copyFromPath = PathUtil.append(host, this.myRepository.getRepositoryPath(copyFromPath));
            this.myConnection.write("(w(sss(sn)))", new Object[]{"add-file", path, this.myCurrentPath, path, copyFromPath, SVNCommitEditor.getRevisionObject(copyFromRevision)});
        } else {
            this.myConnection.write("(w(sss()))", new Object[]{"add-file", path, this.myCurrentPath, path});
        }
        this.myCurrentPath = path;
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentPath = path;
        this.myConnection.write("(w(sss(n)))", new Object[]{"open-file", path, SVNCommitEditor.computeParentPath(path), path, SVNCommitEditor.getRevisionObject(revision)});
    }

    public void applyTextDelta(String baseChecksum) throws SVNException {
        this.myConnection.write("(w(s(s)))", new Object[]{"apply-textdelta", this.myCurrentPath, baseChecksum});
    }

    public OutputStream textDeltaChunk(SVNDiffWindow diffWindow) throws SVNException {
        this.myConnection.write("(w(s", new Object[]{"textdelta-chunk", this.myCurrentPath});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            SVNDiffWindowBuilder.save(diffWindow, bos);
            this.myConnection.write("b))", new Object[]{bos.toByteArray()});
            DebugLog.log(this.myCurrentPath + " window sent: " + bos.size());
            OutputStream os = this.myMediator.createTemporaryLocation(this.myCurrentPath, this.myCurrentPath);
            return os;
        }
        catch (IOException e) {
            throw new SVNException(e);
        }
    }

    public void textDeltaEnd() throws SVNException {
        try {
            DebugLog.log("closing delta for " + this.myCurrentPath);
            long length = this.myMediator.getLength(this.myCurrentPath);
            if (this.myMediator.getLength(this.myCurrentPath) > 0L) {
                InputStream is = this.myMediator.getTemporaryLocation(this.myCurrentPath);
                SVNDataSource source = new SVNDataSource(is, length);
                this.myConnection.write("(w(si))", new Object[]{"textdelta-chunk", this.myCurrentPath, source});
                is.close();
            }
            DebugLog.log("new data sent" + length);
        }
        catch (IOException e) {
            throw new SVNException();
        }
        finally {
            this.myMediator.deleteTemporaryLocation(this.myCurrentPath);
        }
        this.myConnection.write("(w(s))", new Object[]{"textdelta-end", this.myCurrentPath});
    }

    public void changeFileProperty(String name, String value) throws SVNException {
        this.myConnection.write("(w(ss(s)))", new Object[]{"change-file-prop", this.myCurrentPath, name, value});
    }

    public void closeFile(String textChecksum) throws SVNException {
        this.myConnection.write("(w(s(s)))", new Object[]{"close-file", this.myCurrentPath, textChecksum});
        this.myCurrentPath = SVNCommitEditor.computeParentPath(this.myCurrentPath);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        this.myConnection.write("(w())", new Object[]{"close-edit"});
        this.myConnection.read("[()]", null);
        this.myRepository.authenticate();
        Object[] items = this.myConnection.read("(N(?S)(?S))", new Object[3]);
        long revision = SVNReader.getLong(items, 0);
        Date date = SVNReader.getDate(items, 1);
        this.myCloseCallback.run();
        return new SVNCommitInfo(revision, (String)items[2], date);
    }

    public void abortEdit() throws SVNException {
        this.myConnection.write("(w())", new Object[]{"abort-edit"});
        this.myCloseCallback.run();
    }

    private static String computeParentPath(String path) {
        return PathUtil.removeTail(path);
    }

    private static Long getRevisionObject(long rev) {
        return rev >= 0L ? new Long(rev) : null;
    }
}

