/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVResponse;
import org.tmatesoft.svn.core.internal.io.dav.DAVStatus;
import org.tmatesoft.svn.core.internal.io.dav.IDAVResponseHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.xml.sax.Attributes;

public class DAVPropertiesHandler
extends BasicDAVHandler {
    private DAVResponse myResponse;
    private IDAVResponseHandler myResponseHandler;

    public static StringBuffer generatePropertiesRequest(StringBuffer body, DAVElement[] properties) {
        body = body == null ? new StringBuffer() : body;
        body.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><propfind xmlns=\"DAV:\">");
        if (properties != null) {
            body.append("<prop>");
            for (int i = 0; i < properties.length; ++i) {
                body.append("<");
                body.append(properties[i].getName());
                body.append(" xmlns=\"");
                body.append(properties[i].getNamespace());
                body.append("\"/>");
            }
            body.append("</prop></propfind>");
        } else {
            body.append("<allprop/></propfind>");
        }
        return body;
    }

    public DAVPropertiesHandler(IDAVResponseHandler handler) {
        this.setResponsesHandler(handler);
    }

    public void setResponsesHandler(IDAVResponseHandler handler) {
        this.init();
        this.myResponseHandler = handler;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        if (element == DAVElement.RESPONSE) {
            this.myResponse = new DAVResponse();
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) {
        if (element == DAVElement.HREF) {
            if (parent == DAVElement.RESPONSE) {
                this.myResponse.setHref(cdata.toString());
            } else {
                this.myResponse.putPropertyValue(parent, cdata.toString());
            }
        } else if (element == DAVElement.RESPONSE) {
            this.myResponseHandler.handleDAVResponse(this.myResponse);
            this.myResponse = null;
        } else if (element == DAVElement.COLLECTION || element == DAVElement.BASELINE) {
            this.myResponse.putPropertyValue(parent, element);
        } else if (element == DAVElement.STATUS) {
            this.myResponse.setStatus(DAVStatus.parse(cdata.toString()));
        } else if (cdata != null && cdata.length() > 0 && this.myResponse != null) {
            this.myResponse.putPropertyValue(element, cdata.toString());
        }
    }
}

