/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.TimeUtil;
import org.xml.sax.Attributes;

public class DAVMergeHandler
extends BasicDAVHandler {
    private ISVNWorkspaceMediator myMediator;
    private Map myPathsMap;
    private static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    private String myAuthor;
    private Date myCommitDate;
    private long myRevision;
    private String myRepositoryPath;
    private String myVersionPath;
    private DAVElement myResourceType;
    private SVNCommitInfo myCommitInfo;

    public static StringBuffer generateMergeRequest(StringBuffer request, String activityURL) {
        request = request == null ? new StringBuffer() : request;
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        request.append("<D:merge xmlns:D=\"DAV:\">");
        request.append("<D:source><D:href>");
        request.append(activityURL);
        request.append("</D:href></D:source>");
        request.append("<D:no-auto-merge/><D:no-checkout/>");
        request.append("<D:prop>");
        request.append("<D:checked-in/><D:version-name/><D:resourcetype/>");
        request.append("<D:creationdate/><D:creator-displayname/>");
        request.append("</D:prop>");
        request.append("</D:merge>");
        return request;
    }

    public DAVMergeHandler(ISVNWorkspaceMediator mediator, Map pathsMap) {
        this.myMediator = mediator;
        this.myPathsMap = pathsMap;
        this.init();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == RESPONSE) {
            this.myResourceType = null;
            this.myRepositoryPath = null;
            this.myVersionPath = null;
            this.myAuthor = null;
            this.myCommitDate = null;
            this.myRevision = -1L;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.HREF) {
            if (parent == RESPONSE) {
                this.myRepositoryPath = cdata.toString();
                this.myRepositoryPath = PathUtil.decode(this.myRepositoryPath);
            } else if (parent == DAVElement.CHECKED_IN) {
                this.myVersionPath = cdata.toString();
            }
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.BASELINE) {
            this.myResourceType = element;
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.COLLECTION) {
            this.myResourceType = element;
        } else if (element == RESPONSE) {
            if (this.myResourceType == DAVElement.BASELINE) {
                this.myCommitInfo = new SVNCommitInfo(this.myRevision, this.myAuthor, this.myCommitDate);
            } else {
                DebugLog.log("COMMIT: saving new vurl for " + this.myRepositoryPath);
                String path = (String)this.myPathsMap.get(this.myRepositoryPath);
                DebugLog.log("COMMIT: wc path " + path);
                DebugLog.log("COMMIT: existing wc paths " + this.myPathsMap);
                if (path != null && this.myMediator != null) {
                    this.myMediator.setWorkspaceProperty(path, "svn:wc:ra_dav:version-url", this.myVersionPath);
                }
            }
        } else if (element == DAVElement.CREATION_DATE) {
            this.myCommitDate = TimeUtil.parseDate(cdata.toString());
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME) {
            this.myAuthor = cdata.toString();
        } else if (element == DAVElement.VERSION_NAME) {
            this.myRevision = Long.parseLong(cdata.toString());
        } else if (parent != DAVElement.PROPSTAT || element == DAVElement.STATUS) {
            // empty if block
        }
    }
}

