/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVDeltaHandler;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.xml.sax.Attributes;

public class DAVFileRevisionHandler
extends BasicDAVDeltaHandler {
    private static final DAVElement REVISION_PROPERTY = DAVElement.getElement("svn:", "rev-prop");
    private static final DAVElement FILE_REVISION = DAVElement.getElement("svn:", "file-rev");
    private ISVNFileRevisionHandler myFileRevisionsHandler;
    private String myPath;
    private long myRevision;
    private Map myProperties;
    private Map myPropertiesDelta;
    private String myPropertyName;
    private int myCount;

    public static StringBuffer generateFileRevisionsRequest(StringBuffer buffer, long startRevision, long endRevision, String path) {
        buffer = buffer == null ? new StringBuffer() : buffer;
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        buffer.append("<S:file-revs-report xmlns:S=\"svn:\">");
        if (startRevision >= 0L) {
            buffer.append("<S:start-revision>" + startRevision + "</S:start-revision>");
        }
        if (endRevision >= 0L) {
            buffer.append("<S:end-revision>" + endRevision + "</S:end-revision>");
        }
        buffer.append("<S:path>" + path + "</S:path>");
        buffer.append("</S:file-revs-report>");
        return buffer;
    }

    public DAVFileRevisionHandler(ISVNFileRevisionHandler handler) {
        this.myFileRevisionsHandler = handler;
        this.myCount = 0;
        this.init();
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        if (element == FILE_REVISION) {
            this.myPath = attrs.getValue("path");
            this.myRevision = Long.parseLong(attrs.getValue("rev"));
        } else if (element == REVISION_PROPERTY) {
            this.myPropertyName = attrs.getValue("name");
        }
        if (element == TX_DELTA) {
            if (this.myPath != null && this.myFileRevisionsHandler != null) {
                if (this.myProperties == null) {
                    this.myProperties = Collections.EMPTY_MAP;
                }
                if (this.myPropertiesDelta == null) {
                    this.myPropertiesDelta = Collections.EMPTY_MAP;
                }
                SVNFileRevision revision = new SVNFileRevision(this.myPath, this.myRevision, this.myProperties, this.myPropertiesDelta);
                this.myFileRevisionsHandler.hanldeFileRevision(revision);
                this.myPath = null;
            }
            this.setDeltaProcessing(true);
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) {
        if (element == FILE_REVISION) {
            this.myPath = null;
            this.myProperties = null;
            this.myPropertiesDelta = null;
        } else if (element == TX_DELTA) {
            this.setDeltaProcessing(false);
            ++this.myCount;
        } else if (element == REVISION_PROPERTY) {
            if (this.myProperties == null) {
                this.myProperties = new HashMap();
            }
            this.myProperties.put(this.myPropertyName, cdata);
            this.myPropertyName = null;
        }
    }

    public int getEntriesCount() {
        return this.myCount;
    }

    protected void handleDiffWindowClosed() {
        this.myFileRevisionsHandler.hanldeDiffWindowClosed(this.myPath);
    }

    protected OutputStream handleDiffWindow(SVNDiffWindow window) {
        return this.myFileRevisionsHandler.handleDiffWindow(this.myPath, window);
    }
}

