/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BasicDAVHandler
extends DefaultHandler {
    private static final Object ROOT = new Object();
    private Map myPrefixesMap = new HashMap();
    private StringBuffer myCDATA;
    private Stack myParent = new Stack();

    protected BasicDAVHandler() {
    }

    protected void init() {
        this.myPrefixesMap.clear();
        this.myParent.clear();
        this.myParent.push(ROOT);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        DAVElement element = this.getDAVElement(qName);
        try {
            this.startElement(this.getParent(), element, attributes);
        }
        catch (SVNException e) {
            DebugLog.error(e.getMessage());
            e.printStackTrace();
            throw new SAXException(e);
        }
        this.myParent.push(element);
        this.myCDATA = new StringBuffer();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.myParent.pop();
        DAVElement element = this.getDAVElement(qName);
        try {
            this.endElement(this.getParent(), element, this.myCDATA);
        }
        catch (SVNException e) {
            DebugLog.error(e.getMessage());
            throw new SAXException(e);
        }
        this.myCDATA = null;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.myCDATA != null) {
            this.myCDATA.append(ch, start, length);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.myPrefixesMap.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.myPrefixesMap.remove(prefix);
    }

    protected abstract void startElement(DAVElement var1, DAVElement var2, Attributes var3) throws SVNException;

    protected abstract void endElement(DAVElement var1, DAVElement var2, StringBuffer var3) throws SVNException;

    private DAVElement getParent() {
        Object parent = this.myParent.peek();
        if (parent == ROOT) {
            return null;
        }
        return (DAVElement)parent;
    }

    private DAVElement getDAVElement(String qName) {
        String prefix = null;
        int index = qName.indexOf(58);
        if (index >= 0) {
            prefix = qName.substring(0, index);
            prefix = (String)this.myPrefixesMap.get(prefix);
            qName = qName.substring(index + 1);
        }
        return DAVElement.getElement(prefix, qName);
    }
}

