/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.IOException;
import java.io.InputStream;

class XMLInputStream
extends InputStream {
    private InputStream mySource;
    private boolean myIsEscaping;
    private int myColonCount;
    private boolean myIsClosed;

    public XMLInputStream(InputStream source) {
        this.mySource = source;
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.mySource.read(b, off, len);
        for (int i = 0; i < read; ++i) {
            char ch = (char)b[off + i];
            if (ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t') {
                b[off + i] = 32;
                continue;
            }
            if (this.myIsEscaping) {
                if (ch == ':') {
                    ++this.myColonCount;
                    if (this.myColonCount <= 1) continue;
                    b[off + i] = 95;
                    continue;
                }
                if (!Character.isWhitespace(ch) && ch != '>') continue;
                this.myIsEscaping = false;
                continue;
            }
            if (this.myIsEscaping || ch != '<') continue;
            this.myIsEscaping = true;
            this.myColonCount = 0;
        }
        this.myIsClosed = read <= 0;
        return read;
    }

    public int read() throws IOException {
        int read = this.mySource.read();
        if (this.myIsEscaping) {
            if (read == 58) {
                ++this.myColonCount;
                if (this.myColonCount > 1) {
                    read = 95;
                }
            } else if (Character.isWhitespace((char)read) || read == 62) {
                this.myIsEscaping = false;
            }
        } else if (!this.myIsEscaping && read == 60) {
            this.myIsEscaping = true;
            this.myColonCount = 0;
        }
        return read;
    }
}

