/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;

public interface IDAVProxyManager {
    public static final IDAVProxyManager DEFAULT = new IDAVProxyManager(){

        public boolean isProxyEnabled(SVNRepositoryLocation location) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("http.proxySet"))) {
                return !DAVUtil.matchHost(System.getProperty("http.nonProxyHosts"), location.getHost());
            }
            return false;
        }

        public String getProxyHost(SVNRepositoryLocation location) {
            return System.getProperty("http.proxyHost");
        }

        public int getProxyPort(SVNRepositoryLocation location) {
            String value = System.getProperty("http.proxyPort");
            if (value == null) {
                return 3128;
            }
            try {
                return Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            catch (Throwable throwable) {
                return 3128;
            }
        }

        public String getProxyUserName(SVNRepositoryLocation location) {
            return System.getProperty("http.proxyUser");
        }

        public String getProxyPassword(SVNRepositoryLocation location) {
            return System.getProperty("http.proxyPassword");
        }
    };

    public boolean isProxyEnabled(SVNRepositoryLocation var1);

    public String getProxyHost(SVNRepositoryLocation var1);

    public int getProxyPort(SVNRepositoryLocation var1);

    public String getProxyUserName(SVNRepositoryLocation var1);

    public String getProxyPassword(SVNRepositoryLocation var1);
}

