/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVResponse;
import org.tmatesoft.svn.core.internal.io.dav.IDAVResponseHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.PathUtil;

public class DAVUtil {
    public static DAVResponse getResourceProperties(DAVConnection connection, String path, String label, DAVElement[] properties, boolean skipNotFound) throws SVNException {
        int[] nArray;
        final DAVResponse[] result = new DAVResponse[1];
        IDAVResponseHandler iDAVResponseHandler = new IDAVResponseHandler(){

            public void handleDAVResponse(DAVResponse response) {
                if (result[0] == null) {
                    result[0] = response;
                }
            }
        };
        if (skipNotFound) {
            int[] nArray2 = new int[3];
            nArray2[0] = 200;
            nArray2[1] = 207;
            nArray = nArray2;
            nArray2[2] = 404;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 200;
            nArray = nArray3;
            nArray3[1] = 207;
        }
        connection.doPropfind(path, 0, label, properties, iDAVResponseHandler, nArray);
        return result[0];
    }

    public static Object getPropertyValue(DAVConnection connection, String path, String label, DAVElement property) throws SVNException {
        final DAVResponse[] result = new DAVResponse[1];
        connection.doPropfind(path, 0, label, new DAVElement[]{property}, new IDAVResponseHandler(){

            public void handleDAVResponse(DAVResponse response) {
                if (result[0] == null) {
                    result[0] = response;
                }
            }
        });
        if (result[0] != null) {
            return result[0].getPropertyValue(property);
        }
        return null;
    }

    public static void getChildren(DAVConnection connection, String parentPath, DAVElement[] properties, IDAVResponseHandler handler) throws SVNException {
        connection.doPropfind(parentPath, 1, null, properties, handler);
    }

    public static DAVBaselineInfo getBaselineInfo(DAVConnection connection, String path, long revision, boolean includeType, boolean includeRevision, DAVBaselineInfo info) throws SVNException {
        DAVElement[] dAVElementArray;
        if (includeRevision) {
            dAVElementArray = DAVElement.BASELINE_PROPERTIES;
        } else {
            DAVElement[] dAVElementArray2 = new DAVElement[1];
            dAVElementArray = dAVElementArray2;
            dAVElementArray2[0] = DAVElement.BASELINE_COLLECTION;
        }
        DAVElement[] properties = dAVElementArray;
        DAVResponse baselineProperties = DAVUtil.getBaselineProperties(connection, path, revision, properties);
        info = info == null ? new DAVBaselineInfo() : info;
        info.baselinePath = baselineProperties.getHref();
        info.baselineBase = (String)baselineProperties.getPropertyValue(DAVElement.BASELINE_COLLECTION);
        info.baselineBase = PathUtil.encode(info.baselineBase);
        if (includeRevision) {
            info.revision = Long.parseLong((String)baselineProperties.getPropertyValue(DAVElement.VERSION_NAME));
        }
        if (includeType) {
            info.isDirectory = DAVUtil.getPropertyValue(connection, PathUtil.append(info.baselineBase, info.baselinePath), null, DAVElement.RESOURCE_TYPE) != null;
        }
        return info;
    }

    public static DAVResponse getBaselineProperties(DAVConnection connection, String path, long revision, DAVElement[] elements) throws SVNException {
        DAVResponse properties = null;
        String loppedPath = "";
        while (true) {
            try {
                properties = DAVUtil.getResourceProperties(connection, path, null, DAVElement.STARTING_PROPERTIES, false);
            }
            catch (SVNException e) {
                loppedPath = PathUtil.append(PathUtil.tail(path), loppedPath);
                if (!PathUtil.isEmpty(path = PathUtil.removeTail(path))) continue;
            }
            break;
        }
        if (properties == null) {
            throw new SVNException("resource " + path + " is not part of repository");
        }
        String vcc = (String)properties.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        String baselineRelativePath = (String)properties.getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH);
        if (vcc == null) {
            throw new SVNException("important properties are missing for " + path);
        }
        if (baselineRelativePath == null) {
            baselineRelativePath = "";
        }
        baselineRelativePath = PathUtil.append(baselineRelativePath, loppedPath);
        baselineRelativePath = PathUtil.removeLeadingSlash(baselineRelativePath);
        baselineRelativePath = PathUtil.removeTrailingSlash(baselineRelativePath);
        baselineRelativePath = PathUtil.encode(baselineRelativePath);
        String label = null;
        if (revision < 0L) {
            vcc = (String)DAVUtil.getPropertyValue(connection, vcc, null, DAVElement.CHECKED_IN);
        } else {
            label = Long.toString(revision);
        }
        DAVResponse result = DAVUtil.getResourceProperties(connection, vcc, label, elements, false);
        result.setHref(baselineRelativePath);
        return result;
    }

    public static Map filterProperties(DAVResponse source, Map target) {
        target = target == null ? new HashMap() : target;
        Iterator props = source.properties();
        while (props.hasNext()) {
            DAVElement property = (DAVElement)props.next();
            String namespace = property.getNamespace();
            Object value = source.getPropertyValue(property);
            if (value != null) {
                value = value.toString();
            }
            if (namespace.equals("http://subversion.tigris.org/xmlns/custom/")) {
                String name = property.getName();
                if (name.startsWith("svk_")) {
                    name = name.substring(0, "svk".length()) + ":" + name.substring("svk".length() + 1);
                }
                target.put(name, source.getPropertyValue(property));
                continue;
            }
            if (namespace.equals("http://subversion.tigris.org/xmlns/svn/")) {
                target.put("svn:" + property.getName(), source.getPropertyValue(property));
                continue;
            }
            if (property != DAVElement.CHECKED_IN) continue;
            target.put("svn:wc:ra_dav:version-url", source.getPropertyValue(property));
        }
        return target;
    }

    public static StringBuffer getCanonicalPath(String path, StringBuffer target) {
        target = target == null ? new StringBuffer() : target;
        int end = path.length() - 1;
        block3: for (int i = 0; i <= end; ++i) {
            char ch = path.charAt(i);
            switch (ch) {
                case '/': {
                    if (i == end && i != 0 || i > 0 && path.charAt(i - 1) == '/') continue block3;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        return target;
    }

    public static boolean matchHost(String pattern, String host) {
        if (pattern == null || host == null) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(pattern, ",|");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            token = token.replaceAll("\\.", "\\\\.");
            if (!Pattern.matches(token = token.replaceAll("\\*", ".*"), host)) continue;
            return true;
        }
        return false;
    }

    public static String xmlEncode(String value) {
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&apos;");
        value = value.replaceAll("\t", "&#09;");
        return value;
    }

    public static String xmlDecode(String value) {
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&#09;", "\t");
        value = value.replaceAll("&amp;", "&");
        return value;
    }

    public static Map parseAuthParameters(String source) {
        if (source == null) {
            return null;
        }
        source = source.trim();
        HashMap<String, String> parameters = new HashMap<String, String>();
        int index = source.indexOf(32);
        if (index <= 0) {
            return null;
        }
        String method = source.substring(0, index);
        parameters.put("", method);
        source = source.substring(index).trim();
        char[] chars = source.toCharArray();
        int tokenIndex = 0;
        boolean parsingToken = true;
        String name = null;
        String value = null;
        int quotesCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (parsingToken) {
                if (chars[i] != '=') continue;
                name = new String(chars, tokenIndex, i - tokenIndex);
                name = name.trim();
                tokenIndex = i + 1;
                parsingToken = false;
                continue;
            }
            if (chars[i] == '\"') {
                quotesCount = quotesCount > 0 ? 0 : 1;
                continue;
            }
            if (i + 1 < chars.length && (chars[i] != ',' || quotesCount != 0)) continue;
            value = new String(chars, tokenIndex, i - tokenIndex);
            if ((value = value.trim()).charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1);
                value = value.substring(0, value.length() - 1);
            }
            parameters.put(name, value);
            tokenIndex = i + 1;
            parsingToken = true;
        }
        return parameters;
    }
}

