/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.IDAVProxyManager;
import org.tmatesoft.svn.core.internal.io.dav.IDAVSSLManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;

public class DAVRepositoryFactory
extends SVNRepositoryFactory {
    private static IDAVSSLManager ourSSLManager;
    private static IDAVProxyManager ourProxyManager;

    public static void setup() {
        DAVRepositoryFactory.setup(IDAVSSLManager.DEFAULT, IDAVProxyManager.DEFAULT);
    }

    public static void setup(IDAVSSLManager sslManager) {
        DAVRepositoryFactory.setup(sslManager, IDAVProxyManager.DEFAULT);
        if (ourSSLManager == null) {
            ourSSLManager = sslManager == null ? IDAVSSLManager.DEFAULT : sslManager;
        }
        DAVRepositoryFactory factory = new DAVRepositoryFactory();
        SVNRepositoryFactory.registerRepositoryFactory("^https?://.*$", factory);
    }

    public static void setup(IDAVSSLManager sslManager, IDAVProxyManager proxyManager) {
        if (ourSSLManager == null) {
            IDAVSSLManager iDAVSSLManager = ourSSLManager = sslManager == null ? IDAVSSLManager.DEFAULT : sslManager;
        }
        if (ourProxyManager == null) {
            ourProxyManager = proxyManager == null ? IDAVProxyManager.DEFAULT : proxyManager;
        }
        DAVRepositoryFactory factory = new DAVRepositoryFactory();
        SVNRepositoryFactory.registerRepositoryFactory("^https?://.*$", factory);
    }

    public SVNRepository createRepositoryImpl(SVNRepositoryLocation location) {
        return new DAVRepository(location);
    }

    static IDAVSSLManager getSSLManager() {
        return ourSSLManager;
    }

    static IDAVProxyManager getProxyManager() {
        return ourProxyManager;
    }
}

