/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVCommitEditor;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVResponse;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.IDAVResponseHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVDateRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVFileRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.io.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNAuthenticationException;
import org.tmatesoft.svn.core.io.SVNDirEntry;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.TimeUtil;

class DAVRepository
extends SVNRepository {
    private DAVConnection myConnection;

    protected DAVRepository(SVNRepositoryLocation location) {
        super(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws SVNException {
        try {
            this.openConnection();
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRevision() throws SVNException {
        DAVBaselineInfo info = null;
        try {
            this.openConnection();
            info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocationPath(), -1L, false, true, info);
        }
        finally {
            this.closeConnection();
        }
        if (info == null) {
            throw new SVNException("can't get baseline information for " + this.getLocationPath());
        }
        return info.revision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatedRevision(Date date) throws SVNException {
        date = date == null ? new Date(System.currentTimeMillis()) : date;
        DAVDateRevisionHandler handler = new DAVDateRevisionHandler();
        StringBuffer request = DAVDateRevisionHandler.generateDateRevisionRequest(null, date);
        try {
            this.openConnection();
            this.myConnection.doReport(this.getLocationPath(), request, handler);
        }
        finally {
            this.closeConnection();
        }
        return handler.getRevisionNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        DAVBaselineInfo info = null;
        SVNNodeKind kind = SVNNodeKind.NONE;
        try {
            this.openConnection();
            path = this.getFullPath(path);
            info = DAVUtil.getBaselineInfo(this.myConnection, path, revision, true, false, info);
            kind = info.isDirectory ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            if (e instanceof SVNAuthenticationException) {
                throw e;
            }
        }
        finally {
            this.closeConnection();
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getRevisionProperties(long revision, Map properties) throws SVNException {
        properties = properties == null ? new HashMap() : properties;
        try {
            this.openConnection();
            DAVResponse source = DAVUtil.getBaselineProperties(this.myConnection, this.getLocationPath(), revision, null);
            properties = DAVUtil.filterProperties(source, properties);
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    public String getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        Map properties = this.getRevisionProperties(revision, null);
        return (String)properties.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String path, long revision, final Map properties, OutputStream contents) throws SVNException {
        long fileRevision = revision;
        try {
            this.openConnection();
            path = this.getFullPath(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, path, revision, false, true, null);
                path = PathUtil.append(info.baselineBase, info.baselinePath);
                fileRevision = info.revision;
            }
            if (properties != null) {
                this.myConnection.doPropfind(path, 0, null, null, new IDAVResponseHandler(){

                    public void handleDAVResponse(DAVResponse response) {
                        DAVUtil.filterProperties(response, properties);
                        Iterator props = response.properties();
                        while (props.hasNext()) {
                            DAVElement property = (DAVElement)props.next();
                            if (property == DAVElement.VERSION_NAME) {
                                properties.put("svn:entry:committed-rev", response.getPropertyValue(property));
                                continue;
                            }
                            if (property == DAVElement.MD5_CHECKSUM) {
                                properties.put("svn:entry:checksum", response.getPropertyValue(property));
                                continue;
                            }
                            if (property == DAVElement.CREATOR_DISPLAY_NAME) {
                                properties.put("svn:entry:last-author", response.getPropertyValue(property));
                                continue;
                            }
                            if (property != DAVElement.CREATION_DATE) continue;
                            properties.put("svn:entry:committed-date", response.getPropertyValue(property));
                        }
                    }
                });
                properties.put("svn:entry:revision", Long.toString(fileRevision));
            }
            if (contents != null) {
                this.myConnection.doGet(path, contents);
            }
        }
        finally {
            this.closeConnection();
        }
        return fileRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDir(String path, long revision, final Map properties, final ISVNDirEntryHandler handler) throws SVNException {
        long dirRevision = revision;
        DAVElement[] entryProperties = new DAVElement[]{DAVElement.VERSION_NAME, DAVElement.GET_CONTENT_LENGTH, DAVElement.RESOURCE_TYPE, DAVElement.CREATION_DATE, DAVElement.CREATOR_DISPLAY_NAME};
        try {
            this.openConnection();
            path = this.getFullPath(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, path, revision, false, true, null);
                path = PathUtil.append(info.baselineBase, info.baselinePath);
                dirRevision = info.revision;
            }
            if (handler != null) {
                final String parentPath = PathUtil.removeTrailingSlash(path);
                this.myConnection.doPropfind(path, 1, null, entryProperties, new IDAVResponseHandler(){

                    public void handleDAVResponse(DAVResponse child) {
                        long size;
                        String href = PathUtil.removeTrailingSlash(child.getHref());
                        if ((href = PathUtil.decode(href)).equals(PathUtil.decode(parentPath))) {
                            return;
                        }
                        String name = PathUtil.tail(href);
                        SVNNodeKind kind = SVNNodeKind.FILE;
                        Object revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
                        long lastRevision = Long.parseLong(revisionStr.toString());
                        String sizeStr = (String)child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
                        long l = size = sizeStr == null ? 0L : Long.parseLong(sizeStr);
                        if (child.getPropertyValue(DAVElement.RESOURCE_TYPE) == DAVElement.COLLECTION) {
                            kind = SVNNodeKind.DIR;
                        }
                        String author = (String)child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
                        String dateStr = (String)child.getPropertyValue(DAVElement.CREATION_DATE);
                        Date date = TimeUtil.parseDate(dateStr);
                        boolean hasProperties = false;
                        Iterator props = child.properties();
                        while (props.hasNext()) {
                            DAVElement property = (DAVElement)props.next();
                            if (!"http://subversion.tigris.org/xmlns/custom/".equals(property.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(property)) continue;
                            hasProperties = true;
                            break;
                        }
                        SVNDirEntry dirEntry = new SVNDirEntry(name, kind, size, hasProperties, lastRevision, date, author);
                        handler.handleDirEntry(dirEntry);
                    }
                });
            }
            if (properties != null) {
                this.myConnection.doPropfind(path, 0, null, null, new IDAVResponseHandler(){

                    public void handleDAVResponse(DAVResponse response) {
                        DAVUtil.filterProperties(response, properties);
                        Iterator props = response.properties();
                        while (props.hasNext()) {
                            DAVElement property = (DAVElement)props.next();
                            if (property == DAVElement.VERSION_NAME) {
                                properties.put("svn:entry:committed-rev", response.getPropertyValue(property));
                                continue;
                            }
                            if (property == DAVElement.CREATOR_DISPLAY_NAME) {
                                properties.put("svn:entry:last-author", response.getPropertyValue(property));
                                continue;
                            }
                            if (property != DAVElement.CREATION_DATE) continue;
                            properties.put("svn:entry:committed-date", response.getPropertyValue(property));
                        }
                    }
                });
            }
        }
        finally {
            this.closeConnection();
        }
        return dirRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileRevisions(String path, long startRevision, long endRevision, ISVNFileRevisionHandler handler) throws SVNException {
        String bcPath = this.getLocation().getPath();
        try {
            this.openConnection();
            path = this.getFullPath(path);
            path = path.substring(this.getRepositoryRoot().length());
            DAVFileRevisionHandler davHandler = new DAVFileRevisionHandler(handler);
            StringBuffer request = DAVFileRevisionHandler.generateFileRevisionsRequest(null, startRevision, endRevision, path);
            long revision = -1L;
            if (DAVRepository.isValidRevision(startRevision) && DAVRepository.isValidRevision(endRevision)) {
                revision = Math.max(startRevision, endRevision);
            }
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, bcPath, revision, false, false, null);
            bcPath = PathUtil.append(info.baselineBase, info.baselinePath);
            this.myConnection.doReport(bcPath, request, davHandler);
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int log(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, ISVNLogEntryHandler handler) throws SVNException {
        if (targetPaths == null || targetPaths.length == 0) {
            return 0;
        }
        DAVLogHandler davHandler = null;
        try {
            String path;
            this.openConnection();
            String[] fullPaths = new String[targetPaths.length];
            for (int i = 0; i < targetPaths.length; ++i) {
                fullPaths[i] = this.getFullPath(targetPaths[i]);
                DebugLog.log("LOG: full path: " + fullPaths[i]);
            }
            String string = path = fullPaths.length > 1 ? PathUtil.getCommonRoot(fullPaths) : fullPaths[0];
            if (!path.startsWith("/")) {
                path = "/".concat(path);
            }
            DebugLog.log("LOG: request path: " + path);
            for (int i = 0; i < targetPaths.length; ++i) {
                fullPaths[i] = fullPaths[i].substring(path.length());
                fullPaths[i] = PathUtil.removeLeadingSlash(fullPaths[i]);
                DebugLog.log("LOG: log path: " + fullPaths[i]);
            }
            StringBuffer request = DAVLogHandler.generateLogRequest(null, startRevision, endRevision, changedPath, strictNode, fullPaths);
            davHandler = new DAVLogHandler(handler);
            long revision = -1L;
            if (DAVRepository.isValidRevision(startRevision) && DAVRepository.isValidRevision(endRevision)) {
                revision = Math.max(startRevision, endRevision);
            }
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, path, revision, false, false, null);
            path = PathUtil.append(info.baselineBase, info.baselinePath);
            this.myConnection.doReport(path, request, davHandler);
        }
        finally {
            this.closeConnection();
        }
        if (davHandler != null) {
            return davHandler.getEntriesCount();
        }
        return -1;
    }

    private void openConnection() throws SVNException {
        this.lock();
        if (this.myConnection == null) {
            this.myConnection = new DAVConnection(this.getLocation());
        }
        this.myConnection.open(this);
    }

    private void closeConnection() {
        if (this.myConnection != null) {
            this.myConnection.close();
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        try {
            this.openConnection();
            String root = this.getLocation().getPath();
            if (path.startsWith("/")) {
                path = PathUtil.removeLeadingSlash(path);
                root = this.getLocationPath();
                path = path.substring(root.length());
            }
            StringBuffer request = DAVLocationsHandler.generateLocationsRequest(null, path, pegRevision, revisions);
            DAVLocationsHandler davHandler = new DAVLocationsHandler(handler);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, root, pegRevision, false, false, null);
            path = PathUtil.append(info.baselineBase, info.baselinePath);
            this.myConnection.doReport(path, request, davHandler);
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        StringBuffer request = DAVEditorHandler.generateEditorRequest(null, this.getLocation().toString(), revision, target, null, recursive, false, false, reporter);
        try {
            this.openConnection();
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocation().getPath(), revision, false, false, null);
            String path = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVResponse response = DAVUtil.getResourceProperties(this.myConnection, path, null, DAVElement.STARTING_PROPERTIES, true);
            if (response != null) {
                path = (String)response.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                this.myConnection.doReport(path, request, handler);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String url, long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if ((url = DAVRepository.getCanonicalURL(url)) == null) {
            throw new SVNException(url + ": not valid URL");
        }
        StringBuffer request = DAVEditorHandler.generateEditorRequest(null, this.getLocation().toString(), revision, target, url, recursive, true, false, reporter);
        try {
            this.openConnection();
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocation().getPath(), revision, false, false, null);
            String path = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVResponse response = DAVUtil.getResourceProperties(this.myConnection, path, null, DAVElement.STARTING_PROPERTIES, false);
            path = (String)response.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
            this.myConnection.doReport(path, request, handler);
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diff(String url, long revision, String target, boolean ignoreAncestry, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if ((url = DAVRepository.getCanonicalURL(url)) == null) {
            throw new SVNException(url + ": not valid URL");
        }
        StringBuffer request = DAVEditorHandler.generateEditorRequest(null, this.getLocation().toString(), revision, target, url, recursive, ignoreAncestry, false, reporter);
        try {
            this.openConnection();
            DAVEditorHandler handler = new DAVEditorHandler(editor, true);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocation().getPath(), revision, false, false, null);
            String path = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVResponse response = DAVUtil.getResourceProperties(this.myConnection, path, null, DAVElement.STARTING_PROPERTIES, false);
            path = (String)response.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
            this.myConnection.doReport(path, request, handler);
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void status(long revision, String target, boolean recursive, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        StringBuffer request = DAVEditorHandler.generateEditorRequest(null, this.getLocation().toString(), revision, target, null, recursive, false, false, reporter);
        try {
            this.openConnection();
            DAVEditorHandler handler = new DAVEditorHandler(editor, false);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocation().getPath(), revision, false, false, null);
            String path = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVResponse response = DAVUtil.getResourceProperties(this.myConnection, path, null, DAVElement.STARTING_PROPERTIES, true);
            if (response != null) {
                path = (String)response.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                this.myConnection.doReport(path, request, handler);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, String propertyValue) throws SVNException {
        DAVRepository.assertValidRevision(revision);
        StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, propertyName, propertyValue);
        try {
            this.openConnection();
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this.getLocation().getPath(), revision, false, false, null);
            String path = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVResponse response = DAVUtil.getResourceProperties(this.myConnection, path, null, DAVElement.STARTING_PROPERTIES, false);
            path = (String)response.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
            final String[] blPath = new String[1];
            DAVElement[] props = new DAVElement[]{DAVElement.AUTO_VERSION};
            this.myConnection.doPropfind(path, 0, Long.toString(revision), props, new IDAVResponseHandler(){

                public void handleDAVResponse(DAVResponse r) {
                    blPath[0] = r.getHref();
                    if (r.getPropertyValue(DAVElement.AUTO_VERSION) != null) {
                        blPath[0] = null;
                    }
                }
            });
            if (blPath[0] == null) {
                throw new SVNException("repository auto-versioning is enabled, can't put unversioned property");
            }
            this.myConnection.doProppatch(blPath[0], request, null);
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String message, ISVNWorkspaceMediator mediator) throws SVNException {
        this.openConnection();
        DAVCommitEditor editor = new DAVCommitEditor(this, this.myConnection, message, mediator, new Runnable(){

            public void run() {
                DAVRepository.this.closeConnection();
            }
        });
        return editor;
    }

    public String getFullPath(String path) {
        if (path != null && path.startsWith("/")) {
            if ("/".equals(path)) {
                return this.getRepositoryRoot();
            }
            return PathUtil.append(this.getRepositoryRoot(), path);
        }
        path = PathUtil.append(this.getLocation().getPath(), path);
        if (path.charAt(0) != '/') {
            path = '/' + path;
        }
        return path;
    }

    private String getLocationPath() {
        return DAVUtil.getCanonicalPath(this.getLocation().getPath(), null).toString();
    }

    void updateCredentials(String uuid, String root) {
        root = root == null ? this.getRepositoryRoot() : root;
        uuid = uuid == null ? this.getRepositoryUUID() : uuid;
        this.setRepositoryCredentials(uuid, root);
    }
}

