/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.util.HashMap;
import java.util.Map;

public class DAVElement {
    private static Map ourProperties = new HashMap();
    public static final String SVN_DAV_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/dav/";
    public static final String SVN_CUSTOM_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/custom/";
    public static final String SVN_SVN_PROPERTY_NAMESPACE = "http://subversion.tigris.org/xmlns/svn/";
    public static final String SVN_DAV_ERROR_NAMESPACE = "svn:";
    public static final String DAV_NAMESPACE = "DAV:";
    public static final String SVN_NAMESPACE = "svn:";
    public static final DAVElement MULTISTATUS = DAVElement.getElement("DAV:", "multistatus");
    public static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    public static final DAVElement HREF = DAVElement.getElement("DAV:", "href");
    public static final DAVElement PROPSTAT = DAVElement.getElement("DAV:", "propstat");
    public static final DAVElement PROP = DAVElement.getElement("DAV:", "prop");
    public static final DAVElement STATUS = DAVElement.getElement("DAV:", "status");
    public static final DAVElement BASELINE = DAVElement.getElement("DAV:", "baseline");
    public static final DAVElement BASELINE_COLLECTION = DAVElement.getElement("DAV:", "baseline-collection");
    public static final DAVElement CHECKED_IN = DAVElement.getElement("DAV:", "checked-in");
    public static final DAVElement COLLECTION = DAVElement.getElement("DAV:", "collection");
    public static final DAVElement RESOURCE_TYPE = DAVElement.getElement("DAV:", "resourcetype");
    public static final DAVElement VERSION_CONTROLLED_CONFIGURATION = DAVElement.getElement("DAV:", "version-controlled-configuration");
    public static final DAVElement VERSION_NAME = DAVElement.getElement("DAV:", "version-name");
    public static final DAVElement GET_CONTENT_LENGTH = DAVElement.getElement("DAV:", "getcontentlength");
    public static final DAVElement CREATION_DATE = DAVElement.getElement("DAV:", "creationdate");
    public static final DAVElement CREATOR_DISPLAY_NAME = DAVElement.getElement("DAV:", "creator-displayname");
    public static final DAVElement COMMENT = DAVElement.getElement("DAV:", "comment");
    public static final DAVElement DATE = DAVElement.getElement("svn:", "date");
    public static final DAVElement BASELINE_RELATIVE_PATH = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "baseline-relative-path");
    public static final DAVElement REPOSITORY_UUID = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "repository-uuid");
    public static final DAVElement MD5_CHECKSUM = DAVElement.getElement("http://subversion.tigris.org/xmlns/dav/", "md5-checksum");
    public static final DAVElement AUTO_VERSION = DAVElement.getElement("DAV:", "auto-version");
    public static final DAVElement[] STARTING_PROPERTIES = new DAVElement[]{VERSION_CONTROLLED_CONFIGURATION, RESOURCE_TYPE, BASELINE_RELATIVE_PATH, REPOSITORY_UUID};
    public static final DAVElement[] BASELINE_PROPERTIES = new DAVElement[]{BASELINE_COLLECTION, VERSION_NAME};
    private String myPropertyName;
    private String myNamespace;

    public static DAVElement getElement(String namespace, String name) {
        DAVElement property;
        HashMap<String, DAVElement> properties;
        if (namespace == null) {
            namespace = "";
        }
        if ((properties = (HashMap<String, DAVElement>)ourProperties.get(namespace)) == null) {
            properties = new HashMap<String, DAVElement>();
            ourProperties.put(namespace, properties);
        }
        if ((property = (DAVElement)properties.get(name)) == null) {
            property = new DAVElement(namespace, name);
            properties.put(name, property);
        }
        return property;
    }

    private DAVElement(String namespace, String propertyName) {
        this.myNamespace = namespace;
        this.myPropertyName = propertyName;
    }

    public String getNamespace() {
        return this.myNamespace;
    }

    public String getName() {
        return this.myPropertyName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getNamespace());
        if (!this.getNamespace().endsWith(":")) {
            sb.append(":");
        }
        sb.append(this.getName());
        return sb.toString();
    }
}

