/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVResponse;
import org.tmatesoft.svn.core.internal.io.dav.DAVStatus;
import org.tmatesoft.svn.core.internal.io.dav.HttpConnection;
import org.tmatesoft.svn.core.internal.io.dav.IDAVResponseHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVOptionsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.xml.sax.helpers.DefaultHandler;

class DAVConnection {
    private SVNRepositoryLocation myLocation;
    private HttpConnection myHttpConnection;
    private String myActivityCollectionURL;
    private boolean myIsHTTP10Connection;

    public DAVConnection(SVNRepositoryLocation location) {
        this.myLocation = location;
    }

    public SVNRepositoryLocation getLocation() {
        return this.myLocation;
    }

    public void open(DAVRepository repository) throws SVNException {
        if (this.myHttpConnection == null) {
            this.myHttpConnection = new HttpConnection(this.myLocation, repository.getCredentialsProvider());
            if (repository != null && repository.getRepositoryUUID() == null) {
                DAVStatus status;
                String path = this.myLocation.getPath();
                final DAVResponse[] result = new DAVResponse[1];
                StringBuffer body = DAVPropertiesHandler.generatePropertiesRequest(null, DAVElement.STARTING_PROPERTIES);
                IDAVResponseHandler handler = new IDAVResponseHandler(){

                    public void handleDAVResponse(DAVResponse response) {
                        result[0] = response;
                    }
                };
                while ((status = this.myHttpConnection.request("PROPFIND", path, 0, null, body, new DAVPropertiesHandler(handler), new int[]{200, 207, 404})).getResponseCode() == 404) {
                    if ("".equals(path) || "/".equals(path)) {
                        throw new SVNException(status.getErrorText());
                    }
                    path = PathUtil.removeTail(path);
                }
                if (status.getResponseCode() != 200 && status.getResponseCode() != 207) {
                    throw new SVNException(status.getErrorText());
                }
                String uuid = (String)result[0].getPropertyValue(DAVElement.REPOSITORY_UUID);
                String relativePath = (String)result[0].getPropertyValue(DAVElement.BASELINE_RELATIVE_PATH);
                String root = this.myLocation.getPath();
                if (relativePath != null) {
                    relativePath = PathUtil.removeTrailingSlash(relativePath);
                    if ((root = PathUtil.removeTrailingSlash(root)).endsWith(relativePath)) {
                        root = root.substring(0, root.length() - relativePath.length() - 1);
                    }
                } else {
                    root = path;
                }
                repository.updateCredentials(uuid, root);
            }
        }
    }

    public void doPropfind(String path, int depth, String label, DAVElement[] properties, IDAVResponseHandler handler) throws SVNException {
        this.doPropfind(path, depth, label, properties, handler, new int[]{200, 207});
    }

    public void doPropfind(String path, int depth, String label, DAVElement[] properties, IDAVResponseHandler handler, int[] okCodes) throws SVNException {
        StringBuffer body = DAVPropertiesHandler.generatePropertiesRequest(null, properties);
        this.myHttpConnection.request("PROPFIND", path, depth, label, body, new DAVPropertiesHandler(handler), okCodes);
    }

    public void doGet(String path, OutputStream os) throws SVNException {
        this.myHttpConnection.request("GET", path, 0, null, new StringBuffer(), os, null);
    }

    public void doReport(String path, StringBuffer requestBody, DefaultHandler handler) throws SVNException {
        this.myHttpConnection.request("REPORT", path, 0, null, requestBody, handler, new int[]{200, 207});
    }

    public void doProppatch(String path, StringBuffer requestBody, DefaultHandler handler) throws SVNException {
        this.myHttpConnection.request("PROPPATCH", path, 0, null, requestBody, handler, new int[]{200, 207});
    }

    public String doMakeActivity() throws SVNException {
        String url = this.getActivityCollectionURL(this.myLocation.getPath(), false) + DAVConnection.generateUUID();
        DAVStatus status = this.myHttpConnection.request("MKACTIVITY", url, 0, null, null, (OutputStream)null, new int[]{201, 404});
        if (status.getResponseCode() == 404) {
            url = this.getActivityCollectionURL(this.myLocation.getPath(), true) + DAVConnection.generateUUID();
            status = this.myHttpConnection.request("MKACTIVITY", url, 0, null, null, (OutputStream)null, new int[]{201});
        }
        this.myIsHTTP10Connection = status != null && status.isHTTP10();
        return url;
    }

    public DAVStatus doDelete(String path) throws SVNException {
        return this.myHttpConnection.request("DELETE", path, null, (StringBuffer)null, null, null);
    }

    public DAVStatus doDelete(String path, long revision) throws SVNException {
        HashMap<String, String> header = new HashMap<String, String>();
        if (revision >= 0L) {
            header.put("X-SVN-Version-Name", Long.toString(revision));
        }
        header.put("Depth", "infinity");
        return this.myHttpConnection.request("DELETE", path, header, (StringBuffer)null, null, null);
    }

    public DAVStatus doMakeCollection(String path) throws SVNException {
        return this.myHttpConnection.request("MKCOL", path, null, (StringBuffer)null, null, null);
    }

    public DAVStatus doPutDiff(String path, InputStream data) throws SVNException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/vnd.svn-svndiff");
        if (this.myIsHTTP10Connection) {
            DebugLog.log("HTTP 1.0 connection is detected, chunked encoding should not be used with PUT");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int b;
                while ((b = data.read()) >= 0) {
                    bos.write(b);
                }
            }
            catch (IOException e) {
                throw new SVNException(e);
            }
            finally {
                try {
                    data.close();
                }
                catch (IOException e) {}
            }
            data = new ByteArrayInputStream(bos.toByteArray());
        }
        return this.myHttpConnection.request("PUT", path, headers, data, null, null);
    }

    public DAVStatus doMerge(String activityURL, boolean response, DefaultHandler handler) throws SVNException {
        StringBuffer request = DAVMergeHandler.generateMergeRequest(null, activityURL);
        HashMap<String, String> header = null;
        if (!response) {
            header = new HashMap<String, String>();
            header.put("X-SVN-Options", "no-merge-response");
        }
        return this.myHttpConnection.request("MERGE", this.myLocation.getPath(), header, request, handler, null);
    }

    public DAVStatus doCheckout(String activityPath, String path) throws SVNException {
        StringBuffer request = new StringBuffer();
        request.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        request.append("<D:checkout xmlns:D=\"DAV:\">");
        request.append("<D:activity-set>");
        request.append("<D:href>");
        request.append(activityPath);
        request.append("</D:href>");
        request.append("</D:activity-set></D:checkout>");
        DAVStatus status = this.myHttpConnection.request("CHECKOUT", path, 0, null, request, (DefaultHandler)null, null);
        if (status.getResponseHeader().containsKey("Location")) {
            String location = (String)status.getResponseHeader().get("Location");
            location = location.substring(location.indexOf("://") + "://".length());
            location = location.substring(location.indexOf("/"));
            status.getResponseHeader().put("Location", location);
        }
        return status;
    }

    public DAVStatus doCopy(String src, String dst) throws SVNException {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Destination", dst);
        header.put("Depth", "infinity");
        return this.myHttpConnection.request("COPY", src, header, (StringBuffer)null, null, null);
    }

    public void close() {
        if (this.myHttpConnection != null) {
            this.myHttpConnection.close();
        }
    }

    private String getActivityCollectionURL(String path, boolean force) throws SVNException {
        if (!force && this.myActivityCollectionURL != null) {
            return this.myActivityCollectionURL;
        }
        DAVOptionsHandler handler = new DAVOptionsHandler();
        this.myHttpConnection.request("OPTIONS", path, 0, null, DAVOptionsHandler.OPTIONS_REQUEST, handler, null);
        this.myActivityCollectionURL = handler.getActivityCollectionURL();
        return this.myActivityCollectionURL;
    }

    private static String generateUUID() {
        long time = System.currentTimeMillis();
        String uuid = Long.toHexString(time);
        int zeroes = 16 - uuid.length();
        for (int i = 0; i < zeroes; ++i) {
            uuid = "0" + uuid;
        }
        return uuid;
    }
}

