/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.diff.SVNDiffWindowBuilder;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.DAVResource;
import org.tmatesoft.svn.core.internal.io.dav.DAVResponse;
import org.tmatesoft.svn.core.internal.io.dav.DAVStatus;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

class DAVCommitEditor
implements ISVNEditor {
    private String myLogMessage;
    private DAVConnection myConnection;
    private SVNRepositoryLocation myLocation;
    private DAVRepository myRepository;
    private Runnable myCloseCallback;
    private String myActivity;
    private DAVResource myCurrentFile;
    private Stack myDirsStack;
    private ISVNWorkspaceMediator myCommitMediator;
    private Map myPathsMap;

    public DAVCommitEditor(DAVRepository repository, DAVConnection connection, String message, ISVNWorkspaceMediator mediator, Runnable closeCallback) {
        this.myConnection = connection;
        this.myLogMessage = message;
        this.myLocation = repository.getLocation();
        this.myRepository = repository;
        this.myCloseCallback = closeCallback;
        this.myCommitMediator = mediator;
        this.myDirsStack = new Stack();
        this.myPathsMap = new HashMap();
    }

    public void targetRevision(long revision) throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void openRoot(long revision) throws SVNException {
        this.myActivity = this.createActivity(this.myLogMessage);
        DAVResource root = new DAVResource(this.myCommitMediator, this.myConnection, "", revision);
        root.getVersionURL();
        this.myDirsStack.push(root);
        this.myPathsMap.put(root.getURL(), root.getPath());
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        path = PathUtil.encode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(parentResource);
        String wPath = parentResource.getWorkingURL();
        wPath = this.myDirsStack.size() == 1 ? PathUtil.append(parentResource.getWorkingURL(), path) : PathUtil.append(wPath, PathUtil.tail(path));
        DAVStatus status = this.myConnection.doDelete(wPath, revision);
        if (status.getResponseCode() != 204 && status.getResponseCode() != 404) {
            throw new SVNException("DELETE failed: " + status);
        }
        if (this.myDirsStack.size() == 1) {
            this.myPathsMap.put(PathUtil.append(parentResource.getURL(), path), path);
        } else {
            this.myPathsMap.put(PathUtil.append(parentResource.getURL(), PathUtil.tail(path)), path);
        }
    }

    public void addDir(String path, String copyPath, long copyRevision) throws SVNException {
        String filePath;
        DAVResponse responce;
        path = PathUtil.encode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        if (parentResource.getWorkingURL() == null && (responce = DAVUtil.getResourceProperties(this.myConnection, filePath = PathUtil.append(parentResource.getURL(), PathUtil.tail(path)), null, DAVElement.STARTING_PROPERTIES, true)) != null) {
            throw new SVNException("Directory '" + filePath + "' already exists");
        }
        this.checkoutResource(parentResource);
        String wPath = parentResource.getWorkingURL();
        DAVResource newDir = new DAVResource(this.myCommitMediator, this.myConnection, PathUtil.encode(path), -1L, copyPath != null);
        newDir.setWorkingURL(PathUtil.append(wPath, PathUtil.tail(path)));
        this.myDirsStack.push(newDir);
        this.myPathsMap.put(newDir.getURL(), path);
        if (copyPath != null) {
            copyPath = PathUtil.encode(copyPath);
            copyPath = this.myRepository.getFullPath(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, copyPath, copyRevision, false, false, null);
            copyPath = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVStatus status = this.myConnection.doCopy(copyPath, wPath = this.myLocation.getProtocol() + "://" + this.myLocation.getHost() + ":" + this.myLocation.getPort() + PathUtil.encode(newDir.getWorkingURL()));
            if (status.getResponseCode() != 201 && status.getResponseCode() != 204) {
                throw new SVNException("COPY failed: " + status);
            }
        } else {
            DAVStatus status = this.myConnection.doMakeCollection(newDir.getWorkingURL());
            if (status.getResponseCode() != 201) {
                throw new SVNException("MKCOL failed: " + status);
            }
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        path = PathUtil.encode(path);
        DAVResource parent = (DAVResource)this.myDirsStack.peek();
        DAVResource directory = new DAVResource(this.myCommitMediator, this.myConnection, path, revision, parent.isCopy());
        if (parent != null && parent.isCopy()) {
            directory.setWorkingURL(PathUtil.append(parent.getWorkingURL(), PathUtil.tail(path)));
        }
        this.myDirsStack.push(directory);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        DAVResource directory = (DAVResource)this.myDirsStack.peek();
        this.checkoutResource(directory);
        directory.putProperty(name, value);
        this.myPathsMap.put(directory.getURL(), directory.getPath());
    }

    public void closeDir() throws SVNException {
        DAVResource resource = (DAVResource)this.myDirsStack.pop();
        if (resource.getProperties() != null) {
            StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, resource.getProperties());
            this.myConnection.doProppatch(resource.getWorkingURL(), request, null);
        }
        resource.dispose();
    }

    public void addFile(String path, String copyPath, long copyRevision) throws SVNException {
        String filePath;
        DAVResponse responce;
        path = PathUtil.encode(path);
        DAVResource parentResource = (DAVResource)this.myDirsStack.peek();
        if (parentResource.getWorkingURL() == null && (responce = DAVUtil.getResourceProperties(this.myConnection, filePath = PathUtil.append(parentResource.getURL(), PathUtil.tail(path)), null, DAVElement.STARTING_PROPERTIES, true)) != null) {
            throw new SVNException("File '" + filePath + "' already exists");
        }
        this.checkoutResource(parentResource);
        String wPath = parentResource.getWorkingURL();
        DAVResource newFile = new DAVResource(this.myCommitMediator, this.myConnection, path, -1L);
        newFile.setWorkingURL(PathUtil.append(wPath, PathUtil.tail(path)));
        this.myCurrentFile = newFile;
        this.myPathsMap.put(this.myCurrentFile.getURL(), this.myCurrentFile.getPath());
        if (copyPath != null) {
            copyPath = PathUtil.encode(copyPath);
            copyPath = this.myRepository.getFullPath(copyPath);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, copyPath, copyRevision, false, false, null);
            copyPath = PathUtil.append(info.baselineBase, info.baselinePath);
            DAVStatus status = this.myConnection.doCopy(copyPath, wPath = this.myLocation.getProtocol() + "://" + this.myLocation.getHost() + ":" + this.myLocation.getPort() + PathUtil.encode(newFile.getWorkingURL()));
            if (status.getResponseCode() != 201 && status.getResponseCode() != 204) {
                throw new SVNException("COPY failed: " + status);
            }
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        path = PathUtil.encode(path);
        DAVResource file = new DAVResource(this.myCommitMediator, this.myConnection, path, revision);
        DAVResource parent = (DAVResource)this.myDirsStack.peek();
        if (parent.isCopy()) {
            file.setWorkingURL(PathUtil.append(parent.getWorkingURL(), PathUtil.tail(path)));
        }
        this.checkoutResource(file);
        this.myCurrentFile = file;
        this.myPathsMap.put(this.myCurrentFile.getURL(), this.myCurrentFile.getPath());
    }

    public void applyTextDelta(String baseChecksum) throws SVNException {
    }

    public OutputStream textDeltaChunk(SVNDiffWindow diffWindow) throws SVNException {
        try {
            OutputStream os = this.myCurrentFile.addTextDelta();
            SVNDiffWindowBuilder.save(diffWindow, os);
            return os;
        }
        catch (IOException e) {
            throw new SVNException();
        }
    }

    public void textDeltaEnd() throws SVNException {
    }

    public void changeFileProperty(String name, String value) throws SVNException {
        this.myCurrentFile.putProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String textChecksum) throws SVNException {
        try {
            for (int i = 0; i < this.myCurrentFile.getDeltaCount(); ++i) {
                try {
                    InputStream data = this.myCurrentFile.getTextDelta(i);
                    DAVStatus status = this.myConnection.doPutDiff(this.myCurrentFile.getWorkingURL(), data);
                    data.close();
                    if (status.getResponseCode() == 201 || status.getResponseCode() == 204) continue;
                    throw new SVNException("PUT failed: " + status);
                }
                catch (IOException e) {
                    throw new SVNException(e);
                }
            }
            if (this.myCurrentFile.getProperties() != null) {
                StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, this.myCurrentFile.getProperties());
                this.myConnection.doProppatch(this.myCurrentFile.getWorkingURL(), request, null);
            }
        }
        finally {
            this.myCurrentFile.dispose();
            this.myCurrentFile = null;
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        DAVMergeHandler handler = new DAVMergeHandler(this.myCommitMediator, this.myPathsMap);
        DAVStatus status = this.myConnection.doMerge(this.myActivity, true, handler);
        if (status == null || status.getResponseCode() != 200) {
            throw new SVNException(status != null ? status.toString() : "");
        }
        this.abortEdit();
        return handler.getCommitInfo();
    }

    public void abortEdit() throws SVNException {
        if (this.myActivity != null) {
            this.myConnection.doDelete(this.myActivity);
        }
        if (this.myCurrentFile != null) {
            this.myCurrentFile.dispose();
            this.myCurrentFile = null;
        }
        Iterator files = this.myDirsStack.iterator();
        while (files.hasNext()) {
            DAVResource resource = (DAVResource)files.next();
            resource.dispose();
        }
        this.myDirsStack = null;
        this.myCloseCallback.run();
    }

    private String createActivity(String logMessage) throws SVNException {
        String activity = this.myConnection.doMakeActivity();
        String vcc = (String)DAVUtil.getPropertyValue(this.myConnection, this.myLocation.getPath(), null, DAVElement.VERSION_CONTROLLED_CONFIGURATION);
        String location = null;
        String head = null;
        DAVStatus status = null;
        head = (String)DAVUtil.getPropertyValue(this.myConnection, vcc, null, DAVElement.CHECKED_IN);
        status = this.myConnection.doCheckout(activity, head);
        location = (String)status.getResponseHeader().get("Location");
        if (location == null) {
            throw new SVNException("failed to check out " + head + " into " + activity + " : " + status.toString());
        }
        logMessage = logMessage == null ? "no message" : logMessage;
        StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, "svn:log", logMessage);
        this.myConnection.doProppatch(location, request, null);
        return activity;
    }

    private void checkoutResource(DAVResource resource) throws SVNException {
        if (resource.getWorkingURL() != null) {
            return;
        }
        if (resource.getVersionURL() == null) {
            throw new SVNException(resource.getURL() + " checkout failed: resource version URL is not set");
        }
        DebugLog.log("vURL: " + resource.getVersionURL());
        DAVStatus status = this.myConnection.doCheckout(this.myActivity, resource.getVersionURL());
        String location = (String)status.getResponseHeader().get("Location");
        if (status.getResponseCode() == 201 && location != null) {
            DebugLog.log("wURL: " + location);
            resource.setWorkingURL(location);
            return;
        }
        throw new SVNException(resource.getURL() + " checkout failed: " + status.toString());
    }
}

