/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.IOException;
import java.io.InputStream;

class ChunkedInputStream
extends InputStream {
    private InputStream mySource;
    private byte[] myBuffer;
    private int myPosition;

    public ChunkedInputStream(InputStream source) {
        this.mySource = source;
    }

    public int read() throws IOException {
        if (this.mySource == null) {
            return -1;
        }
        if (this.myBuffer == null || this.myPosition >= this.myBuffer.length) {
            int length = this.readChunkLength();
            if (length == 0) {
                this.mySource = null;
                return -1;
            }
            this.myBuffer = new byte[length];
            int offset = 0;
            while (length > 0) {
                int count = this.mySource.read(this.myBuffer, offset, length);
                length -= count;
                offset += count;
            }
            this.myPosition = 0;
        }
        return this.myBuffer[this.myPosition++] & 0xFF;
    }

    private int readChunkLength() throws IOException {
        char ch = '\u0000';
        StringBuffer sb = new StringBuffer();
        while (true) {
            int r;
            if ((r = this.mySource.read()) < 0) {
                return 0;
            }
            ch = (char)r;
            if (ch == '\r') continue;
            if (ch == '\n' || ch == '\r') {
                if (sb.length() != 0) break;
                continue;
            }
            sb.append(ch);
        }
        return Integer.parseInt(sb.toString(), 16);
    }
}

