/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;

class SVNWorkspaceMediatorAdapter
implements ISVNWorkspaceMediator {
    private ISVNWorkspaceMediator myMediator;
    private Map myCommitTree;

    public SVNWorkspaceMediatorAdapter(ISVNWorkspaceMediator mediator, Map commitTree) {
        this.myMediator = mediator;
        this.myCommitTree = commitTree;
    }

    public String getWorkspaceProperty(String path, String name) throws SVNException {
        ISVNEntry entry;
        if (this.myCommitTree != null && (entry = (ISVNEntry)this.myCommitTree.get(path)) != null) {
            DebugLog.log("getting property for path (citem): " + entry.getPath());
            return this.myMediator.getWorkspaceProperty(entry.getPath(), name);
        }
        return null;
    }

    public void setWorkspaceProperty(String path, String name, String value) throws SVNException {
        ISVNEntry entry;
        if (this.myCommitTree != null && (entry = (ISVNEntry)this.myCommitTree.get(path)) != null) {
            DebugLog.log("setting property for path (citem): " + entry.getPath());
            DebugLog.log("prop value: " + value);
            this.myMediator.setWorkspaceProperty(entry.getPath(), name, value);
        }
    }

    public OutputStream createTemporaryLocation(String path, Object id) throws IOException {
        if (this.myCommitTree != null) {
            ISVNEntry entry = (ISVNEntry)this.myCommitTree.get(path);
            path = entry != null ? entry.getPath() : null;
        }
        return this.myMediator.createTemporaryLocation(path, id);
    }

    public void deleteAdminFiles(String path) {
        if (this.myCommitTree != null) {
            ISVNEntry entry = (ISVNEntry)this.myCommitTree.get(path);
            path = entry.getPath();
        }
        this.myMediator.deleteAdminFiles(path);
    }

    public InputStream getTemporaryLocation(Object id) throws IOException {
        return this.myMediator.getTemporaryLocation(id);
    }

    public long getLength(Object id) throws IOException {
        return this.myMediator.getLength(id);
    }

    public void deleteTemporaryLocation(Object id) {
        this.myMediator.deleteTemporaryLocation(id);
    }
}

