/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNStatus;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

public class SVNStatusEditor
implements ISVNEditor {
    private long myTargetRevision;
    private String myCurrentPath;
    private String myRootPath;
    private Map myRemoteStatuses = new HashMap();
    private String myCurrentFilePath;
    private long myCurrentFileRevision;
    private long myCurrentRevision;

    public SVNStatusEditor() {
        this("");
    }

    public SVNStatusEditor(String rootPath) {
        this.myRootPath = rootPath;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentPath = "";
        this.myCurrentRevision = revision;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.myRemoteStatuses.put(path, new RemoteSVNStatus(revision, 3, 0));
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyPath, long copyRevision) throws SVNException {
        RemoteSVNStatus status = (RemoteSVNStatus)this.myRemoteStatuses.get(path);
        if (status == null) {
            status = new RemoteSVNStatus(this.myTargetRevision, 1, 0);
        } else if (status.myContentsStatus == 3) {
            status.myContentsStatus = 7;
        }
        if (status != null) {
            status.isAddedWithHistory = copyPath != null;
            status.isDirectory = true;
            this.myRemoteStatuses.put(path, status);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentPath = path;
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (!name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            RemoteSVNStatus status = (RemoteSVNStatus)this.myRemoteStatuses.get(this.myCurrentPath);
            if (status == null) {
                status = new RemoteSVNStatus(this.myCurrentRevision, 0, 6);
                this.myRemoteStatuses.put(this.myCurrentPath, status);
            } else if (status.myContentsStatus != 1 && status.myContentsStatus != 7) {
                status.myPropertiesStatus = 6;
            }
            status.isDirectory = true;
        }
    }

    public void closeDir() throws SVNException {
    }

    public void addFile(String path, String copyPath, long copyRevision) throws SVNException {
        this.myRemoteStatuses.put(path, new RemoteSVNStatus(this.myTargetRevision, 1, 0));
        RemoteSVNStatus status = (RemoteSVNStatus)this.myRemoteStatuses.get(path);
        if (status == null) {
            status = new RemoteSVNStatus(this.myTargetRevision, 1, 0);
        } else if (status.myContentsStatus == 3) {
            status.myContentsStatus = 7;
        }
        if (status != null) {
            status.isAddedWithHistory = copyPath != null;
            status.isDirectory = false;
            this.myRemoteStatuses.put(path, status);
        }
        this.myCurrentFilePath = path;
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFilePath = path;
        this.myCurrentFileRevision = revision;
    }

    public void applyTextDelta(String baseChecksum) throws SVNException {
        RemoteSVNStatus status = (RemoteSVNStatus)this.myRemoteStatuses.get(this.myCurrentFilePath);
        if (status == null) {
            status = new RemoteSVNStatus(this.myCurrentFileRevision, 6, 0);
            this.myRemoteStatuses.put(this.myCurrentFilePath, status);
        } else if (status.myContentsStatus != 1) {
            status.myContentsStatus = 6;
        }
        status.isDirectory = false;
    }

    public OutputStream textDeltaChunk(SVNDiffWindow diffWindow) throws SVNException {
        return null;
    }

    public void textDeltaEnd() throws SVNException {
    }

    public void closeFile(String textChecksum) throws SVNException {
        this.myCurrentFilePath = null;
        this.myCurrentFileRevision = -1L;
    }

    public void changeFileProperty(String name, String value) throws SVNException {
        if (!name.startsWith("svn:entry:") && !name.startsWith("svn:wc:")) {
            RemoteSVNStatus status = (RemoteSVNStatus)this.myRemoteStatuses.get(this.myCurrentFilePath);
            if (status == null) {
                this.myRemoteStatuses.put(this.myCurrentFilePath, new RemoteSVNStatus(this.myCurrentFileRevision, 0, 6));
            } else if (status.myContentsStatus != 1 && status.myContentsStatus != 7) {
                status.myPropertiesStatus = 6;
                status.isDirectory = false;
            }
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return new SVNCommitInfo(this.myTargetRevision, null, null);
    }

    public void abortEdit() throws SVNException {
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public Map completeStatus(Map statuses, String path, boolean descend) {
        String name;
        String remotePath;
        String relativePath = path.substring(this.myRootPath.length());
        relativePath = PathUtil.removeLeadingSlash(relativePath);
        LinkedList<String> remoteMatches = new LinkedList<String>();
        Iterator<Object> remotePaths = this.myRemoteStatuses.keySet().iterator();
        while (remotePaths.hasNext()) {
            String head;
            remotePath = (String)remotePaths.next();
            if (!remotePath.equals(relativePath) && !remotePath.startsWith(relativePath + "/") && (remotePath.indexOf(47) >= 0 || !"".equals(relativePath))) continue;
            name = remotePath.substring(relativePath.length());
            if ((name = PathUtil.removeLeadingSlash(name)).indexOf(47) < 0) {
                if ((!statuses.containsKey(name) || statuses.get(name) == null) && statuses.containsKey(name)) continue;
                remoteMatches.add(remotePath);
                continue;
            }
            if (!descend || statuses.containsKey(head = PathUtil.head(name))) continue;
            remoteMatches.add(remotePath);
        }
        DebugLog.log("COMPLETING STATUS FOR  " + path + " : " + statuses.keySet());
        DebugLog.log("REMOTE MATCHED ENTRIES " + remoteMatches);
        remotePaths = remoteMatches.iterator();
        while (remotePaths.hasNext()) {
            remotePath = (String)remotePaths.next();
            name = remotePath.substring(relativePath.length());
            name = PathUtil.removeLeadingSlash(name);
            RemoteSVNStatus remoteStatus = (RemoteSVNStatus)this.myRemoteStatuses.remove(remotePath);
            if (remoteStatus == null) continue;
            SVNStatus svnStatus = (SVNStatus)statuses.get(name);
            if (svnStatus != null) {
                svnStatus.setRemoteStatus(remoteStatus.myRevision, remoteStatus.myPropertiesStatus, remoteStatus.myContentsStatus);
                continue;
            }
            svnStatus = new SVNStatus(PathUtil.removeLeadingSlash(PathUtil.append(path, name)), 0, 0, -1L, -1L, remoteStatus.myRevision, remoteStatus.myContentsStatus, remoteStatus.myPropertiesStatus, remoteStatus.isAddedWithHistory, false, remoteStatus.isDirectory, null);
            statuses.put(name, svnStatus);
        }
        return statuses;
    }

    private static class RemoteSVNStatus {
        public long myRevision;
        public int myContentsStatus;
        public int myPropertiesStatus;
        public boolean isAddedWithHistory;
        public boolean isDirectory;

        public RemoteSVNStatus(long revision, int contentsStatus, int propertiesStatus) {
            this.myRevision = revision;
            this.myContentsStatus = contentsStatus;
            this.myPropertiesStatus = propertiesStatus;
        }
    }
}

