/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNWorkspace;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.SVNExternal;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

class SVNReporterBaton
implements ISVNReporterBaton {
    private final ISVNEntry myRoot;
    private boolean myIsRecursive;
    private String myTarget;
    private Collection myExternals;
    private Collection myMissingEntries;
    private ISVNWorkspace myWorkspace;

    public SVNReporterBaton(ISVNWorkspace workspace, ISVNEntry root, String target, boolean recursive) {
        this.myRoot = root;
        this.myWorkspace = workspace;
        this.myIsRecursive = recursive;
        this.myTarget = target;
        this.myMissingEntries = new HashSet();
        this.myExternals = new HashSet();
    }

    protected void reportEntry(ISVNEntry entry, ISVNReporter reporter, String parentURL, long parentRevision) throws SVNException {
        long revision = SVNProperty.longValue(entry.getPropertyValue("svn:entry:revision"));
        if (revision < 0L && !entry.isMissing()) {
            return;
        }
        String path = this.getEntryPath(entry);
        if (SVNReporterBaton.isSwitched(parentURL, entry)) {
            DebugLog.log("REPORT.LINK: " + entry.getPropertyValue("svn:entry:url") + " : " + path + " : " + revision);
            String url = entry.getPropertyValue("svn:entry:url");
            url = PathUtil.decode(url);
            reporter.linkPath(SVNRepositoryLocation.parseURL(url), path, revision, false);
        } else if (entry.isMissing()) {
            if (this.myWorkspace != null && !entry.isDirectory()) {
                entry.asFile().restoreContents();
                entry.asFile().markResolved(true);
                ((SVNWorkspace)this.myWorkspace).fireEntryModified(entry, 15, false);
                if (revision != parentRevision) {
                    reporter.setPath(path, revision, false);
                }
            } else {
                DebugLog.log("REPORT.MISSING: " + path);
                reporter.deletePath(path);
                this.myMissingEntries.add(entry);
            }
        } else if (revision != parentRevision) {
            DebugLog.log("REPORT: " + path + " : " + revision);
            reporter.setPath(path, revision, false);
        }
    }

    public void report(ISVNReporter reporter) throws SVNException {
        if (this.myTarget != null) {
            ISVNEntry targetEntry = this.myRoot.asDirectory().getChild(this.myTarget);
            long revision = 0L;
            if (targetEntry != null) {
                revision = SVNProperty.longValue(targetEntry.getPropertyValue("svn:entry:revision"));
            }
            if (revision >= 0L) {
                DebugLog.log("REPORT.TARGET: " + this.myTarget + " : " + revision);
                reporter.setPath("", revision, revision == 0L);
            } else {
                revision = SVNProperty.longValue(this.myRoot.getPropertyValue("svn:entry:revision"));
                DebugLog.log("REPORT.MISSING.TARGET: " + this.myTarget + " : " + revision);
                reporter.setPath("", revision, false);
                reporter.deletePath("");
                if (targetEntry != null) {
                    this.myMissingEntries.add(targetEntry);
                }
            }
        } else {
            this.doReport(this.myRoot, reporter, null, -1L);
        }
        reporter.finishReport();
    }

    public Iterator missingEntries() {
        return this.myMissingEntries.iterator();
    }

    private void doReport(ISVNEntry r, ISVNReporter reporter, String parentURL, long parentRevision) throws SVNException {
        long revision = SVNProperty.longValue(r.getPropertyValue("svn:entry:revision"));
        if (revision < 0L && !r.isMissing()) {
            return;
        }
        if (r.isScheduledForAddition()) {
            return;
        }
        this.reportEntry(r, reporter, parentURL, parentRevision);
        if (r.isDirectory()) {
            this.myExternals = SVNExternal.create(r.asDirectory(), this.myExternals);
        }
        if (r.isDirectory()) {
            ISVNDirectoryEntry dir = r.asDirectory();
            String target = this.myTarget;
            this.myTarget = null;
            parentURL = dir.getPropertyValue("svn:entry:url");
            Iterator entries = dir.childEntries();
            while (entries.hasNext()) {
                ISVNEntry child = (ISVNEntry)entries.next();
                if (target != null && !target.equals(child.getName())) continue;
                if (this.myIsRecursive) {
                    this.doReport(child, reporter, parentURL, revision);
                } else if (!child.isScheduledForAddition()) {
                    this.reportEntry(child, reporter, parentURL, revision);
                }
                if (target == null) continue;
                return;
            }
            Iterator deleted = dir.deletedEntries();
            while (deleted.hasNext()) {
                Map deletedEntry = (Map)deleted.next();
                String name = (String)deletedEntry.get("svn:entry:name");
                if (target != null && !target.equals(name)) continue;
                String path = PathUtil.append(dir.getPath(), name);
                path = path.substring(this.myRoot.getPath().length());
                path = PathUtil.removeLeadingSlash(path);
                DebugLog.log("REPORT.DELETE: " + path);
                reporter.deletePath(path);
            }
        }
    }

    protected String getEntryPath(ISVNEntry entry) {
        String path = entry.getPath();
        path = path.substring(this.myRoot.getPath().length());
        return PathUtil.removeLeadingSlash(path);
    }

    public Collection getExternals() {
        return this.myExternals;
    }

    public static boolean isSwitched(String parentURL, ISVNEntry entry) throws SVNException {
        if (parentURL == null || entry.getPropertyValue("svn:entry:url") == null || entry.isObstructed()) {
            return false;
        }
        String expectedURL = PathUtil.append(parentURL, PathUtil.encode(entry.getName()));
        return !expectedURL.equals(entry.getPropertyValue("svn:entry:url"));
    }
}

