/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNRootEntry;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryLocation;
import org.tmatesoft.svn.core.progress.SVNProgressProcessor;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;
import org.tmatesoft.svn.util.TimeUtil;

public class SVNCommitUtil {
    private static final String SVN_ENTRY_REPLACED = "svn:entry:replaced";

    public static String buildCommitTree(Collection modifiedEntries, Map map) throws SVNException {
        map = map == null ? new HashMap() : map;
        ISVNEntry root = null;
        Iterator entries = modifiedEntries.iterator();
        while (entries.hasNext()) {
            ISVNEntry entry = (ISVNEntry)entries.next();
            String url = PathUtil.decode(entry.getPropertyValue("svn:entry:url"));
            if (entry instanceof ISVNRootEntry) {
                root = entry;
            }
            map.put(url, entry);
        }
        DebugLog.log("modified paths: " + modifiedEntries);
        DebugLog.log("modified map  : " + map);
        String commonRoot = null;
        String[] urls = map.keySet().toArray(new String[map.size()]);
        if (root == null) {
            String[] paths = new String[urls.length];
            String host = null;
            for (int i = 0; i < paths.length; ++i) {
                int index = urls[i].indexOf("://");
                if ((index = urls[i].indexOf(47, index + "://".length())) < 0) {
                    index = urls[i].length();
                }
                host = urls[i].substring(0, index);
                paths[i] = PathUtil.removeLeadingSlash(urls[i].substring(index));
            }
            if (map.size() == 1) {
                ISVNEntry rootEntry = (ISVNEntry)map.get(urls[0]);
                if (!rootEntry.isDirectory() || rootEntry.isScheduledForAddition() || rootEntry.isScheduledForDeletion() || rootEntry.isPropertiesModified()) {
                    commonRoot = PathUtil.getCommonRoot(paths);
                    DebugLog.log("using parent as root  : " + commonRoot);
                } else {
                    commonRoot = paths[0];
                    DebugLog.log("using root as is  : " + commonRoot);
                }
            } else {
                commonRoot = PathUtil.getCommonRoot(paths);
            }
            commonRoot = "".equals(commonRoot) ? host : PathUtil.append(host, commonRoot);
        } else {
            commonRoot = root.getPropertyValue("svn:entry:url");
            commonRoot = PathUtil.decode(commonRoot);
        }
        if (!map.containsKey(commonRoot)) {
            map.put(commonRoot, null);
        }
        for (int i = 0; i < urls.length; ++i) {
            String key = urls[i];
            Object value = map.get(key);
            String newKey = key.substring(commonRoot.length());
            newKey = PathUtil.removeLeadingSlash(newKey);
            map.put(newKey, value);
            map.remove(key);
        }
        if (map.containsKey(commonRoot)) {
            map.put("", map.get(commonRoot));
            map.remove(commonRoot);
        }
        return commonRoot;
    }

    public static void harvestCommitables(ISVNEntry root, String[] paths, boolean recursive, Collection modified) throws SVNException {
        String entryPath = root.getPath();
        DebugLog.log("HV: processing " + entryPath);
        boolean harvest = false;
        for (int i = 0; i < paths.length; ++i) {
            boolean bl = harvest = !recursive && entryPath.startsWith(paths[i]) || recursive && (entryPath.startsWith(paths[i]) || paths[i].startsWith(entryPath));
            if (harvest) break;
        }
        if (!harvest) {
            DebugLog.log("HV: processing " + entryPath + " => not below commit roots");
            return;
        }
        if (root.isMissing()) {
            DebugLog.log("HV: processing " + entryPath + " => missing, skipped");
            return;
        }
        boolean copy = root.getPropertyValue("svn:entry:copied") != null;
        long revision = SVNProperty.longValue(root.getPropertyValue("svn:entry:revision"));
        if (root.isDirectory()) {
            if (root.isScheduledForAddition() || root.isScheduledForDeletion() || root.isPropertiesModified()) {
                for (int i = 0; i < paths.length; ++i) {
                    if (!entryPath.startsWith(paths[i])) continue;
                    DebugLog.log("HV: processing " + entryPath + " => added to modified as directory");
                    modified.add(root);
                    break;
                }
            }
            if (root.isScheduledForDeletion() && !root.isScheduledForAddition()) {
                DebugLog.log("HV: processing " + entryPath + " => children are not collected for deleted directory ");
                return;
            }
            if (recursive) {
                Iterator children = root.asDirectory().childEntries();
                while (children.hasNext()) {
                    ISVNEntry child = (ISVNEntry)children.next();
                    DebugLog.log("HV: processing " + entryPath + " => collecting child: " + child.getPath());
                    long childRevision = SVNProperty.longValue(child.getPropertyValue("svn:entry:revision"));
                    if (copy) {
                        DebugLog.log("HV: processing unmodified copied child " + child.getPath());
                        if (child.getPropertyValue("svn:entry:copyfrom-url") == null) {
                            String parentCopyFromURL = root.getPropertyValue("svn:entry:copyfrom-url");
                            child.setPropertyValue("svn:entry:copyfrom-url", PathUtil.append(parentCopyFromURL, PathUtil.encode(child.getName())));
                            child.setPropertyValue("svn:entry:copyfrom-rev", SVNProperty.toString(childRevision));
                        }
                    }
                    SVNCommitUtil.harvestCommitables(child, paths, recursive, modified);
                    if (!copy || modified.contains(child) || revision == childRevision) continue;
                    DebugLog.log("HV: copied child collected, revision differs from parent " + child.getPath());
                    modified.add(child);
                }
            }
        } else if (root.isScheduledForAddition() || root.isScheduledForDeletion() || root.isPropertiesModified() || root.asFile().isContentsModified()) {
            DebugLog.log("HV: processing " + entryPath + " => added to modified as file");
            modified.add(root);
        }
    }

    public static void doCommit(String path, String url, Map entries, ISVNEditor editor, SVNWorkspace ws, SVNProgressProcessor progressProcessor) throws SVNException {
        SVNCommitUtil.doCommit(path, url, entries, editor, ws, progressProcessor, new HashSet());
    }

    public static void doCommit(String path, String url, Map entries, ISVNEditor editor, SVNWorkspace ws, SVNProgressProcessor progressProcessor, Set committedPaths) throws SVNException {
        ISVNEntry root = (ISVNEntry)entries.get(path);
        String realPath = path;
        if (root != null && root.getAlias() != null) {
            path = PathUtil.append(PathUtil.removeTail(path), root.getAlias());
            path = PathUtil.removeLeadingSlash(path);
        }
        long revision = root == null ? -1L : SVNProperty.longValue(root.getPropertyValue("svn:entry:revision"));
        boolean copied = false;
        if (root != null) {
            root.setPropertyValue("svn:entry:committed-rev", null);
            copied = Boolean.TRUE.toString().equals(root.getPropertyValue("svn:entry:copied"));
        }
        if ("".equals(realPath) && !copied) {
            DebugLog.log("ROOT OPEN: " + path);
            editor.openRoot(-1L);
            if (root != null && root.sendChangedProperties(editor)) {
                ws.fireEntryCommitted(root, 6);
            }
        } else if (root != null && (root.isScheduledForAddition() || copied)) {
            if ("".equals(realPath)) {
                DebugLog.log("ROOT OPEN: " + path);
                editor.openRoot(-1L);
            }
            DebugLog.log("DIR ADD: " + path);
            String copyFromURL = root.getPropertyValue("svn:entry:copyfrom-url");
            long copyFromRevision = -1L;
            if (copyFromURL != null) {
                copyFromURL = SVNRepositoryLocation.parseURL(copyFromURL).toCanonicalForm();
                copyFromRevision = Long.parseLong(root.getPropertyValue("svn:entry:copyfrom-rev"));
                DebugLog.log("copyfrom path:" + copyFromURL);
                DebugLog.log("parent's url: " + url);
                copyFromURL = copyFromURL.substring(url.length());
                if (!copyFromURL.startsWith("/")) {
                    copyFromURL = "/" + copyFromURL;
                }
                DebugLog.log("copyfrom path:" + copyFromURL);
            }
            editor.addDir(path, copyFromURL, copyFromRevision);
            root.sendChangedProperties(editor);
            ws.fireEntryCommitted(root, 1);
        } else if (root != null && root.isPropertiesModified()) {
            DebugLog.log("DIR OPEN: " + path + ", " + revision);
            editor.openDir(path, revision);
            if (root.sendChangedProperties(editor)) {
                ws.fireEntryCommitted(root, 6);
            }
        } else if (root == null) {
            DebugLog.log("DIR OPEN (virtual): " + path + ", " + revision);
            editor.openDir(path, revision);
        }
        String[] virtualChildren = SVNCommitUtil.getVirtualChildren(entries, realPath);
        DebugLog.log("virtual children count: " + virtualChildren.length);
        for (int i = 0; i < virtualChildren.length; ++i) {
            String childPath = virtualChildren[i];
            SVNCommitUtil.doCommit(childPath, url, entries, editor, ws, progressProcessor, committedPaths);
        }
        ISVNEntry[] children = SVNCommitUtil.getDirectChildren(entries, realPath);
        DebugLog.log("direct children count: " + children.length);
        ISVNEntry parent = null;
        for (int i = 0; i < children.length; ++i) {
            String copyFromURL;
            ISVNEntry child = children[i];
            if (parent == null) {
                parent = ws.locateParentEntry(child.getPath());
            }
            String childPath = child.getAlias() != null ? PathUtil.append(path, child.getAlias()) : PathUtil.append(path, child.getName());
            String realChildPath = PathUtil.removeLeadingSlash(PathUtil.append(path, child.getName()));
            childPath = PathUtil.removeLeadingSlash(childPath);
            childPath = PathUtil.removeTrailingSlash(childPath);
            revision = SVNProperty.longValue(child.getPropertyValue("svn:entry:revision"));
            committedPaths.add(childPath);
            progressProcessor.setProgress((double)committedPaths.size() / (double)entries.keySet().size());
            if (child.isScheduledForAddition() && child.isScheduledForDeletion()) {
                DebugLog.log("FILE REPLACE: " + childPath);
                child.setPropertyValue("svn:entry:committed-rev", null);
                editor.deleteEntry(childPath, revision);
                SVNCommitUtil.updateReplacementSchedule(child);
                if (child.isDirectory()) {
                    SVNCommitUtil.doCommit(childPath, url, entries, editor, ws, progressProcessor, committedPaths);
                } else {
                    editor.addFile(childPath, null, -1L);
                    child.sendChangedProperties(editor);
                    child.asFile().generateDelta(editor);
                    editor.closeFile(null);
                }
                ws.fireEntryCommitted(child, 7);
                DebugLog.log("FILE REPLACE: DONE");
                continue;
            }
            if (child.isScheduledForDeletion()) {
                DebugLog.log("FILE DELETE: " + childPath);
                child.setPropertyValue("svn:entry:committed-rev", null);
                if (child.getPropertyValue(SVN_ENTRY_REPLACED) != null) {
                    DebugLog.log("FILE NOT DELETED, PARENT WAS REPLACED");
                    continue;
                }
                editor.deleteEntry(childPath, revision);
                ws.fireEntryCommitted(child, 3);
                DebugLog.log("FILE DELETE: DONE");
                continue;
            }
            if (child.isDirectory()) {
                SVNCommitUtil.doCommit(realChildPath, url, entries, editor, ws, progressProcessor, committedPaths);
                continue;
            }
            boolean childIsCopied = Boolean.TRUE.toString().equals(child.getPropertyValue("svn:entry:copied"));
            long copyFromRev = SVNProperty.longValue(child.getPropertyValue("svn:entry:copyfrom-rev"));
            String digest = null;
            if (childIsCopied && !child.isScheduledForAddition() && copyFromRev >= 0L) {
                DebugLog.log("FILE COPY: " + childPath);
                copyFromURL = child.getPropertyValue("svn:entry:copyfrom-url");
                if (copyFromURL != null) {
                    copyFromURL = SVNRepositoryLocation.parseURL(copyFromURL).toCanonicalForm();
                    DebugLog.log("copyfrom path:" + copyFromURL);
                    DebugLog.log("parent's url: " + url);
                    copyFromURL = copyFromURL.substring(url.length());
                    if (!copyFromURL.startsWith("/")) {
                        copyFromURL = "/" + copyFromURL;
                    }
                    DebugLog.log("copyfrom path:" + copyFromURL);
                }
                editor.addFile(childPath, copyFromURL, copyFromRev);
                editor.closeFile(null);
                ws.fireEntryCommitted(child, 1);
                DebugLog.log("FILE COPY: DONE");
            }
            if (child.isScheduledForAddition()) {
                DebugLog.log("FILE ADD: " + childPath);
                child.setPropertyValue("svn:entry:committed-rev", null);
                copyFromURL = child.getPropertyValue("svn:entry:copyfrom-url");
                long copyFromRevision = -1L;
                if (copyFromURL != null) {
                    copyFromURL = SVNRepositoryLocation.parseURL(copyFromURL).toCanonicalForm();
                    copyFromRevision = Long.parseLong(child.getPropertyValue("svn:entry:copyfrom-rev"));
                    DebugLog.log("copyfrom path:" + copyFromURL);
                    DebugLog.log("parent's url: " + url);
                    copyFromURL = copyFromURL.substring(url.length());
                    if (!copyFromURL.startsWith("/")) {
                        copyFromURL = "/" + copyFromURL;
                    }
                    DebugLog.log("copyfrom path:" + copyFromURL);
                }
                editor.addFile(childPath, copyFromURL, copyFromRevision);
                child.sendChangedProperties(editor);
                digest = child.asFile().generateDelta(editor);
                editor.closeFile(digest);
                ws.fireEntryCommitted(child, 1);
                DebugLog.log("FILE ADD: DONE");
                continue;
            }
            if (!child.asFile().isContentsModified() && !child.isPropertiesModified()) continue;
            DebugLog.log("FILE COMMIT: " + childPath + " : " + revision);
            child.setPropertyValue("svn:entry:committed-rev", null);
            editor.openFile(childPath, revision);
            child.sendChangedProperties(editor);
            if (child.asFile().isContentsModified()) {
                digest = child.asFile().generateDelta(editor);
            }
            editor.closeFile(digest);
            ws.fireEntryCommitted(child, 6);
            DebugLog.log("FILE COMMIT: DONE: " + digest);
        }
        DebugLog.log("DIR CLOSE: " + path);
        editor.closeDir();
        if ("".equals(realPath) && copied) {
            DebugLog.log("DIR CLOSE (ROOT) ");
            editor.closeDir();
        }
    }

    public static void updateWorkingCopy(SVNCommitInfo info, String uuid, Map commitTree, SVNWorkspace ws) throws SVNException {
        ISVNEntry entry;
        HashSet parents = new HashSet();
        LinkedList<ISVNEntry> sorted = new LinkedList<ISVNEntry>();
        Iterator<Object> entries = commitTree.values().iterator();
        while (entries.hasNext()) {
            entry = (ISVNEntry)entries.next();
            if (entry == null) continue;
            int index = 0;
            Iterator els = sorted.iterator();
            while (els.hasNext()) {
                ISVNEntry current = (ISVNEntry)els.next();
                if (entry.getPath().compareTo(current.getPath()) >= 0) {
                    sorted.add(index, entry);
                    entry = null;
                    break;
                }
                ++index;
            }
            if (entry == null) continue;
            sorted.add(entry);
        }
        entries = sorted.iterator();
        while (entries.hasNext()) {
            entry = (ISVNEntry)entries.next();
            if (entry == null) continue;
            SVNCommitUtil.updateWCEntry(entry, info, uuid, parents, ws);
        }
        entries = parents.iterator();
        while (entries.hasNext()) {
            ISVNEntry parent = (ISVNEntry)entries.next();
            if (commitTree.containsValue(parent)) continue;
            DebugLog.log("UPDATE (save): " + parent.getPath());
            parent.save(false);
        }
    }

    private static void updateWCEntry(ISVNEntry entry, SVNCommitInfo info, String uuid, Collection parents, SVNWorkspace ws) throws SVNException {
        ISVNEntry parent;
        String revStr = Long.toString(info.getNewRevision());
        entry.setPropertyValue("svn:entry:revision", revStr);
        if (entry.getPropertyValue("svn:entry:copied") != null && entry.isDirectory()) {
            DebugLog.log("PROCESSING COPIED DIR: " + entry.getPath());
            Iterator copied = entry.asDirectory().childEntries();
            while (copied.hasNext()) {
                ISVNEntry child = (ISVNEntry)copied.next();
                parents.add(child);
                DebugLog.log("PROCESSING COPIED CHILD: " + child.getPath());
                SVNCommitUtil.updateWCEntry(child, info, uuid, parents, ws);
            }
        }
        if ((parent = ws.locateParentEntry(entry.getPath())) != null) {
            parents.add(parent);
            if (entry.isScheduledForDeletion() && !entry.isScheduledForAddition()) {
                DebugLog.log("UPDATE (delete): " + entry.getPath());
                boolean storeInfo = entry.getPropertyValue(SVN_ENTRY_REPLACED) == null;
                parent.asDirectory().deleteChild(entry.getName(), storeInfo);
                return;
            }
        }
        if (entry.getPropertyValue("svn:entry:committed-rev") == null || entry.getPropertyValue("svn:entry:copied") != null) {
            entry.setPropertyValue("svn:entry:copied", null);
            entry.setPropertyValue("svn:entry:copyfrom-url", null);
            entry.setPropertyValue("svn:entry:copyfrom-rev", null);
            entry.setPropertyValue("svn:entry:schedule", null);
            entry.setPropertyValue("svn:entry:deleted", null);
            entry.setPropertyValue("svn:entry:committed-rev", revStr);
            entry.setPropertyValue("svn:entry:last-author", info.getAuthor());
            entry.setPropertyValue("svn:entry:committed-date", TimeUtil.formatDate(info.getDate()));
            entry.setPropertyValue("svn:entry:uuid", uuid);
        }
        if (parent != null) {
            parent.asDirectory().unschedule(entry.getName());
        }
        DebugLog.log("UPDATE (commit): " + entry.getPath());
        entry.commit();
    }

    private static void updateReplacementSchedule(ISVNEntry entry) throws SVNException {
        if ("replace".equals(entry.getPropertyValue("svn:entry:schedule"))) {
            entry.setPropertyValue("svn:entry:schedule", "add");
            if (entry.isDirectory()) {
                Iterator children = entry.asDirectory().childEntries();
                while (children.hasNext()) {
                    SVNCommitUtil.updateReplacementSchedule((ISVNEntry)children.next());
                }
            }
        } else if ("delete".equals(entry.getPropertyValue("svn:entry:schedule"))) {
            entry.setPropertyValue(SVN_ENTRY_REPLACED, "true");
        }
    }

    private static ISVNEntry[] getDirectChildren(Map map, String url) {
        ArrayList children = new ArrayList();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String childURL = (String)keys.next();
            String parentURL = PathUtil.removeTail(childURL);
            if ((parentURL = PathUtil.removeLeadingSlash(parentURL)) == null || !parentURL.equals(url) || map.get(childURL) == null || childURL.equals(url) || children.contains(map.get(childURL))) continue;
            children.add(map.get(childURL));
        }
        return children.toArray(new ISVNEntry[children.size()]);
    }

    private static String[] getVirtualChildren(Map map, String url) {
        ArrayList<String> children = new ArrayList<String>();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String childURL = (String)keys.next();
            if (!childURL.startsWith(url) || childURL.equals(url) || !(childURL = childURL.substring(url.length())).startsWith("/") && !"".equals(url)) continue;
            childURL = PathUtil.removeLeadingSlash(childURL);
            String vChild = PathUtil.append(url, PathUtil.head(childURL));
            if ((vChild = PathUtil.removeLeadingSlash(vChild)).equals(url) || map.get(vChild) != null || children.contains(vChild)) continue;
            children.add(vChild);
        }
        return children.toArray(new String[children.size()]);
    }
}

