/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.tmatesoft.svn.core.ISVNDirectoryEntry;
import org.tmatesoft.svn.core.ISVNEntry;
import org.tmatesoft.svn.core.ISVNFileEntry;
import org.tmatesoft.svn.core.ISVNRootEntry;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.internal.SVNExternal;
import org.tmatesoft.svn.core.internal.SVNWorkspace;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCommitInfo;
import org.tmatesoft.svn.core.io.SVNException;
import org.tmatesoft.svn.util.DebugLog;
import org.tmatesoft.svn.util.PathUtil;

public class SVNCheckoutEditor
implements ISVNEditor {
    private Stack myStack;
    private long myTargetRevision;
    private ISVNEntry myRootEntry;
    private ISVNFileEntry myCurrentFile;
    private List myDiffWindow;
    private ISVNWorkspaceMediator myMediator;
    private boolean myIsExport;
    private Map myChangedProperties;
    private Map myPropertiesMap;
    private int myContentsStatus;
    private int myPropertiesStatus;
    private boolean myIsTimestampsChanged;
    private SVNWorkspace myWorkspace;
    private long myUpdateTime;
    private int myFileCount;
    private Collection myExternals;
    private String myTarget;
    private boolean myIsRecursive;

    public SVNCheckoutEditor(ISVNWorkspaceMediator mediator, SVNWorkspace workspace, ISVNEntry rootEntry, boolean export, String target) {
        this(mediator, workspace, rootEntry, export, target, true);
    }

    public SVNCheckoutEditor(ISVNWorkspaceMediator mediator, SVNWorkspace workspace, ISVNEntry rootEntry, boolean export, String target, boolean recursive) {
        this.myRootEntry = rootEntry;
        this.myStack = new Stack();
        this.myMediator = mediator;
        this.myWorkspace = workspace;
        this.myIsExport = export;
        this.myTargetRevision = -1L;
        this.myPropertiesMap = new HashMap();
        this.myTarget = target;
        this.myIsRecursive = recursive;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        if (this.myTarget == null) {
            this.myRootEntry.setPropertyValue("svn:entry:committed-rev", SVNProperty.toString(revision));
        }
        this.myStack.push(this.myRootEntry);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        DebugLog.log("DELETE ENTRY: " + path + " : " + revision);
        this.myWorkspace.fireEntryUpdated(this.getCurrentEntry().getChild(PathUtil.tail(path)), 3, 3, revision);
        this.getCurrentEntry().deleteChild(PathUtil.tail(path), true);
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyPath, long copyRevision) throws SVNException {
        DebugLog.log("UPDATED: ADD DIR: " + path);
        ISVNDirectoryEntry newDir = this.getCurrentEntry().addDirectory(PathUtil.tail(path), -1L);
        this.myStack.push(newDir);
        newDir.setPropertyValue("svn:entry:revision", "0");
        this.getCurrentProperties().put("added", "true");
        this.myWorkspace.fireEntryUpdated(newDir, 1, 0, this.myTargetRevision);
        this.myIsTimestampsChanged = !this.myIsExport;
    }

    public void openDir(String path, long revision) throws SVNException {
        String name = PathUtil.tail(path);
        ISVNEntry dir = this.getCurrentEntry().getChild(name);
        if (dir != null) {
            this.myStack.push(dir);
        }
    }

    public void changeDirProperty(String name, String value) throws SVNException {
        if (!this.myIsExport) {
            this.getCurrentProperties().put(name, value);
            if ("svn:externals".equals(name) && value != null) {
                this.myExternals = SVNExternal.create(this.getCurrentEntry(), value, this.myExternals);
            }
            this.myIsTimestampsChanged = true;
        }
        DebugLog.log("UPDATED: DIR PROPERTY CHANGED");
    }

    public void closeDir() throws SVNException {
        boolean wasAdded;
        int propsStatus = 0;
        boolean bl = wasAdded = this.getCurrentProperties().remove("added") != null;
        if (!this.myIsExport) {
            if (this.myTarget == null || this.getCurrentEntry() != this.myRootEntry) {
                this.getCurrentProperties().put("svn:entry:revision", Long.toString(this.myTargetRevision));
                propsStatus = this.getCurrentEntry().applyChangedProperties(this.getCurrentProperties());
            }
            this.myPropertiesMap.remove(this.getCurrentEntry());
        }
        if (propsStatus != 0) {
            long revision = SVNProperty.longValue(this.getCurrentEntry().getPropertyValue("svn:entry:committed-rev"));
            if (!wasAdded) {
                this.myWorkspace.fireEntryUpdated(this.getCurrentEntry(), 0, propsStatus, revision);
            }
        }
        if (this.myIsExport) {
            ((ISVNRootEntry)this.myRootEntry).deleteAdminFiles(this.getCurrentEntry().getPath());
        }
        DebugLog.log("UPDATED: CLOSED DIR: " + this.getCurrentEntry().getPath());
        this.myStack.pop();
    }

    public void addFile(String path, String copyPath, long copyRevision) throws SVNException {
        DebugLog.log("UPDATED: ADD FILE: " + path);
        this.myCurrentFile = this.getCurrentEntry().addFile(PathUtil.tail(path), -1L);
        if (!this.myIsExport) {
            this.myChangedProperties = new HashMap();
        }
        this.myCurrentFile.setPropertyValue("svn:entry:revision", "0");
        this.myContentsStatus = 1;
        this.myIsTimestampsChanged = !this.myIsExport;
        DebugLog.log("UPDATED: FILE ADDED");
    }

    public void openFile(String path, long revision) throws SVNException {
        String name = PathUtil.tail(path);
        this.myCurrentFile = (ISVNFileEntry)this.getCurrentEntry().getChild(name);
        if (!this.myIsExport) {
            this.myChangedProperties = new HashMap();
        }
        this.myIsTimestampsChanged = !this.myIsExport;
    }

    public void closeFile(String textChecksum) throws SVNException {
        if (this.myContentsStatus == 19) {
            DebugLog.log("UPDATED: CLOSE FILE: skipping corrupted file: " + this.myCurrentFile.getPath());
            this.myCurrentFile = null;
            this.myPropertiesStatus = 0;
            this.myContentsStatus = 0;
            return;
        }
        if (!this.myIsExport) {
            this.myChangedProperties.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            if (this.myChangedProperties.get("svn:entry:url") == null) {
                ISVNDirectoryEntry parent = (ISVNDirectoryEntry)this.myStack.peek();
                this.myChangedProperties.put("svn:entry:url", PathUtil.append(parent.getPropertyValue("svn:entry:url"), PathUtil.encode(this.myCurrentFile.getName())));
            }
            this.myChangedProperties.put("svn:entry:checksum", textChecksum);
            this.myPropertiesStatus = this.myCurrentFile.applyChangedProperties(this.myChangedProperties);
            this.myChangedProperties = null;
        }
        long revision = SVNProperty.longValue(this.myCurrentFile.getPropertyValue("svn:entry:committed-rev"));
        this.myWorkspace.fireEntryUpdated(this.myCurrentFile, this.myContentsStatus, this.myPropertiesStatus, revision);
        DebugLog.log("UPDATED: CLOSED FILE: " + this.myCurrentFile.getPath());
        this.myContentsStatus = 0;
        this.myPropertiesStatus = 0;
        this.myCurrentFile = null;
    }

    public void applyTextDelta(String baseChecksum) throws SVNException {
        if (this.myContentsStatus == 0 && this.myCurrentFile.isCorrupted()) {
            this.myCurrentFile.setPropertyValue("svn:entry:corrupted", Boolean.TRUE.toString());
            this.myWorkspace.fireEntryUpdated(this.myCurrentFile, 19, this.myPropertiesStatus, this.myTargetRevision);
            this.myContentsStatus = 19;
        }
    }

    public OutputStream textDeltaChunk(SVNDiffWindow diffWindow) throws SVNException {
        if (this.myContentsStatus == 19) {
            DebugLog.log("UPDATED: TEXTDELTACHUNK: skipping corrupted file: " + this.myCurrentFile.getPath());
            return null;
        }
        DebugLog.log("UPDATED: TEXTDELTACHUNK: " + this.myCurrentFile.getPath());
        if (this.myDiffWindow == null) {
            this.myDiffWindow = new LinkedList();
        }
        this.myDiffWindow.add(diffWindow);
        try {
            OutputStream outputStream = this.myMediator.createTemporaryLocation(this.myCurrentFile.getPath(), diffWindow);
            return outputStream;
        }
        catch (Throwable e) {
            DebugLog.error(e);
            throw new SVNException(e);
        }
        finally {
            DebugLog.log("UPDATED: TEXTDELTACHUNK: SAVED");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void textDeltaEnd() throws SVNException {
        if (this.myContentsStatus == 19) {
            DebugLog.log("UPDATED: TEXTDELTAEND: skipping corrupted file: " + this.myCurrentFile.getPath());
            return;
        }
        DebugLog.log("UPDATED: APPLING DELTA: " + this.myCurrentFile.getPath());
        int status = 0;
        long t = System.currentTimeMillis();
        if (this.myDiffWindow == null) {
            DebugLog.log("UPDATED: NO DIFF WINDOW TO APPLY");
            this.myCurrentFile.applyDelta(null, null, this.myIsExport);
        } else {
            DebugLog.log("UPDATED: APPLYING DIFF WINDOWS: " + this.myDiffWindow.size());
            for (int i = 0; i < this.myDiffWindow.size(); ++i) {
                SVNDiffWindow window;
                block14: {
                    IOException e12;
                    Object var9_6;
                    window = (SVNDiffWindow)this.myDiffWindow.get(i);
                    InputStream newData = null;
                    try {
                        try {
                            newData = this.myMediator.getTemporaryLocation(window);
                            this.myCurrentFile.applyDelta(window, newData, this.myIsExport);
                        }
                        catch (IOException e) {
                            DebugLog.error(e);
                            throw new SVNException(e);
                        }
                        catch (SVNException e) {
                            DebugLog.error(e);
                            throw e;
                        }
                        catch (Throwable th) {
                            DebugLog.error(th);
                            throw new SVNException(th);
                        }
                        var9_6 = null;
                        if (newData == null) break block14;
                    }
                    catch (Throwable throwable) {
                        var9_6 = null;
                        if (newData == null) throw throwable;
                        try {
                            newData.close();
                            throw throwable;
                        }
                        catch (IOException e12) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e12) {}
                    newData.close();
                }
                this.myMediator.deleteTemporaryLocation(window);
            }
            this.myDiffWindow = null;
        }
        status = this.myCurrentFile.deltaApplied(this.myIsExport);
        if (this.myContentsStatus == 0) {
            this.myContentsStatus = status;
        }
        this.myUpdateTime += System.currentTimeMillis() - t;
        ++this.myFileCount;
        DebugLog.log("UPDATED: DELTA APPLIED: " + this.myCurrentFile.getPath());
    }

    public void changeFileProperty(String name, String value) throws SVNException {
        if (!this.myIsExport) {
            this.myChangedProperties.put(name, value);
        } else {
            this.myCurrentFile.setPropertyValue(name, value);
        }
        this.myIsTimestampsChanged = !this.myIsExport;
        DebugLog.log("UPDATED: FILE PROPERTY CHANGED");
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myFileCount > 0) {
            DebugLog.benchmark("UPDATED IN " + this.myUpdateTime / (long)this.myFileCount + " ms. (" + this.myFileCount + ")");
        }
        long start = System.currentTimeMillis();
        if (!this.myIsExport) {
            if (this.myTarget == null) {
                this.myRootEntry.merge(this.myIsRecursive);
            } else {
                DebugLog.log("UPDATED: MERGING TARGET: " + this.myTarget);
                ISVNEntry targetEntry = this.myRootEntry.asDirectory().getChild(this.myTarget);
                if (targetEntry != null) {
                    if (targetEntry.getPropertyValue("svn:entry:revision") == null) {
                        this.myRootEntry.asDirectory().deleteChild(targetEntry.getName(), true);
                        DebugLog.log("UPDATED: TARGET DELETED");
                    } else {
                        targetEntry.merge(this.myIsRecursive);
                        DebugLog.log("UPDATED: TARGET MERGED");
                    }
                }
                this.myRootEntry.save(false);
                DebugLog.log("UPDATED: PARENT SAVED");
            }
        }
        this.myRootEntry.dispose();
        this.myStack.clear();
        DebugLog.benchmark("MERGED IN " + (System.currentTimeMillis() - start) + " ms.");
        DebugLog.log("CLOSE EDIT");
        return new SVNCommitInfo(this.myTargetRevision, null, null);
    }

    public void abortEdit() throws SVNException {
        DebugLog.error("ABORT EDIT");
        this.myRootEntry.dispose();
        this.myStack.clear();
    }

    public boolean isTimestampsChanged() {
        return this.myIsTimestampsChanged;
    }

    public Collection getExternals() {
        return this.myExternals == null ? Collections.EMPTY_SET : this.myExternals;
    }

    private ISVNDirectoryEntry getCurrentEntry() {
        return (ISVNDirectoryEntry)this.myStack.peek();
    }

    private Map getCurrentProperties() {
        if (!this.myPropertiesMap.containsKey(this.getCurrentEntry())) {
            this.myPropertiesMap.put(this.getCurrentEntry(), new HashMap());
        }
        return (Map)this.myPropertiesMap.get(this.getCurrentEntry());
    }
}

